#!/usr/bin/python
# shm, sika hosting manager
# author: Ondrej Sika
#         http://ondrejsika.com
#         dev@ondrejsika.com

from conf import MYSQL_USER, MYSQL_PASSWD

from ..utils import mysql, name2key

def username(hosting_name):
    name = name2key(hosting_name)
    if len(name) <= 16:
            return name
    else:
        import hashlib
        return "%s%s" % (name[:10], hashlib.sha1(name).hexdigest()[:6])

def create_user(hosting_name, passwd):
    mysql_user = username(hosting_name)
    mysql("CREATE USER '%s'@'%%' IDENTIFIED BY  '%s'; GRANT USAGE ON * . * TO '%s'@'%%' IDENTIFIED BY  '%s' WITH MAX_QUERIES_PER_HOUR 0 MAX_CONNECTIONS_PER_HOUR 0 MAX_UPDATES_PER_HOUR 0 MAX_USER_CONNECTIONS 0 ; GRANT ALL PRIVILEGES ON  \`%s_\\%%\` . * TO '%s'@'%%';"%(mysql_user, passwd, mysql_user, passwd, mysql_user, mysql_user), MYSQL_USER, MYSQL_PASSWD)