#!/usr/bin/python
# shm, sika hosting manager
# author: Ondrej Sika
#         http://ondrejsika.com
#         dev@ondrejsika.com

from conf import WWW, APACHE2_SITE

from ..utils import normpath

def base_dir(hosting_name):
    return normpath(WWW, hosting_name)

def www(hosting_name):
    return normpath(base_dir(hosting_name), "www")

def conf(hosting_name, conf_file=""):
    return normpath(base_dir(hosting_name), "conf", conf_file)

def apache2_site(hosting_name):
    return normpath(APACHE2_SITE, hosting_name)