#!/usr/bin/python
# shm, sika hosting manager
# author: Ondrej Sika
#         http://ondrejsika.com
#         dev@ondrejsika.com

import os
import sys

normpath = lambda *args: os.path.normpath(os.path.abspath(os.path.join(*args)))

def stderr(message):
    sys.stderr.write(message+"\n")

def system(cmd):
    return os.popen(cmd).read()

def name2key(name):
    return name.replace("-", "_").replace(".", "__")

def key2name(key):
    return key.replace("__", ".").replace("_", "-")

def change_passwd(username, passwd):
    system("echo '%s\n%s' | passwd %s"%(passwd, passwd, username))

def useradd(username, home, passwd=None, shell="/usr/sbin/nologin"):
    system("useradd -s %s -d %s %s"%(shell, home, username))
    if passwd:
        change_passwd(username, passwd)

def mysql(cmd, user, passwd=None):
    if passwd:
        return system('mysql -u %s -p%s -e "%s"'%(user, passwd, cmd))
    return system('mysql -u %s -e "%s"'%(user, cmd))