#!/usr/bin/python
# shm, sika hosting manager
# author: Ondrej Sika
#         http://ondrejsika.com
#         dev@ondrejsika.com

from libshm.php import path, templates
from libshm.php.path import www, base_dir, conf
from libshm.utils import stderr, name2key, useradd, change_passwd
from libshm.php.mysql import create_user


def create_apache2(hosting_name):
    try:
        f = file(path.apache2_site(hosting_name), "w")
        f.write(templates.apache2_site(hosting_name))
        f.close()
    except IOError:
        stderr("Permission denied: '%s'"%path.apache2_site(hosting_name))

def create_base(hosting_name):
    import os
    try:
        os.makedirs(www(hosting_name))
        os.makedirs(conf(hosting_name))
    except OSError:
        stderr("Permission denied: '%s'"%www(hosting_name))
        exit()
    useradd(name2key(hosting_name), base_dir(hosting_name))

def create_mysql(hosting_name, passwd=None):
    import hashlib

    if not passwd:
        passwd = hashlib.sha1(hosting_name).hexdigest()[:6]

    create_user(hosting_name, passwd)
    print("passwd: %s" % passwd)

def update_syspasswd(hosting_name, passwd):
    change_passwd(name2key(hosting_name), passwd)
