import unittest
import uuid

from libtng import cqrs, entity

from base import gateway


RETVAL = uuid.uuid1().hex


class TestCommand(cqrs.Command):

    def __init__(self, integer_argument):
        self._integer_argument = integer_argument

    class Meta:
        immutable = True


@cqrs.handles(TestCommand)
class TestCommandHandler(cqrs.CommandHandler):

    def handle(self, command):
        return RETVAL



class SimpleCommandTestCase(unittest.TestCase):

    def get_command(self):
        return TestCommand(integer_argument=1)

    def test_dispatch(self):
        result = gateway.dispatch(self.get_command())
        self.assertEqual(RETVAL, result)


if __name__ == '__main__':
    unittest.main()