import unittest
import uuid
import os
import shutil

from libtng import cqrs, entity, mock

from base import gateway



class TestCommand(cqrs.Command):
    filepath = entity.StringProperty(identity=True, public_getter=True)



@cqrs.handles(TestCommand)
class TestCommandHandler(cqrs.CommandHandler):

    def handle(self, command):
        state = command.state
        state.set_flag('DIRECTORY_EXISTED', os.path.exists(command.filepath))
        if not state.get_flag('DIRECTORY_EXISTED'):
            os.makedirs(command.filepath)
            state.set_status(command.FINISHED)
        else:
            state.set_status(command.STALE)

    def rollback(self, command):
        state = command.state
        if state.status != command.FINISHED:
            return
        if not state.get_flag('DIRECTORY_EXISTED'):
            shutil.rmtree(command.filepath)


class SimpleCommandTestCase(unittest.TestCase):

    def get_command(self):
        return TestCommand.create(filepath=mock.get_random_tempdir())

    def test_rollback(self):
        command = self.get_command()
        result = gateway.dispatch(command)
        self.assertTrue(os.path.exists(command.filepath))

        gateway.rollback(command)
        self.assertTrue(not os.path.exists(command.filepath))


if __name__ == '__main__':
    unittest.main()