import unittest

from libtng import cqrs, entity

from base import gateway



class TestCommand(cqrs.Command):
    __unique__ = True

    def __init__(self, identifier_p1, identifier_p2):
        self._identifier_p1 = identifier_p1
        self._identifier_p2 = identifier_p2

    def __hash__(self):
        return hash((self._identifier_p1, self._identifier_p2))

    class Meta:
        unique = True

@cqrs.handles(TestCommand)
class TestCommandHandler(cqrs.CommandHandler):

    def handle(self, command):
        pass



class UniqueCommandTestCase(unittest.TestCase):

    def setUp(self):
        gateway.purge_history()

    def test_hash(self):
        c1 = TestCommand(identifier_p1=1, identifier_p2=1)
        c2 = TestCommand(identifier_p1=1, identifier_p2=1)
        self.assertEqual(hash(c1), hash(c2))

    def test_gateway_raises_error_on_duplicate_unique(self):
        c1 = TestCommand(identifier_p1=1, identifier_p2=1)
        c2 = TestCommand(identifier_p1=1, identifier_p2=1)
        gateway.dispatch(c1)
        self.assertRaises(cqrs.CommandAlreadyHandled, gateway.dispatch, c2)

    def test_can_dispatch_after_purge(self):
        c1 = TestCommand(identifier_p1=1, identifier_p2=1)
        c2 = TestCommand(identifier_p1=1, identifier_p2=1)
        gateway.dispatch(c1)
        gateway.purge_history()
        gateway.dispatch(c2)

    # def test_transaction_unique(self):
    #     c1 = TestCommand(identifier_p1=1, identifier_p2=1)
    #     c2 = TestCommand(identifier_p1=1, identifier_p2=1)
    #     t = cqrs.Transaction(gateway)
    #     t.append(c1)
    #     self.assertRaises(cqrs.DuplicateCommandError, t.append, c2)

    def test_transaction_unique_silent1(self):
        c1 = TestCommand(identifier_p1=1, identifier_p2=1)
        c2 = TestCommand(identifier_p1=1, identifier_p2=1)
        t = cqrs.Transaction(gateway, ignore_unique=True)
        t.append(c1)
        try:
            result = t.append(c2)
        except cqrs.DuplicateCommandError:
            raise AssertionError("Should not raise DuplicateCommandError")

if __name__ == '__main__':
    unittest.main()