import abc

from libtng import six
from libtng.ddd.domain.repository.meta import RepositoryMeta



class Repository(six.with_metaclass(RepositoryMeta)):

    def __new__(cls, *args, **kwargs):
        instance = super(Repository, cls).__new__(cls, *args, **kwargs)
        instance._cache = type(instance)._cache
        return instance

    @abc.abstractmethod
    def persist(self, instance):
        """Persists a domain object."""
        raise NotImplementedError("Subclasses must override this method.")

    @abc.abstractmethod
    def get_by_identifier(self):
        """Returns a domain entity by it's identifier."""
        raise NotImplementedError("Subclasses must override this method.")