import threading


class RepositoryCache(object):
    """Caches domain entities in the local thread."""

    @property
    def cache(self):
        return self.__local.cache

    @property
    def identifier_map(self):
        return self.__local.identifier_map

    def __init__(self):
        self.__local = threading.local()
        self.__local.cache = {}
        self.__local.identifier_map = {}

    def map_identifier(self, identifier, *args):
        """Maps an identifier to args. This allows a method such as
        `get_by_email_address` to map the identifier to input arguments
        and allow it to be cached.
        """
        self.identifier_map[identifier] = args

    def set(self, identifier, instance):
        """Caches a domain entity."""
        self.cache[identifier] = instance

    def get(self, identifier):
        """Get a domain entity by it's identifier."""
        return self.cache.get(identifier)