import socket

from libtng import ipaddress
from libtng import six

from base import DomainProperty, InvalidStateError


__all__ = ['InternetProtocolAddressProperty']


class InternetProtocolAddressProperty(DomainProperty):

    def clean(self, new, *args, **kwargs):
        if new is not None:
            try:
                new =  socket.gethostbyname(new)
            except socket.gaierror:
                raise InvalidStateError('Unresolvable hostname or IP-address: {0}'.format(new))
            if isinstance(new, six.string_types):
                new = ipaddress.ip_address(new)
        return new