from threading import local


class EntityState(object):
    """
    Keeps the internal state of a :class:`libtng.entity.Entity`.
    """

    def __init__(self, instance):
        self.__properties = {}
        self.__instance = instance
        self.__meta = instance._meta
        self.__threadlocal = local()

    def set_private_caller(self, value):
        """
        Sets the caller state to the specified `value` for the
        current thread.
        """
        setattr(self.__threadlocal,'is_private_caller', value)

    def is_private_caller(self):
        """
        Return a bool if the caller is private (i.e. an instance method).
        """
        return getattr(self.__threadlocal, 'is_private_caller', False)

    def set_prop(self, prop_name, value):
        """
        Sets the instances prop `prop_name` to `value`.
        The value is assumed to be validated.
        """
        self.__properties[prop_name] = value

    def get_prop(self, prop_name):
        """
        Retuns the value of prop `prop_name`.
        """
        return self.__properties.get(prop_name)

    def validate(self):
        return self.__meta.validator.validate_state(self)