import copy


class Authorization(object):
    """
    Represents the contents of an HTTP ``Authorization``
    header.
    """

    def __init__(self, scheme, params):
        """
        Initializes a new :class:`Authorization` instance.

        Args:
            scheme (str): a string specifying the authentication
                scheme used.
            params: the parameters provided in the ``Authorization``
                header.
        """
        self._scheme = scheme
        self._params = params

    def as_dict(self):
        """Return the contents of the `` Authorization`` header as a
        Python dictionary.
        """
        params = copy.deepcopy(self._params)
        params['scheme'] = self._scheme
        return params

    def __iter__(self):
        return iter([self._scheme, self._params])