from libtng.ioc.provider import provider


class Dependency(object):
    """Declares a dependency."""

    @property
    def feature(self):
        return provider.get(self._key)

    def __init__(self, key, methods=None):
        """
        Initialize a new :class:`Dependency`.

        Args:
            key: specifies an identifier.

        Kwargs:
            method: specifies a list of method names that the
                dependency must declare.
        """
        self._key = key
        self._methods = methods or []

    def __repr__(self):
        return provider.get(self._key).__repr__()

    def __call__(self, *args, **kwargs):
        return provider.get(self._key)(*args, **kwargs)

    def __class__(self):
        return self.feature.__class__