import unittest

from libtng import entity


__all__ = ['SinglePropIdentityTestCase']


class SinglePropIdentityEntity(entity.Entity):
    ident = entity.IntegerProperty(identity=True)


class MultiPropIdentityEntity(entity.Entity):
    ident1 = entity.IntegerProperty(identity=True)
    ident2 = entity.IntegerProperty(identity=True)



class SinglePropIdentityTestCase(unittest.TestCase):

    def test_eq1(self):
        obj1 = SinglePropIdentityEntity(ident=1)
        obj2 = SinglePropIdentityEntity(ident=1)
        self.assertEqual(obj1, obj2)

    def test_eq2(self):
        obj1 = SinglePropIdentityEntity(ident=1)
        obj2 = SinglePropIdentityEntity(ident=2)
        self.assertNotEqual(obj1, obj2)

    def test_in(self):
        obj1 = SinglePropIdentityEntity(ident=1)
        obj2 = SinglePropIdentityEntity(ident=2)
        col = [obj1, obj2]
        self.assertTrue(obj1 in col)


if __name__ == '__main__':
    unittest.main()