import copy


class Settings(object):
    defaults = {

    # Internationalization and localization settings
    'USE_TZ'        : True,
    'TIME_ZONE'     : 'Europe/Amsterdam',
    'USE_I18N'      : True,
    'USE_L10N'      : True,
    'LANGUAGE_CODE' : 'en-us'

    }


    def __init__(self):
        self.settings = copy.deepcopy(self.defaults)

    def set(self, key, value):
        self.settings[key] = value

    def __getattr__(self, attname):
        try:
            return self.settings[attname]
        except KeyError:
            raise AttributeError


settings = Settings()



def get_version():
    return '0.2.2'