


class DependencyProvider(object):
    """A registry for the dependencies."""

    def __init__(self):
        self.__registry = {}

    def provide(self, key, feature):
        """Registers a feature that the regsistry provides."""
        self.__registry[key] = feature

    def get(self, key):
        """Returns a registered feature."""
        return self.__registry[key]


provider = DependencyProvider()