import collections

from libtng import six

from libtng.ddd.domain.entity.meta import EntityMeta


class Entity(six.with_metaclass(EntityMeta)):

    @classmethod
    def configure(cls, **kwargs):
        """Configures runtime.

        Kwargs:
            repository: a repository instance.

        """
        if 'repository' in kwargs:
            cls.repository = kwargs['repository']
            kwargs['repository'].entity_type = cls
        if 'factory' in kwargs:
            cls.factory = kwargs['factory']
            kwargs['factory'].entity_type = cls

    def get_identity(self):
        """Return a :class:`namedtuple` representing the identity
        of the domain object."""
        raise NotImplementedError

    def __hash__(self):
        ident = self.get_identity()
        assert all([isinstance(x, collections.Hashable) for x in ident]),\
            "All members of the identity should be hashable."
        return hash(ident)

    def __repr__(self):
        return "{0}{1}".format(self.__class__.__name__,
            tuple(self.get_identity()).__repr__())