import abc

from libtng import six
from libtng.exceptions import NOTIMPLEMENTED_SUBCLASS


class Factory(six.with_metaclass(abc.ABCMeta)):

    @abc.abstractmethod
    def create(self, *args, **kwargs):
        """Create a new instance of the domain model specified for
        the factory."""
        raise NOTIMPLEMENTED_SUBCLASS

    def __call__(self, *args, **kwargs):
        return self.create(*args, **kwargs)