import unittest

from libtng import entity


__all__ = ['EntityRequiredAttributeTestCase']


class TestRequiredEntity(entity.Entity):
    non_required    = entity.IntegerProperty(required=False)
    required        = entity.IntegerProperty(required=True)
    default_required= entity.IntegerProperty(required=True, default=2, default_on_init=True)


class EntityRequiredAttributeTestCase(unittest.TestCase):

    def test_can_init_with_missing(self):
        try:
            instance = TestRequiredEntity.create(required=True)
        except entity.InvalidStateError as e:
            raise AssertionError(str(e))


    def test_can_not_init_with_missing_required_attribute(self):
        self.assertRaises(entity.InvalidStateError, TestRequiredEntity.create, non_required=1)

    def test_can_init_with_required_missing_and_property_default(self):
        try:
            instance = TestRequiredEntity.create(required=1)
        except entity.InvalidStateError as e:
            raise AssertionError(str(e))


if __name__ == '__main__':
    unittest.main()