from base import DomainProperty, InvalidStateError


__all__ = ['EntityProperty']


class EntityProperty(DomainProperty):

    def __init__(self, cls, *args, **kwargs):
        self.referenced_entity = cls
        DomainProperty.__init__(self, *args, **kwargs)

    def clean(self, new, *args, **kwargs):
        if not isinstance(new, self.referenced_entity):
            raise InvalidStateError("Invalid object type: {0}".format(type(new)))
        return super(EntityProperty, self).clean(new, *args, **kwargs)