import functools

from libtng.ioc.provider import provider as _provider
from libtng.ioc.dependency import Dependency
from libtng.ioc.exceptions import MissingDependency


provide = _provider.provide
specify = _provider.specify



def instance_requires(key, override=None):
    """
    Class decorator that requires dependency `key` to be injected
    on initialization-time.

    Args:
        key (str): identifies the required dependency.
        override (str): if object has an attribute named `override`
            after initialization, the dependency is considered met.

    Returns:
        type
    """
    def outer(cls):
        @functools.wraps(cls)
        def inner(*args, **kwargs):
            obj = cls(*args, **kwargs)
            if not _provider.is_provided(key)\
            or (override and not hasattr(obj, override)):
                raise MissingDependency(key)
            return obj
        return inner
    return outer