from libtng.ioc.provider import provider


class Dependency(object):
    """Declares a dependency."""

    @property
    def feature(self):
        return provider.get(self._key)

    def __init__(self, key, methods=None, call=False):
        """
        Initialize a new :class:`Dependency`.

        Args:
            key: specifies an identifier.
            methods: specifies a list of method names that the
                dependency must declare.
            call (bool): indicates if the feature should be called.
        """
        self._key = key
        self._methods = methods or []
        self._call = call

    def __repr__(self):
        return provider.get(self._key).__repr__()

    def __call__(self, *args, **kwargs):
        return provider.get(self._key)(*args, **kwargs)

    def __class__(self):
        return self.feature.__class__