from libtng.functional import SimpleLazyObject
from libtng.ioc.specification import Specification


class DependencyProvider(object):
    """A registry for the dependencies."""

    def __init__(self):
        self.__registry = {}
        self.__specs = set()

    def get(self, key, call=False):
        return self.__registry[key]

    def provide(self, key, feature):
        """Registers a feature that the regsistry provides."""
        self.__registry[key] = SimpleLazyObject(feature)

    def is_provided(self, key):
        """Return a :class:`bool` indicating if the specified dependency
        is provided."""
        return key in self.__registry

    def specify(self, key, *args, **kwargs):
        """
        Specifies that the current runtime requires a dependency
        identified by `key`.

        Args:
            key (str): key identifying the dependency.
        """
        self.__specs.add(Specification(key, *args, **kwargs))


provider = DependencyProvider()