


class Specification(object):
    """
    Represents a formal specification of a dependency.
    """

    def __init__(self, key, *args, **kwargs):
        self.key = key

    def is_provided(self, provider):
        raise NotImplementedError

    def __hash__(self):
        return hash(self.key)

    def __eq__(self, other):
        return isinstance(type(self), other)\
            and hash(self) == hash(other)