import abc
import collections
import threading

from libtng import six
from libtng import timezone
from libtng.cqrs.runner import Runner

from libtng.cqrs.exceptions import DuplicateCommand


__all__ = [
    'CommandExecution'
]


class IGateway(six.with_metaclass(abc.ABCMeta)):

    def __init__(self, runner=None):
        self._runner = runner or Runner()

    @abc.abstractmethod
    def dispatch(self, command, *args, **kwargs):
        """
        Executes the given command.
        """
        pass

    def put(self, command):
        return self.run(command)

    def run(self, command):
        command.set_result(self._runner.run(self, command))