import collections

from libtng import six

from libtng.provisioning.host import Host


class HostCollection(collections.Sequence, collections.Mapping):

    def __init__(self, initial=None):
        """
        Initializes a new :class:`HostCollection` instance.

        :param initial:
            an initial list of :class:`~libtng.provisioning.Host`
            instances to add to the :class:`HostCollection`.
        """
        self._hosts = collections.OrderedDict()
        for host in (initial or []):
            host.add_to_collection(self)

    def add(self, hostname, host):
        """
        Adds a :class:`~libtng.provisioning.Host` instance to the
        collection.
        """
        self[hostname] &= host

    def __getitem__(self, hostname):
        try:
            return self._hosts[hostname]
        except KeyError:
            self._hosts[hostname] = Host(hostname, ['all'], {})
        return self._hosts[hostname]

    def __setitem__(self, hostname, host):
        if hostname not in self._hosts:
            self._hosts[hostname] = host
        self._hosts[hostname] &= host

    def __len__(self):
        return len(self._hosts)

    def __iter__(self):
        return iter(self._hosts.values())