import datetime

from libtng.cqrs.const import PENDING
from libtng.cqrs.const import ACCEPTED
from libtng.cqrs.const import REJECTED
from libtng.cqrs.const import FINISHED
from libtng.cqrs.const import FAILED
import libtng.io


class CommandMetadata(libtng.io.Serializable):
    """Represents the metadata attached to a
    :class:`libtng.cqrs.Command` instance."""

    def __init__(self, command):
        self._command = command
        self._invoked = datetime.datetime.utcnow()
        self._dispatched = None
        self._accepted = None
        self._route = []
        self._finished = None
        self._state = PENDING
        self._user = None
        self._client = None
        self._authorization = None

    def as_dict(self):
        """Convert a :class:`CommandMetadata` instance to
        a Python dictionary.
        """
        return {
            'invoked'       : str(self._invoked) if self._invoked else None,
            'dispatched'    : str(self._dispatched) if self._dispatched else None,
            'accepted'      : str(self._accepted) if self._accepted else None,
            'route'         : self._route,
            'finished'      : str(self._finished) if self._finished else None,
            'state'         : self._state,
            'user'          : self._user,
            'client'        : self._client,
            'authorization' : self._authorization
        }

    def set_state(self, state):
        """Set the command execution state.

        Args:
            state (int): specifies the state.

        Returns:
            None
        """
        self._state = state