import abc

from libtng import six


class Listener(six.with_metaclass(abc.ABCMeta)):

    @property
    def qualified_name(self):
        return '.'.join([type(self).__module__, type(self).__name__])

    @abc.abstractmethod
    def can_handle(self, event, **kwargs):
        """Return a boolean indicating if the listener can handle the event."""
        raise NotImplementedError

    @abc.abstractmethod
    def handle(self, event, **kwargs):
        """Handles the event."""
        raise NotImplementedError

    def __hash__(self):
        return hash(self.qualified_name)

    def __eq__(self):
        type(self) == type(other)

    def __call__(self, publisher, event):
        if self.can_handle(event):
            self.handle(event)