"""
Object framework to create public and private attributes,
including domain validation.
"""
import functools

from base import Entity, BaseEntity, EntityMeta, EntityBaseMeta,\
    PrivateMethod, privatemethod
from props import *



def inject_state(func):
    """
    Decorator for :class:`~libtng.entity.Entity` subclasses that
    inserts the :class:`~libtng.entity.state.EntityState` into
    the arguments passed to the method.
    """
    @functools.wraps(func)
    def wrapper(self, *args, **kwargs):
        return func(self, self._state, *args, **kwargs)
    return wrapper
