import unittest

from libtng import entity


__all__ = ['SubclassingTestCase']


class ParentEntity(entity.Entity):
    parent_ident = entity.IntegerProperty(identity=True)

    class Meta:
        pass


class ChildEntity(ParentEntity):
    child_ident = entity.IntegerProperty(identity=True)

    class Meta:
        pass


class GrandChildEntity(ChildEntity):

    def __init__(self, *args, **kwargs):
        super(GrandChildEntity, self).__init__(*args, **kwargs)


class GreatGrandChildEntity(GrandChildEntity):

    def __init__(self, *args, **kwargs):
        super(GreatGrandChildEntity, self).__init__(*args, **kwargs)


class SubclassingTestCase(unittest.TestCase):

    def test_field_inheritance(self):
        pmeta = ParentEntity._meta
        cmeta = ChildEntity._meta
        props = list(set(pmeta.get_prop_names()) & set(cmeta.get_prop_names()))
        self.assertEqual(props, ['parent_ident'])

    def test_child_has_state(self):
        instance = ChildEntity()
        self.assertTrue(hasattr(instance, '_state'))

    def test_grandchild_has_state(self):
        instance = GrandChildEntity()
        self.assertTrue(hasattr(instance, '_state'))

    def test_greatgrandchild_has_state(self):
        instance = GreatGrandChildEntity()
        self.assertTrue(hasattr(instance, '_state'))


if __name__ == '__main__':
    unittest.main()