


class Serializable(object):
    """Specifie an interface for a serializable object."""

    @classmethod
    def deserialize(cls, serializer, serialized_object):
        """Rebuild the `serialized_object` using `serializer`."""
        raise NotImplementedError

    def as_dict(self):
        """Converts the object to a Python dictionary."""
        raise NotImplementedError

    def serialize(self, serializer, *args, **kwargs):
        """Serializes the :class:`Serializable`.

        Args:
            serializer: a callable that accepts the to-be
                serialized content as it's first argument.

        Returns:
            str
        """
        return serializer(self.as_dict(), *args, **kwargs)