from libtng import six
from libtng.ddd.dto.adapter.adaptermeta import AdapterMeta



class Mapper(six.with_metaclass(AdapterMeta)):

    def serialize(self, entity):
        """
        Serializes a domain entity to a dictionary for further
        processing.
        """
        data = {}
        for visitor in self._get_visitors():
            data[visitor.name] = visitor.visit(entity)
        return data

    def to_dto(self, entity):
        """
        Convert a domain entity to a data transfer object.
        """
        return self.dto_type(**self.serialize(entity))

    def _get_visitors(self):
        return self.__visitors__