from libtng.ddd.domain.entity import EntityInspector


class DataTransferObjectBase(object):

    @classmethod
    def fromentity(cls, entity):
        inspector = EntityInspector(entity)
        kwargs = {}
        for name in cls._properties:
            value = inspector.get_property(name)
            if name in cls._serializers:
                value = cls._serializers(value)
            elif name in cls._dtos:
                value = cls._dtos[name].fromentity(value)
            kwargs[name] = value
        return cls(**kwargs)

    def __init__(self, **kwargs):
        self.__dict__.update({x: kwargs[x] for x in self._properties})

    def serialize(self):
        """
        Serialize the Data Transfer Object (DTO) to a dictionary.
        """
        f = self._serialize_attribute
        return {x: f(self.__dict__[x]) for x in self._properties}

    def _serialize_attribute(self, value):
        try:
            return value.serialize()
        except AttributeError:
            return value

    def __repr__(self):
        attrs = []
        for name in self._properties:
            rpr = '{0}={1}'.format(name, getattr(self, name).__repr__())
            attrs.append(rpr)
        return "{0}({1})".format(type(self).__name__,
            ', '.join(attrs))



def DataTransferObject(name, attrs, serializers=None, dtos=None):
    members = {
        '_properties': attrs,
        '_serializers': serializers or {},
        '_dtos': dtos or {}
    }
    return type(name, (DataTransferObjectBase,), members)