import abc

from libtng.cqrs.exceptions import MissingCommandHandler


class HandlersProvider(object):
    """
    Maps commands to their handlers.
    """

    def register_handler(self, command_class, handler_class):
        """
        Registers `handler_class` as the handler for `command_class`.
        """
        self.__handlers[command_class] = handler_class

    def get_handler(self, gateway, runner, command, alias='default'):
        """
        Get a handler for the provided `command`.
        """
        try:
            return self.__handlers[type(command)](gateway, runner)
        except KeyError:
            raise MissingCommandHandler(
                "No handler registered for {0}".format(type(command).__name__))

    def __init__(self):
        self.__handlers = {}


registry = HandlersProvider()