import collections

from libtng.ddd.dto.adapter.scalar import Scalar
from libtng.ddd.dto.adapter.scalar import Collection


class AdapterMeta(type):

    def __new__(cls, name, bases, attrs):
        super_new = super(AdapterMeta, cls).__new__

        # six.withmetaclass() inserts an extra class called 'NewBase' in the
        # inheritance tree: Entity -> NewBase -> object. But the initialization
        # should be executed only once for a given model class.

        # attrs will never be empty for classes declared in the standard way
        # (ie. with the `class` keyword). This is quite robust.
        if name == 'NewBase' and attrs == {}:
            return super_new(cls, name, bases, attrs)

        # Also ensure initialization is only performed for subclasses of Entity
        # (excluding Entity class itself).
        parents = [b for b in bases if isinstance(b, AdapterMeta) and
                not (b.__name__ == 'NewBase' and b.__mro__ == (b, object))]
        if not parents:
            return super_new(cls, name, bases, attrs)

        module = attrs.pop('__module__')
        new_class = super_new(cls, name, bases, {'__module__': module,
            '__visitors__': []})
        for attname, value in attrs.items():
            new_class.add_to_class(attname, value)
            if isinstance(value, (Scalar, Collection)):
                new_class.__visitors__.append(value)

        # Create a named tuple holding the data.
        dto = collections.namedtuple('DataTransferObject',
            map(lambda x: x.name, new_class.__visitors__))
        new_class.add_to_class('dto_type', dto)
        return new_class

    def add_to_class(cls, name, value):
        if hasattr(value, 'contribute_to_class'):
            value.contribute_to_class(cls, name)
        else:
            setattr(cls, name, value)
