from libtng.ddd.visitor import Visitor


class Scalar(Visitor):
    """
    Specifies a scalar attribute on a Data Transfer Object (DTO).
    """

    def __init__(self, getter, adapter=None, type=None):
        """
        Initialize a new :class:`Scalar` instance.

        Args:
            getter: a callable that returns the required attribute(s)
                from the domain entity.
            adapter: adapter used to visit child collections.
            type: a callable that coerces the values to a desired
                format after adapting.
        """
        self._getter = getter
        self._adapter = adapter
        self._type = type
        self.name = None

    def visit(self, entity):
        """
        Visits the domain entity in order to get the required
        information from it.
        """
        a = self._adapter().serialize if self._adapter else lambda x: x
        f = self._type or (lambda x: x)
        return f(a(self._getter(entity)))

    def contribute_to_class(self, cls, attname):
        self.name = attname


class Collection(Scalar):
    """
    Specifies a collection on a Data Transfer Object (DTO).
    """

    def visit(self, entity):
        """
        Visits the domain entity in order to get the required
        information from it.
        """
        a = self._adapter().serialize if self._adapter else lambda x: x
        f = self._type or (lambda x: x)
        return map(f, map(a, self._getter(entity)))