import unittest

from libtng import entity


__all__ = ['EntityDefaultTestCase']


class TestEntity(entity.Entity):
    integer_property    = entity.IntegerProperty(identity=True, default=1, public_getter=True)


class EntityDefaultTestCase(unittest.TestCase):

    def test_default(self):
        prop = TestEntity._meta.get_prop('integer_property')
        instance = TestEntity()
        self.assertEqual(instance.integer_property, prop.default)