from sqlalchemy.sql.schema import Column
from sqlalchemy.sql.schema import FetchedValue
from sqlalchemy.sql.schema import ForeignKey
from sqlalchemy.types import BigInteger
from sqlalchemy.types import DateTime
from sqlalchemy.dialects.postgresql import JSON

from libtng.db.relation import relation_factory


CQRSRelation = relation_factory()


class Transaction(CQRSRelation):
    __tablename__ = 'transactions'
    __table_args__ = {
        'schema': 'public'
    }

    transaction_id = Column(BigInteger,
        server_default=FetchedValue(),
        primary_key=True,
        name='transaction_id'
    )

    invoked = Column(DateTime,
        nullable=False,
        name='invoked'
    )

    user_id = Column(BigInteger,
        nullable=False,
        name='user_id'
    )

    parameters = Column(JSON,
        nullable=False,
        name='parameters'
    )

    metadata = Column(JSON,
        nullable=False,
        name='metadata'
    )
