import datetime
import time
import math

from libtng.cqrs.const import PENDING
from libtng.cqrs.const import ACCEPTED
from libtng.cqrs.const import REJECTED
from libtng.cqrs.const import FINISHED
from libtng.cqrs.const import FAILED
import libtng.io


class CommandMetadata(libtng.io.Serializable):
    """Represents the metadata attached to a
    :class:`libtng.cqrs.Command` instance."""

    def __init__(self, command):
        self._command_type = type(command)
        self._invoked = int(math.floor(time.time()))
        self._dispatched = None
        self._accepted = None
        self._route = []
        self._finished = False
        self._state = PENDING
        self._user = None
        self._client = None
        self._authorization = None
        self._extra = {}

    def update(self, data):
        """Updates the metadata user-space with the specified keys and
        values.
        """
        self._extra.update(data)

    def as_dict(self):
        """Convert a :class:`CommandMetadata` instance to
        a Python dictionary.
        """
        obj = {
            'invoked'       : self._invoked,
            'type'          : self._command_type.qualified_name,
            'dispatched'    : self._dispatched,
            'finished'      : self._finished,
            'state'         : self._state
        }
        obj.update(self._extra)
        return obj

    def set_state(self, state):
        """Set the command execution state.

        Args:
            state (int): specifies the state.

        Returns:
            None
        """
        self._state = state

    def mark_dispatched(self):
        """Marks the command as dispatched."""
        self._dispatched = int(math.floor(time.time()))