import json

from libtng.io import Serializable
from libtng.encoding import force_text
from libtng.cqrs.gateway.transaction import Transaction


class GatewayResponse(Serializable):
    """Represents a response from the gateway."""

    @property
    def status_code(self):
        return self._status_code

    @property
    def transaction(self):
        return self._transaction

    @classmethod
    def deserialize(cls, raw_data, serializer):
        return cls(**serializer.deserialize(raw_data))

    def __init__(self, status_code, status_message, headers=None):
        self._status_code = status_code
        self._status_message = status_message
        self._headers = headers or {}
    
    def as_dict(self):
        """Project the :class:`GatewayResponse` as a dictionary."""
        return {
            'status_code': self._status_code,
            'status_message': self._status_message
        }

    def serialize(self, serializer):
        """Serializes the object into a byte sequence."""
        return serializer.serialize(self.as_dict())

    def __repr__(self):
        return "{0} {1}".format(self._status_code, self._status_message)

