#!/usr/bin/python
"""
Subtools for Archive_crawler program.
Copyright (C) 2012  xiamingc, SJTU -  chenxm35@gmail.com

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
import argparse
import logging
import os
import datetime
import sys
import time

from libwayback import WaybackRetriever

# global logger settings
root_logger = logging.getLogger("libwayback")	# use default 'libwayback' logger to active logging function of libwayback
root_logger.setLevel(logging.ERROR)
handler = logging.FileHandler(os.path.join(os.path.dirname(__file__), "app_retriever_log.txt"))
console = logging.StreamHandler()
handler.setFormatter(logging.Formatter("%(asctime)-15s %(module)s/%(lineno)d %(levelname)s: %(message)s"))
root_logger.addHandler(handler)
root_logger.addHandler(console)

logger = logging.getLogger("libwayback.app_retriever")


__about__ = """
Program to retrieve the HTML web pages of the URLs generated by wayback_crawler.py.
"""


def _genoutdir(where = '.'):
	outputdir = os.path.join(where, "retriever_results")
	if not os.path.exists(outputdir):
		os.makedirs(outputdir)
	return outputdir

def _genoutname(outputfolder, inputfilename, timestr):
	""" Generate output file name like "[inputfilename]_[urltimestamp].txt"
	"""
	name = inputfilename.rsplit('.', 1)[0]
	newdir = os.path.join(outputfolder, name)
	if not os.path.exists(newdir):
		os.makedirs(newdir)
	outputfilename = "%s_%s.txt" % (name, timestr)
	return os.path.join(newdir, outputfilename)
	

def retriever_smart(inputfile, years = None, days = None):
	logger.info("Start downloading URLs of %s" % inputfile)

	retriever = WaybackRetriever()

	all_urls = []
	for line in open(inputfile, 'rb'):
		line = line.rstrip('\n')
		if line =='': continue
		timestamp = retriever.extract_timestamp(line)
		if timestamp == None:
			logger.error("Fail to extract timestamp: %s" % line)
			continue
		all_urls.append((timestamp, line))
	all_urls.sort(lambda x,y:cmp(x[0],y[0]), None, False)

	## Process the time-scale limitations
	if years != None:
		left_urls = [url for url in all_urls if url[0].year in years ]
	else:
		left_urls = all_urls

	inputfilename = os.path.split(inputfile)[1]
	resultdir = _genoutdir()	# output lies in the same folder with this program
	aday = []
	k = 1 	## url counter
	j = 0	## day counter
	n = 0	## valid day counter
	while k <= len(left_urls):
		url = left_urls[k-1]
		if len(aday) == 0 or url[0].day == aday[0][0].day:
			aday.append(url)
		if k == len(left_urls) or left_urls[k][0].day != aday[0][0].day:
			## process the day to featch the earlies valid web page
			print("Parsing the day: %s/%s/%s" % (aday[0][0].month, aday[0][0].day, aday[0][0].year))
			j += 1
			dl = len(aday)	## total url counter for a day
			i = 1 	## url counter for a day
			while i <= dl:
				time.sleep(0.5)
				outputfile = _genoutname(resultdir, inputfilename, retriever.extract_time_string(aday[i-1][1]))
				status = retriever.save_page(aday[i-1][1], outputfile)
				if status == None:
					i += 1; continue
				else:
					n += 1; break
			# start next day
			aday = []
		k += 1
	logger.info("Finish downloading.")
	logger.info("File %s: %d/%d valid days processed" % (inputfile, n, j))

 
def runMain():   
	parser = argparse.ArgumentParser(description = __about__)
	parser.add_argument("-y", dest='yearscale', type=str, help="Year scale to retrieve, e.g. '1999', '1999-2003' or '1999,2003' (without quotation marks)")
	parser.add_argument("-l", dest="loglevel", default="DEBUG", type=str, help="Log level: DEBUG(default), INFO, WARNING, ERROR, CRITICAL")
	parser.add_argument("urlfile", type=str, help="File containing wayback URLs output by the crawler.")
	args = parser.parse_args()
	loglevel = args.loglevel
	inputfile = args.urlfile
	yearstr = args.yearscale

	if yearstr != None:
		years = []
		for i in yearstr.split(','):
			points = [int(j) for j in i.split('-')]
			if len(points) == 1:
				years.append(int(i))
			elif len(points) > 2:
				print("Wrong year scale. -h for help")
				exit(-1)
			else:
				if points[0] <= points[1]:
					years += range(points[0], points[1]+1)
				else:
					years += range(points[1], points[0]+1)
	else:
		years = None

	## logging
	numeric_level = getattr(logging, loglevel.upper(), None)
	if not isinstance(numeric_level, int):
	    raise ValueError('Invalid log level: %s' % loglevel)
	    parser.print_help(); sys.exit(-1)

	root_logger.setLevel(numeric_level)

	logger.info("{0}: processing {1}".format(str(datetime.datetime.now()), inputfile))
	retriever_smart(inputfile, years)


if __name__ == '__main__':
	runMain()