#!/usr/bin/env python3
# -*- coding: utf-8 -*-

#
# Copyright © 2013 Felix Crux <felixc@felixcrux.com> and the Authors.
# Released under the terms of the MIT License (Expat Version).
# See the LICENSE and AUTHORS files for further details.
#


import subprocess
import sys

import distutils.cmd
import distutils.core

import libwedger


class SimpleCommand(distutils.cmd.Command):
    """Base class to avoid having to specify empty defaults repeatedly."""
    user_options = []

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass


class TestCommand(SimpleCommand):
    def run(self):
        exit_code = subprocess.call(
            ["python", "-m", "unittest", "discover", "-s", "tst"])
        if exit_code is not 0:
            sys.exit(exit_code)


class Flake8Command(SimpleCommand):
    def run(self):
        exit_code = subprocess.call(["flake8", "libwedger.py", "setup.py"])
        if exit_code is not 0:
            sys.exit(exit_code)


with open("README.rst") as f:
    README = f.read()
with open("CHANGELOG") as f:
    CHANGELOG = f.read()


distutils.core.setup(
    name=libwedger.__title__,
    version=libwedger.__version__,
    license=libwedger.__license__,
    maintainer=libwedger.__author__,
    maintainer_email="felixc@felixcrux.com",
    provides=["libwedger"],
    url="https://github.com/felixc/libwedger/",
    download_url="https://pypi.python.org/pypi/libwedger",
    description="Interpret ledger's output and make it available in Python.",
    long_description=(
        README +
        "\n\nRelease History\n---------------\n\n" +
        CHANGELOG),
    py_modules=["libwedger"],
    classifiers=(
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3.3",
        "Topic :: Office/Business :: Financial :: Accounting",
    ),
    cmdclass={
        "test": TestCommand,
        "flake8": Flake8Command,
    }
)
