#!/usr/bin/env python3
# -*- coding: utf-8 -*-

#
# Copyright © 2013 Felix Crux <felixc@felixcrux.com> and the Authors.
# Released under the terms of the MIT License (Expat Version).
# See the LICENSE and AUTHORS files for further details.
#


import os
import tempfile
import unittest

import libwedger


class TestGetAllAccountNames(unittest.TestCase):

    def setUp(self):
        self.ledger_file = tempfile.NamedTemporaryFile("w+")
        os.environ["LEDGER_FILE"] = self.ledger_file.name
        os.environ["HOME"] = tempfile.gettempdir()

    def tearDown(self):
        self.ledger_file.close()

    def test_no_accounts(self):
        self.assertEqual(libwedger.get_all_account_names(), set())

    def test_flat_accounts(self):
        self.ledger_file.write("2013-01-01 Writing Tests\n"
                               "  Time  -30 minutes\n"
                               "  QA")
        self.ledger_file.flush()

        self.assertEqual(libwedger.get_all_account_names(), {"Time", "QA"})

    def test_nested_accounts(self):
        self.ledger_file.file.write("2013-01-01 Writing Tests\n"
                                    "  Assets:Personal:Time  -30 minutes\n"
                                    "  Expenses:Essential:QA")
        self.ledger_file.flush()

        self.assertEqual(
            libwedger.get_all_account_names(),
            {"Assets", "Assets:Personal", "Assets:Personal:Time",
             "Expenses", "Expenses:Essential", "Expenses:Essential:QA"})


if __name__ == "__main__":
    unittest.main()
