from lice.core import *
import os
try:
    import unittest2 as unittest
except ImportError:
    import unittest


def collector():
    start_dir = os.path.abspath(os.path.dirname(__file__))
    return unittest.defaultTestLoader.discover(start_dir)


class TestPaths(unittest.TestCase):

    def test_paths(self):
        self.assertEqual(clean_path("."), os.getcwd())
        self.assertEqual(clean_path("$HOME"), os.environ["HOME"])
        self.assertEqual(clean_path("~"), os.environ["HOME"])


class TestTemplates(unittest.TestCase):

    def test_file_template(self):
        pwd = os.path.abspath(os.path.dirname(__file__))
        for license in LICENSES:
            path = os.path.join(pwd, "template-%s.txt" % license)
            with open(path) as infile:
                content = infile.read()
                self.assertEqual(content, load_file_template(path))

    def test_package_template(self):
        pwd = os.path.abspath(os.path.dirname(__file__))
        for license in LICENSES:
            path = os.path.join(pwd, "template-%s.txt" % license)
            with open(path) as infile:
                self.assertEqual(infile.read(), load_package_template(license))

    def test_extract_vars(self):
        for license in LICENSES:
            template = """Oh hey, {{ this }} is a {{ template }} test."""
            var_list = extract_vars(template)
            self.assertEquals(var_list, ["this", "template"])

    def test_license(self):

        context = {
            "year": "1981",
            "project": "lice",
            "organization": "Awesome Co.",
        }

        for license in LICENSES:

            template = load_package_template(license)

            rendered = template.replace("{{ year }}", context["year"])
            rendered = rendered.replace("{{ project }}", context["project"])
            rendered = rendered.replace("{{ organization }}", context["organization"])

            self.assertEqual(rendered, generate_license(template, context))

    def test_license_header(self):

        context = {
            "year": "1981",
            "project": "lice",
            "organization": "Awesome Co.",
        }

        for license in LICENSES:

            try:

                template = load_package_template(license, header=True)

                rendered = template.replace("{{ year }}", context["year"])
                rendered = rendered.replace("{{ project }}", context["project"])
                rendered = rendered.replace("{{ organization }}", context["organization"])

                self.assertEqual(rendered, generate_license(template, context))

            except IOError:
                pass  # it's okay to not find templates


if __name__ == '__main__':
    unittest.main()
