/* Generated by Cython 0.10.3 on Thu Apr  9 03:54:49 2009 */

#define PY_SSIZE_T_CLEAN
#include "Python.h"
#include "structmember.h"
#ifndef PY_LONG_LONG
  #define PY_LONG_LONG LONG_LONG
#endif
#ifndef DL_EXPORT
  #define DL_EXPORT(t) t
#endif
#if PY_VERSION_HEX < 0x02040000
  #define METH_COEXIST 0
#endif
#if PY_VERSION_HEX < 0x02050000
  typedef int Py_ssize_t;
  #define PY_SSIZE_T_MAX INT_MAX
  #define PY_SSIZE_T_MIN INT_MIN
  #define PyInt_FromSsize_t(z) PyInt_FromLong(z)
  #define PyInt_AsSsize_t(o)   PyInt_AsLong(o)
  #define PyNumber_Index(o)    PyNumber_Int(o)
  #define PyIndex_Check(o)     PyNumber_Check(o)
#endif
#if PY_VERSION_HEX < 0x02060000
  #define Py_REFCNT(ob) (((PyObject*)(ob))->ob_refcnt)
  #define Py_TYPE(ob)   (((PyObject*)(ob))->ob_type)
  #define Py_SIZE(ob)   (((PyVarObject*)(ob))->ob_size)
  #define PyVarObject_HEAD_INIT(type, size) \
          PyObject_HEAD_INIT(type) size,
  #define PyType_Modified(t)

  typedef struct {
       void *buf;
       PyObject *obj;
       Py_ssize_t len;
       Py_ssize_t itemsize;
       int readonly;
       int ndim;
       char *format;
       Py_ssize_t *shape;
       Py_ssize_t *strides;
       Py_ssize_t *suboffsets;
       void *internal;
  } Py_buffer;

  #define PyBUF_SIMPLE 0
  #define PyBUF_WRITABLE 0x0001
  #define PyBUF_LOCK 0x0002
  #define PyBUF_FORMAT 0x0004
  #define PyBUF_ND 0x0008
  #define PyBUF_STRIDES (0x0010 | PyBUF_ND)
  #define PyBUF_C_CONTIGUOUS (0x0020 | PyBUF_STRIDES)
  #define PyBUF_F_CONTIGUOUS (0x0040 | PyBUF_STRIDES)
  #define PyBUF_ANY_CONTIGUOUS (0x0080 | PyBUF_STRIDES)
  #define PyBUF_INDIRECT (0x0100 | PyBUF_STRIDES)

#endif
#if PY_MAJOR_VERSION < 3
  #define __Pyx_BUILTIN_MODULE_NAME "__builtin__"
#else
  #define __Pyx_BUILTIN_MODULE_NAME "builtins"
#endif
#if PY_MAJOR_VERSION >= 3
  #define Py_TPFLAGS_CHECKTYPES 0
  #define Py_TPFLAGS_HAVE_INDEX 0
#endif
#if (PY_VERSION_HEX < 0x02060000) || (PY_MAJOR_VERSION >= 3)
  #define Py_TPFLAGS_HAVE_NEWBUFFER 0
#endif
#if PY_MAJOR_VERSION >= 3
  #define PyBaseString_Type            PyUnicode_Type
  #define PyString_Type                PyBytes_Type
  #define PyInt_Type                   PyLong_Type
  #define PyInt_Check(op)              PyLong_Check(op)
  #define PyInt_CheckExact(op)         PyLong_CheckExact(op)
  #define PyInt_FromString             PyLong_FromString
  #define PyInt_FromUnicode            PyLong_FromUnicode
  #define PyInt_FromLong               PyLong_FromLong
  #define PyInt_FromSize_t             PyLong_FromSize_t
  #define PyInt_FromSsize_t            PyLong_FromSsize_t
  #define PyInt_AsLong                 PyLong_AsLong
  #define PyInt_AS_LONG                PyLong_AS_LONG
  #define PyInt_AsSsize_t              PyLong_AsSsize_t
  #define PyInt_AsUnsignedLongMask     PyLong_AsUnsignedLongMask
  #define PyInt_AsUnsignedLongLongMask PyLong_AsUnsignedLongLongMask
  #define __Pyx_PyNumber_Divide(x,y)         PyNumber_TrueDivide(x,y)
#else
  #define __Pyx_PyNumber_Divide(x,y)         PyNumber_Divide(x,y)
  #define PyBytes_Type                 PyString_Type
#endif
#if PY_MAJOR_VERSION >= 3
  #define PyMethod_New(func, self, klass) PyInstanceMethod_New(func)
#endif
#if !defined(WIN32) && !defined(MS_WINDOWS)
  #ifndef __stdcall
    #define __stdcall
  #endif
  #ifndef __cdecl
    #define __cdecl
  #endif
#else
  #define _USE_MATH_DEFINES
#endif
#ifdef __cplusplus
#define __PYX_EXTERN_C extern "C"
#else
#define __PYX_EXTERN_C extern
#endif
#include <math.h>
#define __PYX_HAVE_API__ligeos__linearref
#include "math.h"


#ifdef __GNUC__
#define INLINE __inline__
#elif _WIN32
#define INLINE __inline
#else
#define INLINE 
#endif

typedef struct {PyObject **p; char *s; long n; char is_unicode; char intern; char is_identifier;} __Pyx_StringTabEntry; /*proto*/



static int __pyx_skip_dispatch = 0;


/* Type Conversion Predeclarations */

#if PY_MAJOR_VERSION < 3
#define __Pyx_PyBytes_FromString PyString_FromString
#define __Pyx_PyBytes_AsString   PyString_AsString
#else
#define __Pyx_PyBytes_FromString PyBytes_FromString
#define __Pyx_PyBytes_AsString   PyBytes_AsString
#endif

#define __Pyx_PyBool_FromLong(b) ((b) ? (Py_INCREF(Py_True), Py_True) : (Py_INCREF(Py_False), Py_False))
static INLINE int __Pyx_PyObject_IsTrue(PyObject* x);
static INLINE PY_LONG_LONG __pyx_PyInt_AsLongLong(PyObject* x);
static INLINE unsigned PY_LONG_LONG __pyx_PyInt_AsUnsignedLongLong(PyObject* x);
static INLINE Py_ssize_t __pyx_PyIndex_AsSsize_t(PyObject* b);

#define __pyx_PyInt_AsLong(x) (PyInt_CheckExact(x) ? PyInt_AS_LONG(x) : PyInt_AsLong(x))
#define __pyx_PyFloat_AsDouble(x) (PyFloat_CheckExact(x) ? PyFloat_AS_DOUBLE(x) : PyFloat_AsDouble(x))

static INLINE unsigned char __pyx_PyInt_unsigned_char(PyObject* x);
static INLINE unsigned short __pyx_PyInt_unsigned_short(PyObject* x);
static INLINE char __pyx_PyInt_char(PyObject* x);
static INLINE short __pyx_PyInt_short(PyObject* x);
static INLINE int __pyx_PyInt_int(PyObject* x);
static INLINE long __pyx_PyInt_long(PyObject* x);
static INLINE signed char __pyx_PyInt_signed_char(PyObject* x);
static INLINE signed short __pyx_PyInt_signed_short(PyObject* x);
static INLINE signed int __pyx_PyInt_signed_int(PyObject* x);
static INLINE signed long __pyx_PyInt_signed_long(PyObject* x);
static INLINE long double __pyx_PyInt_long_double(PyObject* x);
#ifdef __GNUC__
/* Test for GCC > 2.95 */
#if __GNUC__ > 2 ||               (__GNUC__ == 2 && (__GNUC_MINOR__ > 95)) 
#define likely(x)   __builtin_expect(!!(x), 1)
#define unlikely(x) __builtin_expect(!!(x), 0)
#else /* __GNUC__ > 2 ... */
#define likely(x)   (x)
#define unlikely(x) (x)
#endif /* __GNUC__ > 2 ... */
#else /* __GNUC__ */
#define likely(x)   (x)
#define unlikely(x) (x)
#endif /* __GNUC__ */
    
static PyObject *__pyx_m;
static PyObject *__pyx_b;
static PyObject *__pyx_empty_tuple;
static int __pyx_lineno;
static int __pyx_clineno = 0;
static const char * __pyx_cfilenm= __FILE__;
static const char *__pyx_filename;
static const char **__pyx_f;

static char __pyx_mdoc[] = "\nThis package is designed to offer FAST linear referencing tools without outside dependencies\non other libraries (except cython).  \n\nMuch of the code is a direct translation from the PostGIS repository's liblwgeom\nabstraction. One important note: Points maintain a \"geo\" flag, while indicates the point \nis (or is not) a geographic coordinate.  Geographic coordinates use a spherical distance \ncalculation rather than a planar distance calculation.\n";

static void __Pyx_RaiseDoubleKeywordsError(
    const char* func_name, PyObject* kw_name); /*proto*/

static void __Pyx_RaiseArgtupleInvalid(const char* func_name, int exact,
    Py_ssize_t num_min, Py_ssize_t num_max, Py_ssize_t num_found); /*proto*/

static int __Pyx_ParseOptionalKeywords(PyObject *kwds, PyObject **argnames[],     PyObject *kwds2, PyObject *values[], Py_ssize_t num_pos_args,     const char* function_name); /*proto*/

static INLINE PyObject *__Pyx_GetItemInt(PyObject *o, Py_ssize_t i, int is_unsigned) {
    PyObject *r;
    if (PyList_CheckExact(o) && 0 <= i && i < PyList_GET_SIZE(o)) {
        r = PyList_GET_ITEM(o, i);
        Py_INCREF(r);
    }
    else if (PyTuple_CheckExact(o) && 0 <= i && i < PyTuple_GET_SIZE(o)) {
        r = PyTuple_GET_ITEM(o, i);
        Py_INCREF(r);
    }
    else if (Py_TYPE(o)->tp_as_sequence && Py_TYPE(o)->tp_as_sequence->sq_item && (likely(i >= 0) || !is_unsigned))
        r = PySequence_GetItem(o, i);
    else {
        PyObject *j = (likely(i >= 0) || !is_unsigned) ? PyInt_FromLong(i) : PyLong_FromUnsignedLongLong((sizeof(unsigned long long) > sizeof(Py_ssize_t) ? (1ULL << (sizeof(Py_ssize_t)*8)) : 0) + i);
        if (!j)
            return 0;
        r = PyObject_GetItem(o, j);
        Py_DECREF(j);
    }
    return r;
}

static int __Pyx_ArgTypeTest(PyObject *obj, PyTypeObject *type, int none_allowed,
    const char *name, int exact); /*proto*/

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name); /*proto*/

static PyObject *__Pyx_CreateClass(PyObject *bases, PyObject *dict, PyObject *name, char *modname); /*proto*/

static int __Pyx_TypeTest(PyObject *obj, PyTypeObject *type); /*proto*/

static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb); /*proto*/

static INLINE void __Pyx_ErrRestore(PyObject *type, PyObject *value, PyObject *tb); /*proto*/
static INLINE void __Pyx_ErrFetch(PyObject **type, PyObject **value, PyObject **tb); /*proto*/

static INLINE PyObject* __Pyx_PyObject_Append(PyObject* L, PyObject* x) {
    if (likely(PyList_CheckExact(L))) {
        if (PyList_Append(L, x) < 0) return NULL;
        Py_INCREF(Py_None);
        return Py_None; // this is just to have an accurate signature
    }
    else {
        return PyObject_CallMethod(L, "append", "(O)", x);
    }
}

static int __Pyx_Print(PyObject *, int); /*proto*/
#if PY_MAJOR_VERSION >= 3
static PyObject* __pyx_print = 0;
static PyObject* __pyx_print_kwargs = 0;
#endif

static void __Pyx_WriteUnraisable(const char *name); /*proto*/

static int __Pyx_SetVtable(PyObject *dict, void *vtable); /*proto*/

static void __Pyx_AddTraceback(const char *funcname); /*proto*/

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t); /*proto*/

/* Type declarations */

/* "/home/nino/ligeos/ligeos/linearref.pyx":183
 *         return seg_distance_seg(self.p1, self.p2, s.p1, s.p2)
 * 
 * cdef struct Vector2D:             # <<<<<<<<<<<<<<
 *     double x, y
 * 
 */

struct __pyx_t_6ligeos_9linearref_Vector2D {
  double x;
  double y;
};

/* "/home/nino/ligeos/ligeos/linearref.pyx":578
 *         return LineString(dpa, geographic=ipa[0].is_geo())
 * 
 *     cpdef LineString concatenate(self, LineString l2, float merge_tolerance=0):             # <<<<<<<<<<<<<<
 *         """Returns true if l2 was joined or None, if the min distance is above the max distance allowed."""
 *         cdef CPoint a, b, c, d
 */

struct __pyx_opt_args_6ligeos_9linearref_10LineString_concatenate {
  int __pyx_n;
  float merge_tolerance;
};

/* "/home/nino/ligeos/ligeos/linearref.pyx":322
 *     raise TypeError("unable to convert %s to a coordinate" % type(arg))
 * 
 * cdef class LineString:             # <<<<<<<<<<<<<<
 *     """A sequence of points that define a linestring."""
 *     cdef object _pts
 */

struct __pyx_obj_6ligeos_9linearref_LineString {
  PyObject_HEAD
  struct __pyx_vtabstruct_6ligeos_9linearref_LineString *__pyx_vtab;
  PyObject *_pts;
  PyObject *geographic;
};

/* "/home/nino/ligeos/ligeos/linearref.pyx":157
 *     return CPoint(x, y, True)
 * 
 * cdef class Line:             # <<<<<<<<<<<<<<
 *     """ A line as defined by two points."""
 *     cdef CPoint p1, p2
 */

struct __pyx_obj_6ligeos_9linearref_Line {
  PyObject_HEAD
  struct __pyx_vtabstruct_6ligeos_9linearref_Line *__pyx_vtab;
  struct __pyx_obj_6ligeos_9linearref_CPoint *p1;
  struct __pyx_obj_6ligeos_9linearref_CPoint *p2;
};

/* "/home/nino/ligeos/ligeos/linearref.pyx":107
 * 
 * 
 * cdef class CPoint:             # <<<<<<<<<<<<<<
 *     """ A coordinate pair.  If geo is set, distance_earth will be used in distance calculations."""
 *     cdef double _x, _y
 */

struct __pyx_obj_6ligeos_9linearref_CPoint {
  PyObject_HEAD
  struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *__pyx_vtab;
  double _x;
  double _y;
  PyObject *geo;
};


struct __pyx_vtabstruct_6ligeos_9linearref_CPoint {
  double (*distance_pt)(struct __pyx_obj_6ligeos_9linearref_CPoint *, struct __pyx_obj_6ligeos_9linearref_CPoint *, int __pyx_skip_dispatch);
};
static struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *__pyx_vtabptr_6ligeos_9linearref_CPoint;


/* "/home/nino/ligeos/ligeos/linearref.pyx":322
 *     raise TypeError("unable to convert %s to a coordinate" % type(arg))
 * 
 * cdef class LineString:             # <<<<<<<<<<<<<<
 *     """A sequence of points that define a linestring."""
 *     cdef object _pts
 */

struct __pyx_vtabstruct_6ligeos_9linearref_LineString {
  struct __pyx_obj_6ligeos_9linearref_CPoint *(*closest_pt)(struct __pyx_obj_6ligeos_9linearref_LineString *, struct __pyx_obj_6ligeos_9linearref_CPoint *, int __pyx_skip_dispatch);
  double (*distance_pt)(struct __pyx_obj_6ligeos_9linearref_LineString *, struct __pyx_obj_6ligeos_9linearref_CPoint *, int __pyx_skip_dispatch);
  struct __pyx_obj_6ligeos_9linearref_CPoint *(*closest_pt_to_line)(struct __pyx_obj_6ligeos_9linearref_LineString *, struct __pyx_obj_6ligeos_9linearref_LineString *, int __pyx_skip_dispatch);
  double (*distance_to_line)(struct __pyx_obj_6ligeos_9linearref_LineString *, struct __pyx_obj_6ligeos_9linearref_LineString *, int __pyx_skip_dispatch);
  double (*locate_point)(struct __pyx_obj_6ligeos_9linearref_LineString *, struct __pyx_obj_6ligeos_9linearref_CPoint *, int __pyx_skip_dispatch);
  struct __pyx_obj_6ligeos_9linearref_LineString *(*substring)(struct __pyx_obj_6ligeos_9linearref_LineString *, double, double, int __pyx_skip_dispatch);
  struct __pyx_obj_6ligeos_9linearref_LineString *(*concatenate)(struct __pyx_obj_6ligeos_9linearref_LineString *, struct __pyx_obj_6ligeos_9linearref_LineString *, int __pyx_skip_dispatch, struct __pyx_opt_args_6ligeos_9linearref_10LineString_concatenate *__pyx_optional_args);
};
static struct __pyx_vtabstruct_6ligeos_9linearref_LineString *__pyx_vtabptr_6ligeos_9linearref_LineString;


/* "/home/nino/ligeos/ligeos/linearref.pyx":157
 *     return CPoint(x, y, True)
 * 
 * cdef class Line:             # <<<<<<<<<<<<<<
 *     """ A line as defined by two points."""
 *     cdef CPoint p1, p2
 */

struct __pyx_vtabstruct_6ligeos_9linearref_Line {
  double (*length)(struct __pyx_obj_6ligeos_9linearref_Line *, int __pyx_skip_dispatch);
  struct __pyx_obj_6ligeos_9linearref_CPoint *(*closest_pt)(struct __pyx_obj_6ligeos_9linearref_Line *, struct __pyx_obj_6ligeos_9linearref_CPoint *, int __pyx_skip_dispatch);
  double (*distance_pt)(struct __pyx_obj_6ligeos_9linearref_Line *, struct __pyx_obj_6ligeos_9linearref_CPoint *, int __pyx_skip_dispatch);
  double (*distance_seg)(struct __pyx_obj_6ligeos_9linearref_Line *, struct __pyx_obj_6ligeos_9linearref_Line *, int __pyx_skip_dispatch);
};
static struct __pyx_vtabstruct_6ligeos_9linearref_Line *__pyx_vtabptr_6ligeos_9linearref_Line;
/* Module declarations from ligeos.linearref */

static PyTypeObject *__pyx_ptype_6ligeos_9linearref_CPoint = 0;
static PyTypeObject *__pyx_ptype_6ligeos_9linearref_Line = 0;
static PyTypeObject *__pyx_ptype_6ligeos_9linearref_LineString = 0;
static PyObject *__pyx_k_12;
static double __pyx_f_6ligeos_9linearref_distance_earth(float, float, float, float, int __pyx_skip_dispatch); /*proto*/
static PyObject *__pyx_f_6ligeos_9linearref_vincenty(double, double, double, double, int __pyx_skip_dispatch); /*proto*/
static struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_f_6ligeos_9linearref_seg_intersect_seg(struct __pyx_obj_6ligeos_9linearref_CPoint *, struct __pyx_obj_6ligeos_9linearref_CPoint *, struct __pyx_obj_6ligeos_9linearref_CPoint *, struct __pyx_obj_6ligeos_9linearref_CPoint *, int __pyx_skip_dispatch); /*proto*/
static double __pyx_f_6ligeos_9linearref_seg_distance_seg(struct __pyx_obj_6ligeos_9linearref_CPoint *, struct __pyx_obj_6ligeos_9linearref_CPoint *, struct __pyx_obj_6ligeos_9linearref_CPoint *, struct __pyx_obj_6ligeos_9linearref_CPoint *, int __pyx_skip_dispatch); /*proto*/
static double __pyx_f_6ligeos_9linearref_seg_distance_pt(struct __pyx_obj_6ligeos_9linearref_CPoint *, struct __pyx_obj_6ligeos_9linearref_CPoint *, struct __pyx_obj_6ligeos_9linearref_CPoint *, int __pyx_skip_dispatch); /*proto*/
static struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_f_6ligeos_9linearref_seg_closest_pt(struct __pyx_obj_6ligeos_9linearref_CPoint *, struct __pyx_obj_6ligeos_9linearref_CPoint *, struct __pyx_obj_6ligeos_9linearref_CPoint *, int __pyx_skip_dispatch); /*proto*/
static PyObject *__pyx_f_6ligeos_9linearref_interpolate_point2d(struct __pyx_obj_6ligeos_9linearref_CPoint *, struct __pyx_obj_6ligeos_9linearref_CPoint *, float); /*proto*/
static struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_f_6ligeos_9linearref__to_cpoint(PyObject *, PyObject *); /*proto*/


/* Implementation of ligeos.linearref */
static PyObject *__pyx_int_0;
static PyObject *__pyx_int_1;
static PyObject *__pyx_int_neg_1;
static char __pyx_k_distance_earth[] = "distance_earth";
static PyObject *__pyx_kp_distance_earth;
static char __pyx_k_vincenty[] = "vincenty";
static PyObject *__pyx_kp_vincenty;
static char __pyx_k___init__[] = "__init__";
static PyObject *__pyx_kp___init__;
static char __pyx_k___str__[] = "__str__";
static PyObject *__pyx_kp___str__;
static char __pyx_k_clone[] = "clone";
static PyObject *__pyx_kp_clone;
static char __pyx_k_is_geo[] = "is_geo";
static PyObject *__pyx_kp_is_geo;
static char __pyx_k_distance_pt[] = "distance_pt";
static PyObject *__pyx_kp_distance_pt;
static char __pyx_k_length[] = "length";
static PyObject *__pyx_kp_length;
static char __pyx_k_closest_pt[] = "closest_pt";
static PyObject *__pyx_kp_closest_pt;
static char __pyx_k_distance_seg[] = "distance_seg";
static PyObject *__pyx_kp_distance_seg;
static char __pyx_k_seg_intersect_seg[] = "seg_intersect_seg";
static PyObject *__pyx_kp_seg_intersect_seg;
static char __pyx_k_seg_distance_seg[] = "seg_distance_seg";
static PyObject *__pyx_kp_seg_distance_seg;
static char __pyx_k_seg_distance_pt[] = "seg_distance_pt";
static PyObject *__pyx_kp_seg_distance_pt;
static char __pyx_k_seg_closest_pt[] = "seg_closest_pt";
static PyObject *__pyx_kp_seg_closest_pt;
static char __pyx_k___len__[] = "__len__";
static PyObject *__pyx_kp___len__;
static char __pyx_k_closest_pt_to_line[] = "closest_pt_to_line";
static PyObject *__pyx_kp_closest_pt_to_line;
static char __pyx_k_distance_to_line[] = "distance_to_line";
static PyObject *__pyx_kp_distance_to_line;
static char __pyx_k_locate_point[] = "locate_point";
static PyObject *__pyx_kp_locate_point;
static char __pyx_k_substring[] = "substring";
static PyObject *__pyx_kp_substring;
static char __pyx_k_concatenate[] = "concatenate";
static PyObject *__pyx_kp_concatenate;
static char __pyx_k_1[] = "x1";
static PyObject *__pyx_kp_1;
static char __pyx_k_2[] = "y1";
static PyObject *__pyx_kp_2;
static char __pyx_k_3[] = "x2";
static PyObject *__pyx_kp_3;
static char __pyx_k_4[] = "y2";
static PyObject *__pyx_kp_4;
static char __pyx_k_5[] = "lat1";
static PyObject *__pyx_kp_5;
static char __pyx_k_6[] = "lon1";
static PyObject *__pyx_kp_6;
static char __pyx_k_7[] = "lat2";
static PyObject *__pyx_kp_7;
static char __pyx_k_8[] = "lon2";
static PyObject *__pyx_kp_8;
static char __pyx_k_x[] = "x";
static PyObject *__pyx_kp_x;
static char __pyx_k_y[] = "y";
static PyObject *__pyx_kp_y;
static char __pyx_k_geo[] = "geo";
static PyObject *__pyx_kp_geo;
static char __pyx_k_v[] = "v";
static PyObject *__pyx_kp_v;
static char __pyx_k_9[] = "p2";
static PyObject *__pyx_kp_9;
static char __pyx_k_10[] = "p1";
static PyObject *__pyx_kp_10;
static char __pyx_k_p[] = "p";
static PyObject *__pyx_kp_p;
static char __pyx_k_s[] = "s";
static PyObject *__pyx_kp_s;
static char __pyx_k_a[] = "a";
static PyObject *__pyx_kp_a;
static char __pyx_k_b[] = "b";
static PyObject *__pyx_kp_b;
static char __pyx_k_c[] = "c";
static PyObject *__pyx_kp_c;
static char __pyx_k_d[] = "d";
static PyObject *__pyx_kp_d;
static char __pyx_k_geographic[] = "geographic";
static PyObject *__pyx_kp_geographic;
static char __pyx_k_11[] = "l2";
static PyObject *__pyx_kp_11;
static char __pyx_k_frm[] = "frm";
static PyObject *__pyx_kp_frm;
static char __pyx_k_to[] = "to";
static PyObject *__pyx_kp_to;
static char __pyx_k_merge_tolerance[] = "merge_tolerance";
static PyObject *__pyx_kp_merge_tolerance;
static char __pyx_k_ArgumentError[] = "ArgumentError";
static PyObject *__pyx_kp_ArgumentError;
static char __pyx_k_Exception[] = "Exception";
static PyObject *__pyx_kp_Exception;
static char __pyx_k_min[] = "min";
static PyObject *__pyx_kp_min;
static char __pyx_k_15[] = "x";
static PyObject *__pyx_kp_15;
static char __pyx_k_16[] = "y";
static PyObject *__pyx_kp_16;
static char __pyx_k_TypeError[] = "TypeError";
static PyObject *__pyx_kp_TypeError;
static char __pyx_k_extend[] = "extend";
static PyObject *__pyx_kp_extend;
static char __pyx_k_append[] = "append";
static PyObject *__pyx_kp_append;
static char __pyx_k_join[] = "join";
static PyObject *__pyx_kp_join;
static char __pyx_k_map[] = "map";
static PyObject *__pyx_kp_map;
static char __pyx_k_sum[] = "sum";
static PyObject *__pyx_kp_sum;
static char __pyx_k_range[] = "range";
static PyObject *__pyx_kp_range;
static PyObject *__pyx_builtin_Exception;
static PyObject *__pyx_builtin_min;
static PyObject *__pyx_builtin_TypeError;
static PyObject *__pyx_builtin_map;
static PyObject *__pyx_builtin_sum;
static PyObject *__pyx_builtin_range;
static PyObject *__pyx_kp_13;
static char __pyx_k_13[] = "(%f %f)";
static PyObject *__pyx_kp_14;
static char __pyx_k_14[] = "%f,%f->%f,%f";
static PyObject *__pyx_kp_17;
static char __pyx_k_17[] = "unable to convert %s to a coordinate";
static PyObject *__pyx_kp_18;
static char __pyx_k_18[] = "Invalid argument type/sequence: %s %s";
static PyObject *__pyx_kp_20;
static PyObject *__pyx_kp_19;
static PyObject *__pyx_kp_21;
static char __pyx_k_19[] = "(";
static char __pyx_k_20[] = ",";
static char __pyx_k_21[] = ")";
static PyObject *__pyx_kp_22;
static PyObject *__pyx_kp_23;
static char __pyx_k_22[] = "from is less than to";
static char __pyx_k_23[] = "Unhandled case";

/* "/home/nino/ligeos/ligeos/linearref.pyx":28
 * 
 * 
 * cpdef double distance_earth(float x1, float y1, float x2, float y2):             # <<<<<<<<<<<<<<
 *     """ Calculates the spherical distance between two geographic points."""
 *     cdef double long1, lat1, long2, lat2
 */

static PyObject *__pyx_pf_6ligeos_9linearref_distance_earth(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static  double __pyx_f_6ligeos_9linearref_distance_earth(float __pyx_v_x1, float __pyx_v_y1, float __pyx_v_x2, float __pyx_v_y2, int __pyx_skip_dispatch) {
  double __pyx_v_long1;
  double __pyx_v_lat1;
  double __pyx_v_long2;
  double __pyx_v_lat2;
  double __pyx_v_longdiff;
  double __pyx_v_sino;
  double __pyx_r;
  int __pyx_1;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":34
 *     cdef double sino
 * 
 *     long1 = -2 * (x1 / 360.0) * __PI             # <<<<<<<<<<<<<<
 *     lat1 = 2 * (y1 / 360.0) * __PI
 * 
 */
  __pyx_v_long1 = ((-2 * (__pyx_v_x1 / 360.0)) * 3.1415926500000002);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":35
 * 
 *     long1 = -2 * (x1 / 360.0) * __PI
 *     lat1 = 2 * (y1 / 360.0) * __PI             # <<<<<<<<<<<<<<
 * 
 *     long2 = -2 * (x2 / 360.0) * __PI
 */
  __pyx_v_lat1 = ((2 * (__pyx_v_y1 / 360.0)) * 3.1415926500000002);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":37
 *     lat1 = 2 * (y1 / 360.0) * __PI
 * 
 *     long2 = -2 * (x2 / 360.0) * __PI             # <<<<<<<<<<<<<<
 *     lat2 = 2 * (y2 / 360.0) * __PI
 * 
 */
  __pyx_v_long2 = ((-2 * (__pyx_v_x2 / 360.0)) * 3.1415926500000002);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":38
 * 
 *     long2 = -2 * (x2 / 360.0) * __PI
 *     lat2 = 2 * (y2 / 360.0) * __PI             # <<<<<<<<<<<<<<
 * 
 *     # compute difference in longitudes - want < 180 degrees
 */
  __pyx_v_lat2 = ((2 * (__pyx_v_y2 / 360.0)) * 3.1415926500000002);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":41
 * 
 *     # compute difference in longitudes - want < 180 degrees
 *     longdiff = fabs(long1 - long2)             # <<<<<<<<<<<<<<
 *     if longdiff > __PI:
 *         longdiff = (2 * __PI) - longdiff;
 */
  __pyx_v_longdiff = fabs((__pyx_v_long1 - __pyx_v_long2));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":42
 *     # compute difference in longitudes - want < 180 degrees
 *     longdiff = fabs(long1 - long2)
 *     if longdiff > __PI:             # <<<<<<<<<<<<<<
 *         longdiff = (2 * __PI) - longdiff;
 * 
 */
  __pyx_1 = (__pyx_v_longdiff > 3.1415926500000002);
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":43
 *     longdiff = fabs(long1 - long2)
 *     if longdiff > __PI:
 *         longdiff = (2 * __PI) - longdiff;             # <<<<<<<<<<<<<<
 * 
 *     sino = sqrt(sin(fabs(lat1 - lat2) / 2.) * sin(fabs(lat1 - lat2) / 2.) + \
 */
    __pyx_v_longdiff = ((2 * 3.1415926500000002) - __pyx_v_longdiff);
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":46
 * 
 *     sino = sqrt(sin(fabs(lat1 - lat2) / 2.) * sin(fabs(lat1 - lat2) / 2.) + \
 *             cos(lat1) * cos(lat2) * sin(longdiff / 2.) * sin(longdiff / 2.))             # <<<<<<<<<<<<<<
 *     if sino > 1.0: sino = 1.0
 *     return 2.0 * EARTH_RADIUS * asin(sino);
 */
  __pyx_v_sino = sqrt(((sin((fabs((__pyx_v_lat1 - __pyx_v_lat2)) / 2.)) * sin((fabs((__pyx_v_lat1 - __pyx_v_lat2)) / 2.))) + (((cos(__pyx_v_lat1) * cos(__pyx_v_lat2)) * sin((__pyx_v_longdiff / 2.))) * sin((__pyx_v_longdiff / 2.)))));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":47
 *     sino = sqrt(sin(fabs(lat1 - lat2) / 2.) * sin(fabs(lat1 - lat2) / 2.) + \
 *             cos(lat1) * cos(lat2) * sin(longdiff / 2.) * sin(longdiff / 2.))
 *     if sino > 1.0: sino = 1.0             # <<<<<<<<<<<<<<
 *     return 2.0 * EARTH_RADIUS * asin(sino);
 * 
 */
  __pyx_1 = (__pyx_v_sino > 1.0);
  if (__pyx_1) {
    __pyx_v_sino = 1.0;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":48
 *             cos(lat1) * cos(lat2) * sin(longdiff / 2.) * sin(longdiff / 2.))
 *     if sino > 1.0: sino = 1.0
 *     return 2.0 * EARTH_RADIUS * asin(sino);             # <<<<<<<<<<<<<<
 * 
 * # WGS-84 ellipsiod
 */
  __pyx_r = ((2.0 * 6370986.8842583038) * asin(__pyx_v_sino));
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":28
 * 
 * 
 * cpdef double distance_earth(float x1, float y1, float x2, float y2):             # <<<<<<<<<<<<<<
 *     """ Calculates the spherical distance between two geographic points."""
 *     cdef double long1, lat1, long2, lat2
 */

static PyObject *__pyx_pf_6ligeos_9linearref_distance_earth(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_6ligeos_9linearref_distance_earth[] = " Calculates the spherical distance between two geographic points.";
static PyObject *__pyx_pf_6ligeos_9linearref_distance_earth(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  float __pyx_v_x1;
  float __pyx_v_y1;
  float __pyx_v_x2;
  float __pyx_v_y2;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_1,&__pyx_kp_2,&__pyx_kp_3,&__pyx_kp_4,0};
  __pyx_self = __pyx_self;
  if (unlikely(__pyx_kwds)) {
    PyObject* values[4] = {0,0,0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  4: values[3] = PyTuple_GET_ITEM(__pyx_args, 3);
      case  3: values[2] = PyTuple_GET_ITEM(__pyx_args, 2);
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_1);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_2);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("distance_earth", 1, 4, 4, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
      case  2:
      values[2] = PyDict_GetItem(__pyx_kwds, __pyx_kp_3);
      if (likely(values[2])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("distance_earth", 1, 4, 4, 2); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
      case  3:
      values[3] = PyDict_GetItem(__pyx_kwds, __pyx_kp_4);
      if (likely(values[3])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("distance_earth", 1, 4, 4, 3); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "distance_earth") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_x1 = __pyx_PyFloat_AsDouble(values[0]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_y1 = __pyx_PyFloat_AsDouble(values[1]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_x2 = __pyx_PyFloat_AsDouble(values[2]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_y2 = __pyx_PyFloat_AsDouble(values[3]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  } else if (PyTuple_GET_SIZE(__pyx_args) != 4) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_x1 = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 0)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_y1 = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 1)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_x2 = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 2)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_y2 = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 3)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("distance_earth", 1, 4, 4, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.distance_earth");
  return NULL;
  __pyx_L4_argument_unpacking_done:;
  __pyx_1 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_distance_earth(__pyx_v_x1, __pyx_v_y1, __pyx_v_x2, __pyx_v_y2, 0)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.distance_earth");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":55
 * DEF _VCTY_F = 1/298.257223563
 * 
 * cpdef vincenty(double lat1, double lon1, double lat2, double lon2):             # <<<<<<<<<<<<<<
 *     """Returns distance in meters between any points earth using the Vincenty ellipsoidal model of the earth"""
 *     cdef double L, U1, U2, sinU1, sinU2, lmbda, lmbdaP, sinLambda, cosLambda, sinSigma
 */

static PyObject *__pyx_pf_6ligeos_9linearref_vincenty(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static  PyObject *__pyx_f_6ligeos_9linearref_vincenty(double __pyx_v_lat1, double __pyx_v_lon1, double __pyx_v_lat2, double __pyx_v_lon2, int __pyx_skip_dispatch) {
  double __pyx_v_L;
  double __pyx_v_U1;
  double __pyx_v_U2;
  double __pyx_v_sinU1;
  double __pyx_v_sinU2;
  double __pyx_v_lmbda;
  double __pyx_v_lmbdaP;
  double __pyx_v_sinLambda;
  double __pyx_v_cosLambda;
  double __pyx_v_sinSigma;
  double __pyx_v_cosSigma;
  double __pyx_v_sigma;
  double __pyx_v_alpha;
  double __pyx_v_cosSqAlpha;
  double __pyx_v_cos2SigmaM;
  double __pyx_v_uSq;
  double __pyx_v_A;
  double __pyx_v_B;
  double __pyx_v_deltaSigma;
  double __pyx_v_C;
  int __pyx_v_iterLimit;
  PyObject *__pyx_v_cosU1;
  PyObject *__pyx_v_cosU2;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  double __pyx_5;
  PyObject *__pyx_t_1 = NULL;
  PyObject *__pyx_t_2 = NULL;
  PyObject *__pyx_t_3 = NULL;
  PyObject *__pyx_t_4 = NULL;
  PyObject *__pyx_t_5 = NULL;
  __pyx_v_cosU1 = Py_None; Py_INCREF(Py_None);
  __pyx_v_cosU2 = Py_None; Py_INCREF(Py_None);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":62
 *     cdef int iterLimit
 * 
 *     L = ( lon2-lon1 )*__PI / 180.0             # <<<<<<<<<<<<<<
 * 
 *     U1 = atan( (1-_VCTY_F) * tan( __PI*lat1/180.0 ) )
 */
  __pyx_v_L = (((__pyx_v_lon2 - __pyx_v_lon1) * 3.1415926500000002) / 180.0);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":64
 *     L = ( lon2-lon1 )*__PI / 180.0
 * 
 *     U1 = atan( (1-_VCTY_F) * tan( __PI*lat1/180.0 ) )             # <<<<<<<<<<<<<<
 *     U2 = atan( (1-_VCTY_F) * tan( __PI*lat2/180.0 ) )
 *     sinU1 = sin(U1); cosU1 = cos(U1)
 */
  __pyx_v_U1 = atan(((1 - 0.0033528106647474805) * tan(((3.1415926500000002 * __pyx_v_lat1) / 180.0))));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":65
 * 
 *     U1 = atan( (1-_VCTY_F) * tan( __PI*lat1/180.0 ) )
 *     U2 = atan( (1-_VCTY_F) * tan( __PI*lat2/180.0 ) )             # <<<<<<<<<<<<<<
 *     sinU1 = sin(U1); cosU1 = cos(U1)
 *     sinU2 = sin(U2); cosU2 = cos(U2)
 */
  __pyx_v_U2 = atan(((1 - 0.0033528106647474805) * tan(((3.1415926500000002 * __pyx_v_lat2) / 180.0))));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":66
 *     U1 = atan( (1-_VCTY_F) * tan( __PI*lat1/180.0 ) )
 *     U2 = atan( (1-_VCTY_F) * tan( __PI*lat2/180.0 ) )
 *     sinU1 = sin(U1); cosU1 = cos(U1)             # <<<<<<<<<<<<<<
 *     sinU2 = sin(U2); cosU2 = cos(U2)
 *     lmbda = L; lmbdaP = 2.0*__PI
 */
  __pyx_v_sinU1 = sin(__pyx_v_U1);
  __pyx_1 = PyFloat_FromDouble(cos(__pyx_v_U1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 66; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_v_cosU1);
  __pyx_v_cosU1 = __pyx_1;
  __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":67
 *     U2 = atan( (1-_VCTY_F) * tan( __PI*lat2/180.0 ) )
 *     sinU1 = sin(U1); cosU1 = cos(U1)
 *     sinU2 = sin(U2); cosU2 = cos(U2)             # <<<<<<<<<<<<<<
 *     lmbda = L; lmbdaP = 2.0*__PI
 * 
 */
  __pyx_v_sinU2 = sin(__pyx_v_U2);
  __pyx_1 = PyFloat_FromDouble(cos(__pyx_v_U2)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 67; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_v_cosU2);
  __pyx_v_cosU2 = __pyx_1;
  __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":68
 *     sinU1 = sin(U1); cosU1 = cos(U1)
 *     sinU2 = sin(U2); cosU2 = cos(U2)
 *     lmbda = L; lmbdaP = 2.0*__PI             # <<<<<<<<<<<<<<
 * 
 *     iterLimit = 20
 */
  __pyx_v_lmbda = __pyx_v_L;
  __pyx_v_lmbdaP = (2.0 * 3.1415926500000002);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":70
 *     lmbda = L; lmbdaP = 2.0*__PI
 * 
 *     iterLimit = 20             # <<<<<<<<<<<<<<
 * 
 *     while( iterLimit > 0 ):
 */
  __pyx_v_iterLimit = 20;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":72
 *     iterLimit = 20
 * 
 *     while( iterLimit > 0 ):             # <<<<<<<<<<<<<<
 *         if abs(lmbda-lmbdaP) < 1E-12:
 *             break
 */
  while (1) {
    __pyx_2 = (__pyx_v_iterLimit > 0);
    if (!__pyx_2) break;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":73
 * 
 *     while( iterLimit > 0 ):
 *         if abs(lmbda-lmbdaP) < 1E-12:             # <<<<<<<<<<<<<<
 *             break
 * 
 */
    __pyx_1 = PyFloat_FromDouble((__pyx_v_lmbda - __pyx_v_lmbdaP)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 73; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyNumber_Absolute(__pyx_1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 73; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_1 = PyFloat_FromDouble(1E-12); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 73; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_4 = PyObject_RichCompare(__pyx_3, __pyx_1, Py_LT); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 73; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_2 = __Pyx_PyObject_IsTrue(__pyx_4); if (unlikely(__pyx_2 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 73; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    if (__pyx_2) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":74
 *     while( iterLimit > 0 ):
 *         if abs(lmbda-lmbdaP) < 1E-12:
 *             break             # <<<<<<<<<<<<<<
 * 
 *         sinLambda = sin(lmbda); cosLambda = cos(lmbda)
 */
      goto __pyx_L4;
      goto __pyx_L5;
    }
    __pyx_L5:;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":76
 *             break
 * 
 *         sinLambda = sin(lmbda); cosLambda = cos(lmbda)             # <<<<<<<<<<<<<<
 *         sinSigma = sqrt((cosU2*sinLambda) * (cosU2*sinLambda) + \
 *             (cosU1*sinU2-sinU1*cosU2*cosLambda) * (cosU1*sinU2-sinU1*cosU2*cosLambda))
 */
    __pyx_v_sinLambda = sin(__pyx_v_lmbda);
    __pyx_v_cosLambda = cos(__pyx_v_lmbda);

    /* "/home/nino/ligeos/ligeos/linearref.pyx":77
 * 
 *         sinLambda = sin(lmbda); cosLambda = cos(lmbda)
 *         sinSigma = sqrt((cosU2*sinLambda) * (cosU2*sinLambda) + \             # <<<<<<<<<<<<<<
 *             (cosU1*sinU2-sinU1*cosU2*cosLambda) * (cosU1*sinU2-sinU1*cosU2*cosLambda))
 *         if sinSigma==0:
 */
    __pyx_3 = PyFloat_FromDouble(__pyx_v_sinLambda); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 77; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_t_1 = PyNumber_Multiply(__pyx_v_cosU2, __pyx_3); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 77; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_1 = PyFloat_FromDouble(__pyx_v_sinLambda); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 77; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_t_2 = PyNumber_Multiply(__pyx_v_cosU2, __pyx_1); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 77; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_t_3 = PyNumber_Multiply(__pyx_t_1, __pyx_t_2); if (unlikely(!__pyx_t_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 77; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    Py_DECREF(__pyx_t_2); __pyx_t_2 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":78
 *         sinLambda = sin(lmbda); cosLambda = cos(lmbda)
 *         sinSigma = sqrt((cosU2*sinLambda) * (cosU2*sinLambda) + \
 *             (cosU1*sinU2-sinU1*cosU2*cosLambda) * (cosU1*sinU2-sinU1*cosU2*cosLambda))             # <<<<<<<<<<<<<<
 *         if sinSigma==0:
 *             return 0  # co-incident points
 */
    __pyx_4 = PyFloat_FromDouble(__pyx_v_sinU2); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_t_2 = PyNumber_Multiply(__pyx_v_cosU1, __pyx_4); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_3 = PyFloat_FromDouble(__pyx_v_sinU1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_t_1 = PyNumber_Multiply(__pyx_3, __pyx_v_cosU2); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_1 = PyFloat_FromDouble(__pyx_v_cosLambda); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_t_4 = PyNumber_Multiply(__pyx_t_1, __pyx_1); if (unlikely(!__pyx_t_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_t_1 = PyNumber_Subtract(__pyx_t_2, __pyx_t_4); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_2); __pyx_t_2 = 0;
    Py_DECREF(__pyx_t_4); __pyx_t_4 = 0;
    __pyx_4 = PyFloat_FromDouble(__pyx_v_sinU2); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_t_4 = PyNumber_Multiply(__pyx_v_cosU1, __pyx_4); if (unlikely(!__pyx_t_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_3 = PyFloat_FromDouble(__pyx_v_sinU1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_t_2 = PyNumber_Multiply(__pyx_3, __pyx_v_cosU2); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_1 = PyFloat_FromDouble(__pyx_v_cosLambda); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_t_5 = PyNumber_Multiply(__pyx_t_2, __pyx_1); if (unlikely(!__pyx_t_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_2); __pyx_t_2 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_t_2 = PyNumber_Subtract(__pyx_t_4, __pyx_t_5); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_4); __pyx_t_4 = 0;
    Py_DECREF(__pyx_t_5); __pyx_t_5 = 0;
    __pyx_t_5 = PyNumber_Multiply(__pyx_t_1, __pyx_t_2); if (unlikely(!__pyx_t_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    Py_DECREF(__pyx_t_2); __pyx_t_2 = 0;
    __pyx_t_2 = PyNumber_Add(__pyx_t_3, __pyx_t_5); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 77; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_3); __pyx_t_3 = 0;
    Py_DECREF(__pyx_t_5); __pyx_t_5 = 0;
    __pyx_5 = __pyx_PyFloat_AsDouble(__pyx_t_2); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 77; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_2); __pyx_t_2 = 0;
    __pyx_v_sinSigma = sqrt(__pyx_5);

    /* "/home/nino/ligeos/ligeos/linearref.pyx":79
 *         sinSigma = sqrt((cosU2*sinLambda) * (cosU2*sinLambda) + \
 *             (cosU1*sinU2-sinU1*cosU2*cosLambda) * (cosU1*sinU2-sinU1*cosU2*cosLambda))
 *         if sinSigma==0:             # <<<<<<<<<<<<<<
 *             return 0  # co-incident points
 * 
 */
    __pyx_2 = (__pyx_v_sinSigma == 0);
    if (__pyx_2) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":80
 *             (cosU1*sinU2-sinU1*cosU2*cosLambda) * (cosU1*sinU2-sinU1*cosU2*cosLambda))
 *         if sinSigma==0:
 *             return 0  # co-incident points             # <<<<<<<<<<<<<<
 * 
 *         cosSigma = sinU1*sinU2 + cosU1*cosU2*cosLambda
 */
      Py_INCREF(__pyx_int_0);
      __pyx_r = __pyx_int_0;
      goto __pyx_L0;
      goto __pyx_L6;
    }
    __pyx_L6:;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":82
 *             return 0  # co-incident points
 * 
 *         cosSigma = sinU1*sinU2 + cosU1*cosU2*cosLambda             # <<<<<<<<<<<<<<
 *         sigma = atan2(sinSigma, cosSigma)
 *         alpha = asin(cosU1 * cosU2 * sinLambda / sinSigma)
 */
    __pyx_4 = PyFloat_FromDouble((__pyx_v_sinU1 * __pyx_v_sinU2)); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 82; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_t_2 = PyNumber_Multiply(__pyx_v_cosU1, __pyx_v_cosU2); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 82; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyFloat_FromDouble(__pyx_v_cosLambda); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 82; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_t_5 = PyNumber_Multiply(__pyx_t_2, __pyx_3); if (unlikely(!__pyx_t_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 82; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_2); __pyx_t_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_t_2 = PyNumber_Add(__pyx_4, __pyx_t_5); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 82; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_t_5); __pyx_t_5 = 0;
    __pyx_5 = __pyx_PyFloat_AsDouble(__pyx_t_2); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 82; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_2); __pyx_t_2 = 0;
    __pyx_v_cosSigma = __pyx_5;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":83
 * 
 *         cosSigma = sinU1*sinU2 + cosU1*cosU2*cosLambda
 *         sigma = atan2(sinSigma, cosSigma)             # <<<<<<<<<<<<<<
 *         alpha = asin(cosU1 * cosU2 * sinLambda / sinSigma)
 *         cosSqAlpha = cos(alpha) * cos(alpha)
 */
    __pyx_v_sigma = atan2(__pyx_v_sinSigma, __pyx_v_cosSigma);

    /* "/home/nino/ligeos/ligeos/linearref.pyx":84
 *         cosSigma = sinU1*sinU2 + cosU1*cosU2*cosLambda
 *         sigma = atan2(sinSigma, cosSigma)
 *         alpha = asin(cosU1 * cosU2 * sinLambda / sinSigma)             # <<<<<<<<<<<<<<
 *         cosSqAlpha = cos(alpha) * cos(alpha)
 *         cos2SigmaM = cosSigma - 2.0*sinU1*sinU2/cosSqAlpha
 */
    __pyx_t_2 = PyNumber_Multiply(__pyx_v_cosU1, __pyx_v_cosU2); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 84; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_1 = PyFloat_FromDouble(__pyx_v_sinLambda); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 84; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_t_5 = PyNumber_Multiply(__pyx_t_2, __pyx_1); if (unlikely(!__pyx_t_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 84; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_2); __pyx_t_2 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_3 = PyFloat_FromDouble(__pyx_v_sinSigma); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 84; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_t_2 = __Pyx_PyNumber_Divide(__pyx_t_5, __pyx_3); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 84; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_5); __pyx_t_5 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_5 = __pyx_PyFloat_AsDouble(__pyx_t_2); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 84; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_2); __pyx_t_2 = 0;
    __pyx_v_alpha = asin(__pyx_5);

    /* "/home/nino/ligeos/ligeos/linearref.pyx":85
 *         sigma = atan2(sinSigma, cosSigma)
 *         alpha = asin(cosU1 * cosU2 * sinLambda / sinSigma)
 *         cosSqAlpha = cos(alpha) * cos(alpha)             # <<<<<<<<<<<<<<
 *         cos2SigmaM = cosSigma - 2.0*sinU1*sinU2/cosSqAlpha
 *         C = _VCTY_F/16.0*cosSqAlpha*(4.0+_VCTY_F*(4.0-3.0*cosSqAlpha))
 */
    __pyx_v_cosSqAlpha = (cos(__pyx_v_alpha) * cos(__pyx_v_alpha));

    /* "/home/nino/ligeos/ligeos/linearref.pyx":86
 *         alpha = asin(cosU1 * cosU2 * sinLambda / sinSigma)
 *         cosSqAlpha = cos(alpha) * cos(alpha)
 *         cos2SigmaM = cosSigma - 2.0*sinU1*sinU2/cosSqAlpha             # <<<<<<<<<<<<<<
 *         C = _VCTY_F/16.0*cosSqAlpha*(4.0+_VCTY_F*(4.0-3.0*cosSqAlpha))
 *         lmbdaP = lmbda;
 */
    __pyx_v_cos2SigmaM = (__pyx_v_cosSigma - (((2.0 * __pyx_v_sinU1) * __pyx_v_sinU2) / __pyx_v_cosSqAlpha));

    /* "/home/nino/ligeos/ligeos/linearref.pyx":87
 *         cosSqAlpha = cos(alpha) * cos(alpha)
 *         cos2SigmaM = cosSigma - 2.0*sinU1*sinU2/cosSqAlpha
 *         C = _VCTY_F/16.0*cosSqAlpha*(4.0+_VCTY_F*(4.0-3.0*cosSqAlpha))             # <<<<<<<<<<<<<<
 *         lmbdaP = lmbda;
 *         lmbda = L + (1.0-C) * _VCTY_F * sin(alpha) * \
 */
    __pyx_v_C = (((0.0033528106647474805 / 16.0) * __pyx_v_cosSqAlpha) * (4.0 + (0.0033528106647474805 * (4.0 - (3.0 * __pyx_v_cosSqAlpha)))));

    /* "/home/nino/ligeos/ligeos/linearref.pyx":88
 *         cos2SigmaM = cosSigma - 2.0*sinU1*sinU2/cosSqAlpha
 *         C = _VCTY_F/16.0*cosSqAlpha*(4.0+_VCTY_F*(4.0-3.0*cosSqAlpha))
 *         lmbdaP = lmbda;             # <<<<<<<<<<<<<<
 *         lmbda = L + (1.0-C) * _VCTY_F * sin(alpha) * \
 *             (sigma + C*sinSigma*(cos2SigmaM+C*cosSigma*(-1.0+2.0*cos2SigmaM*cos2SigmaM)))
 */
    __pyx_v_lmbdaP = __pyx_v_lmbda;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":90
 *         lmbdaP = lmbda;
 *         lmbda = L + (1.0-C) * _VCTY_F * sin(alpha) * \
 *             (sigma + C*sinSigma*(cos2SigmaM+C*cosSigma*(-1.0+2.0*cos2SigmaM*cos2SigmaM)))             # <<<<<<<<<<<<<<
 * 
 *         iterLimit -= 1
 */
    __pyx_v_lmbda = (__pyx_v_L + ((((1.0 - __pyx_v_C) * 0.0033528106647474805) * sin(__pyx_v_alpha)) * (__pyx_v_sigma + ((__pyx_v_C * __pyx_v_sinSigma) * (__pyx_v_cos2SigmaM + ((__pyx_v_C * __pyx_v_cosSigma) * ((-1.0) + ((2.0 * __pyx_v_cos2SigmaM) * __pyx_v_cos2SigmaM))))))));

    /* "/home/nino/ligeos/ligeos/linearref.pyx":92
 *             (sigma + C*sinSigma*(cos2SigmaM+C*cosSigma*(-1.0+2.0*cos2SigmaM*cos2SigmaM)))
 * 
 *         iterLimit -= 1             # <<<<<<<<<<<<<<
 * 
 *     if iterLimit==0:
 */
    __pyx_v_iterLimit -= 1;
  }
  __pyx_L4:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":94
 *         iterLimit -= 1
 * 
 *     if iterLimit==0:             # <<<<<<<<<<<<<<
 *         return None  # formula failed to converge
 * 
 */
  __pyx_2 = (__pyx_v_iterLimit == 0);
  if (__pyx_2) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":95
 * 
 *     if iterLimit==0:
 *         return None  # formula failed to converge             # <<<<<<<<<<<<<<
 * 
 *     uSq = cosSqAlpha * (_VCTY_A*_VCTY_A - _VCTY_B*_VCTY_B) / (_VCTY_B*_VCTY_B);
 */
    Py_INCREF(Py_None);
    __pyx_r = Py_None;
    goto __pyx_L0;
    goto __pyx_L7;
  }
  __pyx_L7:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":97
 *         return None  # formula failed to converge
 * 
 *     uSq = cosSqAlpha * (_VCTY_A*_VCTY_A - _VCTY_B*_VCTY_B) / (_VCTY_B*_VCTY_B);             # <<<<<<<<<<<<<<
 *     A = 1.0 + uSq/16384.0*(4096.0+uSq*(-768.0+uSq*(320.0-175.0*uSq)))
 *     B = uSq/1024.0 * (256.0+uSq*(-128.0+uSq*(74.0-47.0*uSq)))
 */
  __pyx_v_uSq = ((__pyx_v_cosSqAlpha * ((6378137.0 * 6378137.0) - (6356752.3141999999 * 6356752.3141999999))) / (6356752.3141999999 * 6356752.3141999999));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":98
 * 
 *     uSq = cosSqAlpha * (_VCTY_A*_VCTY_A - _VCTY_B*_VCTY_B) / (_VCTY_B*_VCTY_B);
 *     A = 1.0 + uSq/16384.0*(4096.0+uSq*(-768.0+uSq*(320.0-175.0*uSq)))             # <<<<<<<<<<<<<<
 *     B = uSq/1024.0 * (256.0+uSq*(-128.0+uSq*(74.0-47.0*uSq)))
 *     deltaSigma = B*sinSigma*(cos2SigmaM+B/4.0*(cosSigma*(-1.0+2.0*cos2SigmaM*cos2SigmaM)-
 */
  __pyx_v_A = (1.0 + ((__pyx_v_uSq / 16384.0) * (4096.0 + (__pyx_v_uSq * ((-768.0) + (__pyx_v_uSq * (320.0 - (175.0 * __pyx_v_uSq))))))));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":99
 *     uSq = cosSqAlpha * (_VCTY_A*_VCTY_A - _VCTY_B*_VCTY_B) / (_VCTY_B*_VCTY_B);
 *     A = 1.0 + uSq/16384.0*(4096.0+uSq*(-768.0+uSq*(320.0-175.0*uSq)))
 *     B = uSq/1024.0 * (256.0+uSq*(-128.0+uSq*(74.0-47.0*uSq)))             # <<<<<<<<<<<<<<
 *     deltaSigma = B*sinSigma*(cos2SigmaM+B/4.0*(cosSigma*(-1.0+2.0*cos2SigmaM*cos2SigmaM)-
 *             B/6*cos2SigmaM*(-3.0+4.0*sinSigma*sinSigma)*(-3.0+4.0*cos2SigmaM*cos2SigmaM)))
 */
  __pyx_v_B = ((__pyx_v_uSq / 1024.0) * (256.0 + (__pyx_v_uSq * ((-128.0) + (__pyx_v_uSq * (74.0 - (47.0 * __pyx_v_uSq)))))));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":101
 *     B = uSq/1024.0 * (256.0+uSq*(-128.0+uSq*(74.0-47.0*uSq)))
 *     deltaSigma = B*sinSigma*(cos2SigmaM+B/4.0*(cosSigma*(-1.0+2.0*cos2SigmaM*cos2SigmaM)-
 *             B/6*cos2SigmaM*(-3.0+4.0*sinSigma*sinSigma)*(-3.0+4.0*cos2SigmaM*cos2SigmaM)))             # <<<<<<<<<<<<<<
 *     #s = _VCTY_B*A*(sigma-deltaSigma)
 * 
 */
  __pyx_v_deltaSigma = ((__pyx_v_B * __pyx_v_sinSigma) * (__pyx_v_cos2SigmaM + ((__pyx_v_B / 4.0) * ((__pyx_v_cosSigma * ((-1.0) + ((2.0 * __pyx_v_cos2SigmaM) * __pyx_v_cos2SigmaM))) - ((((__pyx_v_B / 6) * __pyx_v_cos2SigmaM) * ((-3.0) + ((4.0 * __pyx_v_sinSigma) * __pyx_v_sinSigma))) * ((-3.0) + ((4.0 * __pyx_v_cos2SigmaM) * __pyx_v_cos2SigmaM)))))));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":104
 *     #s = _VCTY_B*A*(sigma-deltaSigma)
 * 
 *     return _VCTY_B*A*(sigma-deltaSigma)             # <<<<<<<<<<<<<<
 * 
 * 
 */
  __pyx_4 = PyFloat_FromDouble(((6356752.3141999999 * __pyx_v_A) * (__pyx_v_sigma - __pyx_v_deltaSigma))); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 104; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_4;
  __pyx_4 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("ligeos.linearref.vincenty");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_cosU1);
  Py_DECREF(__pyx_v_cosU2);
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":55
 * DEF _VCTY_F = 1/298.257223563
 * 
 * cpdef vincenty(double lat1, double lon1, double lat2, double lon2):             # <<<<<<<<<<<<<<
 *     """Returns distance in meters between any points earth using the Vincenty ellipsoidal model of the earth"""
 *     cdef double L, U1, U2, sinU1, sinU2, lmbda, lmbdaP, sinLambda, cosLambda, sinSigma
 */

static PyObject *__pyx_pf_6ligeos_9linearref_vincenty(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_6ligeos_9linearref_vincenty[] = "Returns distance in meters between any points earth using the Vincenty ellipsoidal model of the earth";
static PyObject *__pyx_pf_6ligeos_9linearref_vincenty(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  double __pyx_v_lat1;
  double __pyx_v_lon1;
  double __pyx_v_lat2;
  double __pyx_v_lon2;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_5,&__pyx_kp_6,&__pyx_kp_7,&__pyx_kp_8,0};
  __pyx_self = __pyx_self;
  if (unlikely(__pyx_kwds)) {
    PyObject* values[4] = {0,0,0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  4: values[3] = PyTuple_GET_ITEM(__pyx_args, 3);
      case  3: values[2] = PyTuple_GET_ITEM(__pyx_args, 2);
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_5);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_6);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("vincenty", 1, 4, 4, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
      case  2:
      values[2] = PyDict_GetItem(__pyx_kwds, __pyx_kp_7);
      if (likely(values[2])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("vincenty", 1, 4, 4, 2); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
      case  3:
      values[3] = PyDict_GetItem(__pyx_kwds, __pyx_kp_8);
      if (likely(values[3])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("vincenty", 1, 4, 4, 3); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "vincenty") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_lat1 = __pyx_PyFloat_AsDouble(values[0]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_lon1 = __pyx_PyFloat_AsDouble(values[1]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_lat2 = __pyx_PyFloat_AsDouble(values[2]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_lon2 = __pyx_PyFloat_AsDouble(values[3]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  } else if (PyTuple_GET_SIZE(__pyx_args) != 4) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_lat1 = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 0)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_lon1 = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 1)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_lat2 = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 2)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_lon2 = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 3)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("vincenty", 1, 4, 4, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.vincenty");
  return NULL;
  __pyx_L4_argument_unpacking_done:;
  __pyx_1 = __pyx_f_6ligeos_9linearref_vincenty(__pyx_v_lat1, __pyx_v_lon1, __pyx_v_lat2, __pyx_v_lon2, 0); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 55; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.vincenty");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":112
 *     cdef bool geo
 * 
 *     def __init__(self, double x, double y, bool geo):             # <<<<<<<<<<<<<<
 *         self._x = x; self._y = y; self.geo = geo;
 * 
 */

static int __pyx_pf_6ligeos_9linearref_6CPoint___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_pf_6ligeos_9linearref_6CPoint___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  double __pyx_v_x;
  double __pyx_v_y;
  PyObject *__pyx_v_geo = 0;
  int __pyx_r;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_x,&__pyx_kp_y,&__pyx_kp_geo,0};
  if (unlikely(__pyx_kwds)) {
    PyObject* values[3] = {0,0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  3: values[2] = PyTuple_GET_ITEM(__pyx_args, 2);
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_x);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_y);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("__init__", 1, 3, 3, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
      case  2:
      values[2] = PyDict_GetItem(__pyx_kwds, __pyx_kp_geo);
      if (likely(values[2])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("__init__", 1, 3, 3, 2); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "__init__") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_x = __pyx_PyFloat_AsDouble(values[0]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_y = __pyx_PyFloat_AsDouble(values[1]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_geo = ((PyObject *)values[2]);
  } else if (PyTuple_GET_SIZE(__pyx_args) != 3) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_x = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 0)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_y = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 1)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_geo = ((PyObject *)PyTuple_GET_ITEM(__pyx_args, 2));
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("__init__", 1, 3, 3, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.CPoint.__init__");
  return -1;
  __pyx_L4_argument_unpacking_done:;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_geo), &PyBool_Type, 1, "geo", 1))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

  /* "/home/nino/ligeos/ligeos/linearref.pyx":113
 * 
 *     def __init__(self, double x, double y, bool geo):
 *         self._x = x; self._y = y; self.geo = geo;             # <<<<<<<<<<<<<<
 * 
 *     def __str__(self):
 */
  ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->_x = __pyx_v_x;
  ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->_y = __pyx_v_y;
  Py_INCREF(((PyObject *)__pyx_v_geo));
  Py_DECREF(((PyObject *)((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->geo));
  ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->geo = __pyx_v_geo;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_AddTraceback("ligeos.linearref.CPoint.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":115
 *         self._x = x; self._y = y; self.geo = geo;
 * 
 *     def __str__(self):             # <<<<<<<<<<<<<<
 *         return "(%f %f)" % (self._x, self._y)
 * 
 */

static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint___str__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint___str__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_t_1 = NULL;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":116
 * 
 *     def __str__(self):
 *         return "(%f %f)" % (self._x, self._y)             # <<<<<<<<<<<<<<
 * 
 *     def clone(self):
 */
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->_x); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 116; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyFloat_FromDouble(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->_y); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 116; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyTuple_New(2); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 116; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_2);
  __pyx_1 = 0;
  __pyx_2 = 0;
  __pyx_t_1 = PyNumber_Remainder(__pyx_kp_13, ((PyObject *)__pyx_3)); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 116; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
  __pyx_r = __pyx_t_1;
  __pyx_t_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("ligeos.linearref.CPoint.__str__");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":118
 *         return "(%f %f)" % (self._x, self._y)
 * 
 *     def clone(self):             # <<<<<<<<<<<<<<
 *         """ Return a copy of this point."""
 *         return CPoint(self._x, self._y, self.geo)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint_clone(PyObject *__pyx_v_self, PyObject *unused); /*proto*/
static char __pyx_doc_6ligeos_9linearref_6CPoint_clone[] = " Return a copy of this point.";
static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint_clone(PyObject *__pyx_v_self, PyObject *unused) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":120
 *     def clone(self):
 *         """ Return a copy of this point."""
 *         return CPoint(self._x, self._y, self.geo)             # <<<<<<<<<<<<<<
 * 
 *     property x:
 */
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->_x); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 120; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyFloat_FromDouble(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->_y); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 120; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyTuple_New(3); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 120; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_2);
  Py_INCREF(((PyObject *)((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->geo));
  PyTuple_SET_ITEM(__pyx_3, 2, ((PyObject *)((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->geo));
  __pyx_1 = 0;
  __pyx_2 = 0;
  __pyx_1 = PyObject_Call(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_CPoint)), ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 120; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("ligeos.linearref.CPoint.clone");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":123
 * 
 *     property x:
 *         def __set__(self, double v):             # <<<<<<<<<<<<<<
 *             self._x = v
 *         def __get__(self):
 */

static int __pyx_pf_6ligeos_9linearref_6CPoint_1x___set__(PyObject *__pyx_v_self, PyObject *__pyx_arg_v); /*proto*/
static int __pyx_pf_6ligeos_9linearref_6CPoint_1x___set__(PyObject *__pyx_v_self, PyObject *__pyx_arg_v) {
  double __pyx_v_v;
  int __pyx_r;
  assert(__pyx_arg_v); {
    __pyx_v_v = __pyx_PyFloat_AsDouble(__pyx_arg_v); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 123; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.CPoint.x.__set__");
  return -1;
  __pyx_L4_argument_unpacking_done:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":124
 *     property x:
 *         def __set__(self, double v):
 *             self._x = v             # <<<<<<<<<<<<<<
 *         def __get__(self):
 *             return self._x
 */
  ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->_x = __pyx_v_v;

  __pyx_r = 0;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":125
 *         def __set__(self, double v):
 *             self._x = v
 *         def __get__(self):             # <<<<<<<<<<<<<<
 *             return self._x
 * 
 */

static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint_1x___get__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint_1x___get__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":126
 *             self._x = v
 *         def __get__(self):
 *             return self._x             # <<<<<<<<<<<<<<
 * 
 *     property y:
 */
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->_x); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 126; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.CPoint.x.__get__");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":129
 * 
 *     property y:
 *         def __set__(self, double v):             # <<<<<<<<<<<<<<
 *             self._y = v
 *         def __get__(self):
 */

static int __pyx_pf_6ligeos_9linearref_6CPoint_1y___set__(PyObject *__pyx_v_self, PyObject *__pyx_arg_v); /*proto*/
static int __pyx_pf_6ligeos_9linearref_6CPoint_1y___set__(PyObject *__pyx_v_self, PyObject *__pyx_arg_v) {
  double __pyx_v_v;
  int __pyx_r;
  assert(__pyx_arg_v); {
    __pyx_v_v = __pyx_PyFloat_AsDouble(__pyx_arg_v); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 129; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.CPoint.y.__set__");
  return -1;
  __pyx_L4_argument_unpacking_done:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":130
 *     property y:
 *         def __set__(self, double v):
 *             self._y = v             # <<<<<<<<<<<<<<
 *         def __get__(self):
 *             return self._y
 */
  ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->_y = __pyx_v_v;

  __pyx_r = 0;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":131
 *         def __set__(self, double v):
 *             self._y = v
 *         def __get__(self):             # <<<<<<<<<<<<<<
 *             return self._y
 * 
 */

static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint_1y___get__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint_1y___get__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":132
 *             self._y = v
 *         def __get__(self):
 *             return self._y             # <<<<<<<<<<<<<<
 * 
 *     def is_geo(self):
 */
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->_y); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 132; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.CPoint.y.__get__");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":134
 *             return self._y
 * 
 *     def is_geo(self):             # <<<<<<<<<<<<<<
 *         """Is this a geographic point."""
 *         return self.geo == True
 */

static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint_is_geo(PyObject *__pyx_v_self, PyObject *unused); /*proto*/
static char __pyx_doc_6ligeos_9linearref_6CPoint_is_geo[] = "Is this a geographic point.";
static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint_is_geo(PyObject *__pyx_v_self, PyObject *unused) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":136
 *     def is_geo(self):
 *         """Is this a geographic point."""
 *         return self.geo == True             # <<<<<<<<<<<<<<
 * 
 * 
 */
  __pyx_1 = __Pyx_PyBool_FromLong(1); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 136; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyObject_RichCompare(((PyObject *)((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->geo), __pyx_1, Py_EQ); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 136; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("ligeos.linearref.CPoint.is_geo");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":140
 * 
 * 
 *     cpdef double distance_pt(self, CPoint p2):             # <<<<<<<<<<<<<<
 *         if self.geo:
 *             return distance_earth(self._x, self._y, p2._x, p2._y)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint_distance_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p2); /*proto*/
static  double __pyx_f_6ligeos_9linearref_6CPoint_distance_pt(struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_self, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p2, int __pyx_skip_dispatch) {
  double __pyx_v_hside;
  double __pyx_v_vside;
  double __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  double __pyx_4;
  int __pyx_5;
  /* Check if called by wrapper */
  if (unlikely(__pyx_skip_dispatch)) ;
  /* Check if overriden in Python */
  else if (unlikely(Py_TYPE(((PyObject *)__pyx_v_self))->tp_dictoffset != 0)) {
    __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_distance_pt); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 140; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(strcmp(Py_TYPE(__pyx_1)->tp_name, "builtin_function_or_method") == 0) || (PyCFunction_GET_FUNCTION(__pyx_1) != (void *)&__pyx_pf_6ligeos_9linearref_6CPoint_distance_pt)) {
      __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 140; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(((PyObject *)__pyx_v_p2));
      PyTuple_SET_ITEM(__pyx_2, 0, ((PyObject *)__pyx_v_p2));
      __pyx_3 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 140; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      __pyx_4 = __pyx_PyFloat_AsDouble(__pyx_3); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 140; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_r = __pyx_4;
      goto __pyx_L0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":141
 * 
 *     cpdef double distance_pt(self, CPoint p2):
 *         if self.geo:             # <<<<<<<<<<<<<<
 *             return distance_earth(self._x, self._y, p2._x, p2._y)
 *         # else
 */
  __pyx_5 = __Pyx_PyObject_IsTrue(((PyObject *)__pyx_v_self->geo)); if (unlikely(__pyx_5 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 141; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (__pyx_5) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":142
 *     cpdef double distance_pt(self, CPoint p2):
 *         if self.geo:
 *             return distance_earth(self._x, self._y, p2._x, p2._y)             # <<<<<<<<<<<<<<
 *         # else
 *         cdef double hside = p2._x - self._x
 */
    __pyx_r = __pyx_f_6ligeos_9linearref_distance_earth(__pyx_v_self->_x, __pyx_v_self->_y, __pyx_v_p2->_x, __pyx_v_p2->_y, 0);
    goto __pyx_L0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":144
 *             return distance_earth(self._x, self._y, p2._x, p2._y)
 *         # else
 *         cdef double hside = p2._x - self._x             # <<<<<<<<<<<<<<
 *         cdef double vside = p2._y - self._y
 *         return ( hside*hside + vside*vside )**0.5
 */
  __pyx_v_hside = (__pyx_v_p2->_x - __pyx_v_self->_x);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":145
 *         # else
 *         cdef double hside = p2._x - self._x
 *         cdef double vside = p2._y - self._y             # <<<<<<<<<<<<<<
 *         return ( hside*hside + vside*vside )**0.5
 * 
 */
  __pyx_v_vside = (__pyx_v_p2->_y - __pyx_v_self->_y);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":146
 *         cdef double hside = p2._x - self._x
 *         cdef double vside = p2._y - self._y
 *         return ( hside*hside + vside*vside )**0.5             # <<<<<<<<<<<<<<
 * 
 * 
 */
  __pyx_r = pow(((__pyx_v_hside * __pyx_v_hside) + (__pyx_v_vside * __pyx_v_vside)), 0.5);
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_WriteUnraisable("ligeos.linearref.CPoint.distance_pt");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":140
 * 
 * 
 *     cpdef double distance_pt(self, CPoint p2):             # <<<<<<<<<<<<<<
 *         if self.geo:
 *             return distance_earth(self._x, self._y, p2._x, p2._y)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint_distance_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p2); /*proto*/
static PyObject *__pyx_pf_6ligeos_9linearref_6CPoint_distance_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p2) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_p2), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "p2", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 140; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *)((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self)->__pyx_vtab)->distance_pt(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_self), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_p2), 1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 140; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.CPoint.distance_pt");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":149
 * 
 * 
 * def Point(float x, float y):             # <<<<<<<<<<<<<<
 *     """Helper function to create a simple coordinate."""
 *     return CPoint(x, y, False)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_Point(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_6ligeos_9linearref_Point[] = "Helper function to create a simple coordinate.";
static PyObject *__pyx_pf_6ligeos_9linearref_Point(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  float __pyx_v_x;
  float __pyx_v_y;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_x,&__pyx_kp_y,0};
  __pyx_self = __pyx_self;
  if (unlikely(__pyx_kwds)) {
    PyObject* values[2] = {0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_x);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_y);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("Point", 1, 2, 2, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "Point") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_x = __pyx_PyFloat_AsDouble(values[0]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_y = __pyx_PyFloat_AsDouble(values[1]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  } else if (PyTuple_GET_SIZE(__pyx_args) != 2) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_x = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 0)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_y = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 1)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("Point", 1, 2, 2, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.Point");
  return NULL;
  __pyx_L4_argument_unpacking_done:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":151
 * def Point(float x, float y):
 *     """Helper function to create a simple coordinate."""
 *     return CPoint(x, y, False)             # <<<<<<<<<<<<<<
 * 
 * def GPoint(float x, float y):
 */
  __pyx_1 = PyFloat_FromDouble(__pyx_v_x); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 151; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyFloat_FromDouble(__pyx_v_y); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 151; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = __Pyx_PyBool_FromLong(0); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 151; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_4 = PyTuple_New(3); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 151; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_4, 0, __pyx_1);
  PyTuple_SET_ITEM(__pyx_4, 1, __pyx_2);
  PyTuple_SET_ITEM(__pyx_4, 2, __pyx_3);
  __pyx_1 = 0;
  __pyx_2 = 0;
  __pyx_3 = 0;
  __pyx_1 = PyObject_Call(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_CPoint)), ((PyObject *)__pyx_4), NULL); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 151; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_4)); __pyx_4 = 0;
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("ligeos.linearref.Point");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":153
 *     return CPoint(x, y, False)
 * 
 * def GPoint(float x, float y):             # <<<<<<<<<<<<<<
 *     """ Helper function to return a geographic coordinate."""
 *     return CPoint(x, y, True)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_GPoint(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_6ligeos_9linearref_GPoint[] = " Helper function to return a geographic coordinate.";
static PyObject *__pyx_pf_6ligeos_9linearref_GPoint(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  float __pyx_v_x;
  float __pyx_v_y;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_x,&__pyx_kp_y,0};
  __pyx_self = __pyx_self;
  if (unlikely(__pyx_kwds)) {
    PyObject* values[2] = {0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_x);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_y);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("GPoint", 1, 2, 2, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 153; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "GPoint") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 153; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_x = __pyx_PyFloat_AsDouble(values[0]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 153; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_y = __pyx_PyFloat_AsDouble(values[1]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 153; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  } else if (PyTuple_GET_SIZE(__pyx_args) != 2) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_x = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 0)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 153; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_y = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 1)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 153; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("GPoint", 1, 2, 2, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 153; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.GPoint");
  return NULL;
  __pyx_L4_argument_unpacking_done:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":155
 * def GPoint(float x, float y):
 *     """ Helper function to return a geographic coordinate."""
 *     return CPoint(x, y, True)             # <<<<<<<<<<<<<<
 * 
 * cdef class Line:
 */
  __pyx_1 = PyFloat_FromDouble(__pyx_v_x); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 155; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyFloat_FromDouble(__pyx_v_y); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 155; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = __Pyx_PyBool_FromLong(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 155; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_4 = PyTuple_New(3); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 155; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_4, 0, __pyx_1);
  PyTuple_SET_ITEM(__pyx_4, 1, __pyx_2);
  PyTuple_SET_ITEM(__pyx_4, 2, __pyx_3);
  __pyx_1 = 0;
  __pyx_2 = 0;
  __pyx_3 = 0;
  __pyx_1 = PyObject_Call(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_CPoint)), ((PyObject *)__pyx_4), NULL); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 155; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_4)); __pyx_4 = 0;
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("ligeos.linearref.GPoint");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":161
 *     cdef CPoint p1, p2
 * 
 *     def __init__(self, CPoint p1, CPoint p2):             # <<<<<<<<<<<<<<
 *         self.p1 = p1; self.p2 = p2;
 * 
 */

static int __pyx_pf_6ligeos_9linearref_4Line___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_pf_6ligeos_9linearref_4Line___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p1 = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p2 = 0;
  int __pyx_r;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_10,&__pyx_kp_9,0};
  if (unlikely(__pyx_kwds)) {
    PyObject* values[2] = {0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_10);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_9);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("__init__", 1, 2, 2, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 161; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "__init__") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 161; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_p1 = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[0]);
    __pyx_v_p2 = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[1]);
  } else if (PyTuple_GET_SIZE(__pyx_args) != 2) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_p1 = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 0));
    __pyx_v_p2 = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 1));
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("__init__", 1, 2, 2, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 161; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.Line.__init__");
  return -1;
  __pyx_L4_argument_unpacking_done:;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_p1), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "p1", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 161; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_p2), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "p2", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 161; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

  /* "/home/nino/ligeos/ligeos/linearref.pyx":162
 * 
 *     def __init__(self, CPoint p1, CPoint p2):
 *         self.p1 = p1; self.p2 = p2;             # <<<<<<<<<<<<<<
 * 
 *     def __str__(self):
 */
  Py_INCREF(((PyObject *)__pyx_v_p1));
  Py_DECREF(((PyObject *)((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self)->p1));
  ((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self)->p1 = __pyx_v_p1;
  Py_INCREF(((PyObject *)__pyx_v_p2));
  Py_DECREF(((PyObject *)((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self)->p2));
  ((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self)->p2 = __pyx_v_p2;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_AddTraceback("ligeos.linearref.Line.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":164
 *         self.p1 = p1; self.p2 = p2;
 * 
 *     def __str__(self):             # <<<<<<<<<<<<<<
 *         return "%f,%f->%f,%f" %(self.p1._x, self.p1._y, self.p2._x, self.p2._y)
 * 
 */

static PyObject *__pyx_pf_6ligeos_9linearref_4Line___str__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_pf_6ligeos_9linearref_4Line___str__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_t_1 = NULL;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":165
 * 
 *     def __str__(self):
 *         return "%f,%f->%f,%f" %(self.p1._x, self.p1._y, self.p2._x, self.p2._y)             # <<<<<<<<<<<<<<
 * 
 *     cpdef double length(self):
 */
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self)->p1->_x); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 165; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyFloat_FromDouble(((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self)->p1->_y); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 165; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyFloat_FromDouble(((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self)->p2->_x); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 165; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_4 = PyFloat_FromDouble(((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self)->p2->_y); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 165; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_5 = PyTuple_New(4); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 165; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_5, 0, __pyx_1);
  PyTuple_SET_ITEM(__pyx_5, 1, __pyx_2);
  PyTuple_SET_ITEM(__pyx_5, 2, __pyx_3);
  PyTuple_SET_ITEM(__pyx_5, 3, __pyx_4);
  __pyx_1 = 0;
  __pyx_2 = 0;
  __pyx_3 = 0;
  __pyx_4 = 0;
  __pyx_t_1 = PyNumber_Remainder(__pyx_kp_14, ((PyObject *)__pyx_5)); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 165; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
  __pyx_r = __pyx_t_1;
  __pyx_t_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("ligeos.linearref.Line.__str__");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":167
 *         return "%f,%f->%f,%f" %(self.p1._x, self.p1._y, self.p2._x, self.p2._y)
 * 
 *     cpdef double length(self):             # <<<<<<<<<<<<<<
 *         """ Length of the line."""
 *         return self.p1.distance_pt(self.p2)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_4Line_length(PyObject *__pyx_v_self, PyObject *unused); /*proto*/
static  double __pyx_f_6ligeos_9linearref_4Line_length(struct __pyx_obj_6ligeos_9linearref_Line *__pyx_v_self, int __pyx_skip_dispatch) {
  double __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  double __pyx_3;
  /* Check if called by wrapper */
  if (unlikely(__pyx_skip_dispatch)) ;
  /* Check if overriden in Python */
  else if (unlikely(Py_TYPE(((PyObject *)__pyx_v_self))->tp_dictoffset != 0)) {
    __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_length); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 167; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(strcmp(Py_TYPE(__pyx_1)->tp_name, "builtin_function_or_method") == 0) || (PyCFunction_GET_FUNCTION(__pyx_1) != (void *)&__pyx_pf_6ligeos_9linearref_4Line_length)) {
      __pyx_2 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 167; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_3 = __pyx_PyFloat_AsDouble(__pyx_2); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 167; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_r = __pyx_3;
      goto __pyx_L0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":169
 *     cpdef double length(self):
 *         """ Length of the line."""
 *         return self.p1.distance_pt(self.p2)             # <<<<<<<<<<<<<<
 * 
 *     cpdef CPoint closest_pt(self, CPoint p):
 */
  __pyx_r = ((struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *)__pyx_v_self->p1->__pyx_vtab)->distance_pt(__pyx_v_self->p1, __pyx_v_self->p2, 0);
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_WriteUnraisable("ligeos.linearref.Line.length");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":167
 *         return "%f,%f->%f,%f" %(self.p1._x, self.p1._y, self.p2._x, self.p2._y)
 * 
 *     cpdef double length(self):             # <<<<<<<<<<<<<<
 *         """ Length of the line."""
 *         return self.p1.distance_pt(self.p2)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_4Line_length(PyObject *__pyx_v_self, PyObject *unused); /*proto*/
static char __pyx_doc_6ligeos_9linearref_4Line_length[] = " Length of the line.";
static PyObject *__pyx_pf_6ligeos_9linearref_4Line_length(PyObject *__pyx_v_self, PyObject *unused) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_vtabstruct_6ligeos_9linearref_Line *)((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self)->__pyx_vtab)->length(((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self), 1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 167; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.Line.length");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":171
 *         return self.p1.distance_pt(self.p2)
 * 
 *     cpdef CPoint closest_pt(self, CPoint p):             # <<<<<<<<<<<<<<
 *         """Return the point on the line nearest the given point."""
 *         return seg_closest_pt(self.p1, self.p2, p)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_4Line_closest_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p); /*proto*/
static  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_f_6ligeos_9linearref_4Line_closest_pt(struct __pyx_obj_6ligeos_9linearref_Line *__pyx_v_self, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p, int __pyx_skip_dispatch) {
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  /* Check if called by wrapper */
  if (unlikely(__pyx_skip_dispatch)) ;
  /* Check if overriden in Python */
  else if (unlikely(Py_TYPE(((PyObject *)__pyx_v_self))->tp_dictoffset != 0)) {
    __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_closest_pt); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 171; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(strcmp(Py_TYPE(__pyx_1)->tp_name, "builtin_function_or_method") == 0) || (PyCFunction_GET_FUNCTION(__pyx_1) != (void *)&__pyx_pf_6ligeos_9linearref_4Line_closest_pt)) {
      __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 171; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(((PyObject *)__pyx_v_p));
      PyTuple_SET_ITEM(__pyx_2, 0, ((PyObject *)__pyx_v_p));
      __pyx_3 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 171; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      if (!(__Pyx_TypeTest(__pyx_3, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 171; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3);
      __pyx_3 = 0;
      goto __pyx_L0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":173
 *     cpdef CPoint closest_pt(self, CPoint p):
 *         """Return the point on the line nearest the given point."""
 *         return seg_closest_pt(self.p1, self.p2, p)             # <<<<<<<<<<<<<<
 * 
 *     cpdef double distance_pt(self, CPoint p):
 */
  __pyx_1 = ((PyObject *)__pyx_f_6ligeos_9linearref_seg_closest_pt(__pyx_v_self->p1, __pyx_v_self->p2, __pyx_v_p, 0)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 173; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_1);
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("ligeos.linearref.Line.closest_pt");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":171
 *         return self.p1.distance_pt(self.p2)
 * 
 *     cpdef CPoint closest_pt(self, CPoint p):             # <<<<<<<<<<<<<<
 *         """Return the point on the line nearest the given point."""
 *         return seg_closest_pt(self.p1, self.p2, p)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_4Line_closest_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p); /*proto*/
static char __pyx_doc_6ligeos_9linearref_4Line_closest_pt[] = "Return the point on the line nearest the given point.";
static PyObject *__pyx_pf_6ligeos_9linearref_4Line_closest_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_p), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "p", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 171; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = ((PyObject *)((struct __pyx_vtabstruct_6ligeos_9linearref_Line *)((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self)->__pyx_vtab)->closest_pt(((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_p), 1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 171; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.Line.closest_pt");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":175
 *         return seg_closest_pt(self.p1, self.p2, p)
 * 
 *     cpdef double distance_pt(self, CPoint p):             # <<<<<<<<<<<<<<
 *         """The distance from the nearest point on this line to the given point."""
 *         return seg_distance_pt(self.p1, self.p2, p)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_4Line_distance_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p); /*proto*/
static  double __pyx_f_6ligeos_9linearref_4Line_distance_pt(struct __pyx_obj_6ligeos_9linearref_Line *__pyx_v_self, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p, int __pyx_skip_dispatch) {
  double __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  double __pyx_4;
  /* Check if called by wrapper */
  if (unlikely(__pyx_skip_dispatch)) ;
  /* Check if overriden in Python */
  else if (unlikely(Py_TYPE(((PyObject *)__pyx_v_self))->tp_dictoffset != 0)) {
    __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_distance_pt); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 175; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(strcmp(Py_TYPE(__pyx_1)->tp_name, "builtin_function_or_method") == 0) || (PyCFunction_GET_FUNCTION(__pyx_1) != (void *)&__pyx_pf_6ligeos_9linearref_4Line_distance_pt)) {
      __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 175; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(((PyObject *)__pyx_v_p));
      PyTuple_SET_ITEM(__pyx_2, 0, ((PyObject *)__pyx_v_p));
      __pyx_3 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 175; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      __pyx_4 = __pyx_PyFloat_AsDouble(__pyx_3); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 175; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_r = __pyx_4;
      goto __pyx_L0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":177
 *     cpdef double distance_pt(self, CPoint p):
 *         """The distance from the nearest point on this line to the given point."""
 *         return seg_distance_pt(self.p1, self.p2, p)             # <<<<<<<<<<<<<<
 * 
 *     cpdef double distance_seg(self, Line s):
 */
  __pyx_r = __pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_self->p1, __pyx_v_self->p2, __pyx_v_p, 0);
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_WriteUnraisable("ligeos.linearref.Line.distance_pt");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":175
 *         return seg_closest_pt(self.p1, self.p2, p)
 * 
 *     cpdef double distance_pt(self, CPoint p):             # <<<<<<<<<<<<<<
 *         """The distance from the nearest point on this line to the given point."""
 *         return seg_distance_pt(self.p1, self.p2, p)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_4Line_distance_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p); /*proto*/
static char __pyx_doc_6ligeos_9linearref_4Line_distance_pt[] = "The distance from the nearest point on this line to the given point.";
static PyObject *__pyx_pf_6ligeos_9linearref_4Line_distance_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_p), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "p", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 175; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_vtabstruct_6ligeos_9linearref_Line *)((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self)->__pyx_vtab)->distance_pt(((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_p), 1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 175; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.Line.distance_pt");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":179
 *         return seg_distance_pt(self.p1, self.p2, p)
 * 
 *     cpdef double distance_seg(self, Line s):             # <<<<<<<<<<<<<<
 *         """The closest distance from this line to another line."""
 *         return seg_distance_seg(self.p1, self.p2, s.p1, s.p2)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_4Line_distance_seg(PyObject *__pyx_v_self, PyObject *__pyx_v_s); /*proto*/
static  double __pyx_f_6ligeos_9linearref_4Line_distance_seg(struct __pyx_obj_6ligeos_9linearref_Line *__pyx_v_self, struct __pyx_obj_6ligeos_9linearref_Line *__pyx_v_s, int __pyx_skip_dispatch) {
  double __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  double __pyx_4;
  /* Check if called by wrapper */
  if (unlikely(__pyx_skip_dispatch)) ;
  /* Check if overriden in Python */
  else if (unlikely(Py_TYPE(((PyObject *)__pyx_v_self))->tp_dictoffset != 0)) {
    __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_distance_seg); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 179; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(strcmp(Py_TYPE(__pyx_1)->tp_name, "builtin_function_or_method") == 0) || (PyCFunction_GET_FUNCTION(__pyx_1) != (void *)&__pyx_pf_6ligeos_9linearref_4Line_distance_seg)) {
      __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 179; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(((PyObject *)__pyx_v_s));
      PyTuple_SET_ITEM(__pyx_2, 0, ((PyObject *)__pyx_v_s));
      __pyx_3 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 179; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      __pyx_4 = __pyx_PyFloat_AsDouble(__pyx_3); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 179; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_r = __pyx_4;
      goto __pyx_L0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":181
 *     cpdef double distance_seg(self, Line s):
 *         """The closest distance from this line to another line."""
 *         return seg_distance_seg(self.p1, self.p2, s.p1, s.p2)             # <<<<<<<<<<<<<<
 * 
 * cdef struct Vector2D:
 */
  __pyx_r = __pyx_f_6ligeos_9linearref_seg_distance_seg(__pyx_v_self->p1, __pyx_v_self->p2, __pyx_v_s->p1, __pyx_v_s->p2, 0);
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_WriteUnraisable("ligeos.linearref.Line.distance_seg");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":179
 *         return seg_distance_pt(self.p1, self.p2, p)
 * 
 *     cpdef double distance_seg(self, Line s):             # <<<<<<<<<<<<<<
 *         """The closest distance from this line to another line."""
 *         return seg_distance_seg(self.p1, self.p2, s.p1, s.p2)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_4Line_distance_seg(PyObject *__pyx_v_self, PyObject *__pyx_v_s); /*proto*/
static char __pyx_doc_6ligeos_9linearref_4Line_distance_seg[] = "The closest distance from this line to another line.";
static PyObject *__pyx_pf_6ligeos_9linearref_4Line_distance_seg(PyObject *__pyx_v_self, PyObject *__pyx_v_s) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_s), __pyx_ptype_6ligeos_9linearref_Line, 1, "s", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 179; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_vtabstruct_6ligeos_9linearref_Line *)((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self)->__pyx_vtab)->distance_seg(((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_self), ((struct __pyx_obj_6ligeos_9linearref_Line *)__pyx_v_s), 1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 179; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.Line.distance_seg");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":186
 *     double x, y
 * 
 * cpdef CPoint seg_intersect_seg(CPoint a, CPoint b, CPoint c, CPoint d):             # <<<<<<<<<<<<<<
 *     if ( a._x == b._x) and (a._y == b._y):
 *         if seg_distance_pt(c, d, a) == 0:
 */

static PyObject *__pyx_pf_6ligeos_9linearref_seg_intersect_seg(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_f_6ligeos_9linearref_seg_intersect_seg(struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_a, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_b, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_c, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_d, int __pyx_skip_dispatch) {
  float __pyx_v_r_bot;
  double __pyx_v_x;
  double __pyx_v_y;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":187
 * 
 * cpdef CPoint seg_intersect_seg(CPoint a, CPoint b, CPoint c, CPoint d):
 *     if ( a._x == b._x) and (a._y == b._y):             # <<<<<<<<<<<<<<
 *         if seg_distance_pt(c, d, a) == 0:
 *             return a.clone()
 */
  __pyx_1 = (__pyx_v_a->_x == __pyx_v_b->_x);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_a->_y == __pyx_v_b->_y);
  }
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":188
 * cpdef CPoint seg_intersect_seg(CPoint a, CPoint b, CPoint c, CPoint d):
 *     if ( a._x == b._x) and (a._y == b._y):
 *         if seg_distance_pt(c, d, a) == 0:             # <<<<<<<<<<<<<<
 *             return a.clone()
 *         return None
 */
    __pyx_1 = (__pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_c, __pyx_v_d, __pyx_v_a, 0) == 0);
    if (__pyx_1) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":189
 *     if ( a._x == b._x) and (a._y == b._y):
 *         if seg_distance_pt(c, d, a) == 0:
 *             return a.clone()             # <<<<<<<<<<<<<<
 *         return None
 * 
 */
      __pyx_2 = PyObject_GetAttr(((PyObject *)__pyx_v_a), __pyx_kp_clone); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 189; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyObject_Call(__pyx_2, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 189; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      if (!(__Pyx_TypeTest(__pyx_3, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 189; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3);
      __pyx_3 = 0;
      goto __pyx_L0;
      goto __pyx_L4;
    }
    __pyx_L4:;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":190
 *         if seg_distance_pt(c, d, a) == 0:
 *             return a.clone()
 *         return None             # <<<<<<<<<<<<<<
 * 
 *     # U and V are the same point
 */
    Py_INCREF(Py_None);
    __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None);
    goto __pyx_L0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":193
 * 
 *     # U and V are the same point
 *     if ( c._x == d._x) and (c._y == d._y):             # <<<<<<<<<<<<<<
 *         if seg_distance_pt(a, b, c) == 0:
 *             return c.clone()
 */
  __pyx_1 = (__pyx_v_c->_x == __pyx_v_d->_x);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_c->_y == __pyx_v_d->_y);
  }
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":194
 *     # U and V are the same point
 *     if ( c._x == d._x) and (c._y == d._y):
 *         if seg_distance_pt(a, b, c) == 0:             # <<<<<<<<<<<<<<
 *             return c.clone()
 *         return None
 */
    __pyx_1 = (__pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_a, __pyx_v_b, __pyx_v_c, 0) == 0);
    if (__pyx_1) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":195
 *     if ( c._x == d._x) and (c._y == d._y):
 *         if seg_distance_pt(a, b, c) == 0:
 *             return c.clone()             # <<<<<<<<<<<<<<
 *         return None
 * 
 */
      __pyx_2 = PyObject_GetAttr(((PyObject *)__pyx_v_c), __pyx_kp_clone); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 195; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyObject_Call(__pyx_2, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 195; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      if (!(__Pyx_TypeTest(__pyx_3, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 195; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3);
      __pyx_3 = 0;
      goto __pyx_L0;
      goto __pyx_L6;
    }
    __pyx_L6:;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":196
 *         if seg_distance_pt(a, b, c) == 0:
 *             return c.clone()
 *         return None             # <<<<<<<<<<<<<<
 * 
 *     if (( a._x == c._x ) and ( a._y == c._y )) or (( a._x == d._x ) and ( a._y == d._y )):
 */
    Py_INCREF(Py_None);
    __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None);
    goto __pyx_L0;
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":198
 *         return None
 * 
 *     if (( a._x == c._x ) and ( a._y == c._y )) or (( a._x == d._x ) and ( a._y == d._y )):             # <<<<<<<<<<<<<<
 *         return a.clone()
 * 
 */
  __pyx_1 = (__pyx_v_a->_x == __pyx_v_c->_x);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_a->_y == __pyx_v_c->_y);
  }
  if (!__pyx_1) {
    __pyx_1 = (__pyx_v_a->_x == __pyx_v_d->_x);
    if (__pyx_1) {
      __pyx_1 = (__pyx_v_a->_y == __pyx_v_d->_y);
    }
  }
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":199
 * 
 *     if (( a._x == c._x ) and ( a._y == c._y )) or (( a._x == d._x ) and ( a._y == d._y )):
 *         return a.clone()             # <<<<<<<<<<<<<<
 * 
 *     if ( b._x == c._x ) and ( b._y == c._y ) or (( b._x == d._x ) and ( b._y == d._y )):
 */
    __pyx_2 = PyObject_GetAttr(((PyObject *)__pyx_v_a), __pyx_kp_clone); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 199; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyObject_Call(__pyx_2, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 199; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    if (!(__Pyx_TypeTest(__pyx_3, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 199; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3);
    __pyx_3 = 0;
    goto __pyx_L0;
    goto __pyx_L7;
  }
  __pyx_L7:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":201
 *         return a.clone()
 * 
 *     if ( b._x == c._x ) and ( b._y == c._y ) or (( b._x == d._x ) and ( b._y == d._y )):             # <<<<<<<<<<<<<<
 *         return b.clone()
 * 
 */
  __pyx_1 = (__pyx_v_b->_x == __pyx_v_c->_x);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_b->_y == __pyx_v_c->_y);
  }
  if (!__pyx_1) {
    __pyx_1 = (__pyx_v_b->_x == __pyx_v_d->_x);
    if (__pyx_1) {
      __pyx_1 = (__pyx_v_b->_y == __pyx_v_d->_y);
    }
  }
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":202
 * 
 *     if ( b._x == c._x ) and ( b._y == c._y ) or (( b._x == d._x ) and ( b._y == d._y )):
 *         return b.clone()             # <<<<<<<<<<<<<<
 * 
 *     cdef float r_bot = (b._x-a._x)*(d._y-c._y) - (b._y-a._y)*(d._x-c._x)
 */
    __pyx_2 = PyObject_GetAttr(((PyObject *)__pyx_v_b), __pyx_kp_clone); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 202; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyObject_Call(__pyx_2, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 202; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    if (!(__Pyx_TypeTest(__pyx_3, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 202; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3);
    __pyx_3 = 0;
    goto __pyx_L0;
    goto __pyx_L8;
  }
  __pyx_L8:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":204
 *         return b.clone()
 * 
 *     cdef float r_bot = (b._x-a._x)*(d._y-c._y) - (b._y-a._y)*(d._x-c._x)             # <<<<<<<<<<<<<<
 *     # colinear or parallel lines
 *     if r_bot == 0:
 */
  __pyx_v_r_bot = (((__pyx_v_b->_x - __pyx_v_a->_x) * (__pyx_v_d->_y - __pyx_v_c->_y)) - ((__pyx_v_b->_y - __pyx_v_a->_y) * (__pyx_v_d->_x - __pyx_v_c->_x)));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":206
 *     cdef float r_bot = (b._x-a._x)*(d._y-c._y) - (b._y-a._y)*(d._x-c._x)
 *     # colinear or parallel lines
 *     if r_bot == 0:             # <<<<<<<<<<<<<<
 *         return None
 * 
 */
  __pyx_1 = (__pyx_v_r_bot == 0);
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":207
 *     # colinear or parallel lines
 *     if r_bot == 0:
 *         return None             # <<<<<<<<<<<<<<
 * 
 *     cdef double x, y
 */
    Py_INCREF(Py_None);
    __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None);
    goto __pyx_L0;
    goto __pyx_L9;
  }
  __pyx_L9:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":210
 * 
 *     cdef double x, y
 *     x = ((a._x*b._y - a._y*b._x)*(c._x - d._x) - (a._x - b._x)*(c._x*d._y - c._y*d._x)) / ((a._x - b._x)*(c._y - d._y) - (a._y - b._y)*(c._x - d._x))             # <<<<<<<<<<<<<<
 *     y = ((a._x*b._y - a._y*b._x)*(c._y - d._y) - (a._y - b._y)*(c._x*d._y - c._y*d._x)) / ((a._x - b._x)*(c._y - d._y) - (a._y - b._y)*(c._x - d._x))
 *     return CPoint(x, y, a.geo)
 */
  __pyx_v_x = (((((__pyx_v_a->_x * __pyx_v_b->_y) - (__pyx_v_a->_y * __pyx_v_b->_x)) * (__pyx_v_c->_x - __pyx_v_d->_x)) - ((__pyx_v_a->_x - __pyx_v_b->_x) * ((__pyx_v_c->_x * __pyx_v_d->_y) - (__pyx_v_c->_y * __pyx_v_d->_x)))) / (((__pyx_v_a->_x - __pyx_v_b->_x) * (__pyx_v_c->_y - __pyx_v_d->_y)) - ((__pyx_v_a->_y - __pyx_v_b->_y) * (__pyx_v_c->_x - __pyx_v_d->_x))));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":211
 *     cdef double x, y
 *     x = ((a._x*b._y - a._y*b._x)*(c._x - d._x) - (a._x - b._x)*(c._x*d._y - c._y*d._x)) / ((a._x - b._x)*(c._y - d._y) - (a._y - b._y)*(c._x - d._x))
 *     y = ((a._x*b._y - a._y*b._x)*(c._y - d._y) - (a._y - b._y)*(c._x*d._y - c._y*d._x)) / ((a._x - b._x)*(c._y - d._y) - (a._y - b._y)*(c._x - d._x))             # <<<<<<<<<<<<<<
 *     return CPoint(x, y, a.geo)
 * 
 */
  __pyx_v_y = (((((__pyx_v_a->_x * __pyx_v_b->_y) - (__pyx_v_a->_y * __pyx_v_b->_x)) * (__pyx_v_c->_y - __pyx_v_d->_y)) - ((__pyx_v_a->_y - __pyx_v_b->_y) * ((__pyx_v_c->_x * __pyx_v_d->_y) - (__pyx_v_c->_y * __pyx_v_d->_x)))) / (((__pyx_v_a->_x - __pyx_v_b->_x) * (__pyx_v_c->_y - __pyx_v_d->_y)) - ((__pyx_v_a->_y - __pyx_v_b->_y) * (__pyx_v_c->_x - __pyx_v_d->_x))));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":212
 *     x = ((a._x*b._y - a._y*b._x)*(c._x - d._x) - (a._x - b._x)*(c._x*d._y - c._y*d._x)) / ((a._x - b._x)*(c._y - d._y) - (a._y - b._y)*(c._x - d._x))
 *     y = ((a._x*b._y - a._y*b._x)*(c._y - d._y) - (a._y - b._y)*(c._x*d._y - c._y*d._x)) / ((a._x - b._x)*(c._y - d._y) - (a._y - b._y)*(c._x - d._x))
 *     return CPoint(x, y, a.geo)             # <<<<<<<<<<<<<<
 * 
 * 
 */
  __pyx_2 = PyFloat_FromDouble(__pyx_v_x); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 212; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyFloat_FromDouble(__pyx_v_y); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 212; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_4 = PyTuple_New(3); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 212; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_4, 0, __pyx_2);
  PyTuple_SET_ITEM(__pyx_4, 1, __pyx_3);
  Py_INCREF(((PyObject *)__pyx_v_a->geo));
  PyTuple_SET_ITEM(__pyx_4, 2, ((PyObject *)__pyx_v_a->geo));
  __pyx_2 = 0;
  __pyx_3 = 0;
  __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_CPoint)), ((PyObject *)__pyx_4), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 212; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_4)); __pyx_4 = 0;
  if (!(__Pyx_TypeTest(__pyx_2, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 212; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_2);
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("ligeos.linearref.seg_intersect_seg");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":186
 *     double x, y
 * 
 * cpdef CPoint seg_intersect_seg(CPoint a, CPoint b, CPoint c, CPoint d):             # <<<<<<<<<<<<<<
 *     if ( a._x == b._x) and (a._y == b._y):
 *         if seg_distance_pt(c, d, a) == 0:
 */

static PyObject *__pyx_pf_6ligeos_9linearref_seg_intersect_seg(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static PyObject *__pyx_pf_6ligeos_9linearref_seg_intersect_seg(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_a = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_b = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_c = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_d = 0;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_a,&__pyx_kp_b,&__pyx_kp_c,&__pyx_kp_d,0};
  __pyx_self = __pyx_self;
  if (unlikely(__pyx_kwds)) {
    PyObject* values[4] = {0,0,0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  4: values[3] = PyTuple_GET_ITEM(__pyx_args, 3);
      case  3: values[2] = PyTuple_GET_ITEM(__pyx_args, 2);
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_a);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_b);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("seg_intersect_seg", 1, 4, 4, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 186; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
      case  2:
      values[2] = PyDict_GetItem(__pyx_kwds, __pyx_kp_c);
      if (likely(values[2])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("seg_intersect_seg", 1, 4, 4, 2); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 186; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
      case  3:
      values[3] = PyDict_GetItem(__pyx_kwds, __pyx_kp_d);
      if (likely(values[3])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("seg_intersect_seg", 1, 4, 4, 3); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 186; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "seg_intersect_seg") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 186; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_a = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[0]);
    __pyx_v_b = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[1]);
    __pyx_v_c = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[2]);
    __pyx_v_d = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[3]);
  } else if (PyTuple_GET_SIZE(__pyx_args) != 4) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_a = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 0));
    __pyx_v_b = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 1));
    __pyx_v_c = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 2));
    __pyx_v_d = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 3));
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("seg_intersect_seg", 1, 4, 4, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 186; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.seg_intersect_seg");
  return NULL;
  __pyx_L4_argument_unpacking_done:;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_a), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "a", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 186; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_b), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "b", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 186; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_c), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "c", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 186; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_d), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "d", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 186; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = ((PyObject *)__pyx_f_6ligeos_9linearref_seg_intersect_seg(__pyx_v_a, __pyx_v_b, __pyx_v_c, __pyx_v_d, 0)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 186; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.seg_intersect_seg");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":215
 * 
 * 
 * cpdef double seg_distance_seg(CPoint a, CPoint b, CPoint c, CPoint d):             # <<<<<<<<<<<<<<
 *     """The closest distance from one line to another line."""
 *     # A and B are the same point
 */

static PyObject *__pyx_pf_6ligeos_9linearref_seg_distance_seg(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static  double __pyx_f_6ligeos_9linearref_seg_distance_seg(struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_a, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_b, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_c, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_d, int __pyx_skip_dispatch) {
  float __pyx_v_r_top;
  float __pyx_v_r_bot;
  float __pyx_v_s_top;
  float __pyx_v_s_bot;
  float __pyx_v_sv;
  float __pyx_v_r;
  double __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  double __pyx_7;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":218
 *     """The closest distance from one line to another line."""
 *     # A and B are the same point
 *     if ( a._x == b._x) and (a._y == b._y):             # <<<<<<<<<<<<<<
 *         return seg_distance_pt(c, d, a)
 * 
 */
  __pyx_1 = (__pyx_v_a->_x == __pyx_v_b->_x);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_a->_y == __pyx_v_b->_y);
  }
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":219
 *     # A and B are the same point
 *     if ( a._x == b._x) and (a._y == b._y):
 *         return seg_distance_pt(c, d, a)             # <<<<<<<<<<<<<<
 * 
 *     # U and V are the same point
 */
    __pyx_r = __pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_c, __pyx_v_d, __pyx_v_a, 0);
    goto __pyx_L0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":222
 * 
 *     # U and V are the same point
 *     if ( c._x == d._x) and (c._y == d._y):             # <<<<<<<<<<<<<<
 *         return seg_distance_pt(a, b, c)
 * 
 */
  __pyx_1 = (__pyx_v_c->_x == __pyx_v_d->_x);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_c->_y == __pyx_v_d->_y);
  }
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":223
 *     # U and V are the same point
 *     if ( c._x == d._x) and (c._y == d._y):
 *         return seg_distance_pt(a, b, c)             # <<<<<<<<<<<<<<
 * 
 *     """
 */
    __pyx_r = __pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_a, __pyx_v_b, __pyx_v_c, 0);
    goto __pyx_L0;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":247
 *         If the numerator in eqn 1 is also zero, AB & CD are collinear.
 *     """
 *     cdef float r_top = (a._y-c._y)*(d._x-c._x) - (a._x-c._x)*(d._y-c._y)             # <<<<<<<<<<<<<<
 *     cdef float r_bot = (b._x-a._x)*(d._y-c._y) - (b._y-a._y)*(d._x-c._x)
 * 
 */
  __pyx_v_r_top = (((__pyx_v_a->_y - __pyx_v_c->_y) * (__pyx_v_d->_x - __pyx_v_c->_x)) - ((__pyx_v_a->_x - __pyx_v_c->_x) * (__pyx_v_d->_y - __pyx_v_c->_y)));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":248
 *     """
 *     cdef float r_top = (a._y-c._y)*(d._x-c._x) - (a._x-c._x)*(d._y-c._y)
 *     cdef float r_bot = (b._x-a._x)*(d._y-c._y) - (b._y-a._y)*(d._x-c._x)             # <<<<<<<<<<<<<<
 * 
 *     cdef float s_top = (a._y-c._y)*(b._x-a._x) - (a._x-c._x)*(b._y-a._y)
 */
  __pyx_v_r_bot = (((__pyx_v_b->_x - __pyx_v_a->_x) * (__pyx_v_d->_y - __pyx_v_c->_y)) - ((__pyx_v_b->_y - __pyx_v_a->_y) * (__pyx_v_d->_x - __pyx_v_c->_x)));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":250
 *     cdef float r_bot = (b._x-a._x)*(d._y-c._y) - (b._y-a._y)*(d._x-c._x)
 * 
 *     cdef float s_top = (a._y-c._y)*(b._x-a._x) - (a._x-c._x)*(b._y-a._y)             # <<<<<<<<<<<<<<
 *     cdef float s_bot = r_bot
 * 
 */
  __pyx_v_s_top = (((__pyx_v_a->_y - __pyx_v_c->_y) * (__pyx_v_b->_x - __pyx_v_a->_x)) - ((__pyx_v_a->_x - __pyx_v_c->_x) * (__pyx_v_b->_y - __pyx_v_a->_y)));

  /* "/home/nino/ligeos/ligeos/linearref.pyx":251
 * 
 *     cdef float s_top = (a._y-c._y)*(b._x-a._x) - (a._x-c._x)*(b._y-a._y)
 *     cdef float s_bot = r_bot             # <<<<<<<<<<<<<<
 * 
 *     if  r_bot==0 or s_bot == 0:
 */
  __pyx_v_s_bot = __pyx_v_r_bot;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":253
 *     cdef float s_bot = r_bot
 * 
 *     if  r_bot==0 or s_bot == 0:             # <<<<<<<<<<<<<<
 *         return min(seg_distance_pt(c, d, a),
 *                    min(seg_distance_pt(c, d, b),
 */
  __pyx_1 = (__pyx_v_r_bot == 0);
  if (!__pyx_1) {
    __pyx_1 = (__pyx_v_s_bot == 0);
  }
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":254
 * 
 *     if  r_bot==0 or s_bot == 0:
 *         return min(seg_distance_pt(c, d, a),             # <<<<<<<<<<<<<<
 *                    min(seg_distance_pt(c, d, b),
 *                        min(seg_distance_pt(a, b, c), seg_distance_pt(a, b, d))))
 */
    __pyx_2 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_c, __pyx_v_d, __pyx_v_a, 0)); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 254; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

    /* "/home/nino/ligeos/ligeos/linearref.pyx":255
 *     if  r_bot==0 or s_bot == 0:
 *         return min(seg_distance_pt(c, d, a),
 *                    min(seg_distance_pt(c, d, b),             # <<<<<<<<<<<<<<
 *                        min(seg_distance_pt(a, b, c), seg_distance_pt(a, b, d))))
 *     cdef float sv = s_top/s_bot
 */
    __pyx_3 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_c, __pyx_v_d, __pyx_v_b, 0)); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 255; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

    /* "/home/nino/ligeos/ligeos/linearref.pyx":256
 *         return min(seg_distance_pt(c, d, a),
 *                    min(seg_distance_pt(c, d, b),
 *                        min(seg_distance_pt(a, b, c), seg_distance_pt(a, b, d))))             # <<<<<<<<<<<<<<
 *     cdef float sv = s_top/s_bot
 *     cdef float r = r_top/r_bot
 */
    __pyx_4 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_a, __pyx_v_b, __pyx_v_c, 0)); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 256; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_5 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_a, __pyx_v_b, __pyx_v_d, 0)); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 256; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_6 = PyTuple_New(2); if (unlikely(!__pyx_6)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 256; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_6, 0, __pyx_4);
    PyTuple_SET_ITEM(__pyx_6, 1, __pyx_5);
    __pyx_4 = 0;
    __pyx_5 = 0;
    __pyx_4 = PyObject_Call(__pyx_builtin_min, ((PyObject *)__pyx_6), NULL); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 256; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_6)); __pyx_6 = 0;
    __pyx_5 = PyTuple_New(2); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 255; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_3);
    PyTuple_SET_ITEM(__pyx_5, 1, __pyx_4);
    __pyx_3 = 0;
    __pyx_4 = 0;
    __pyx_6 = PyObject_Call(__pyx_builtin_min, ((PyObject *)__pyx_5), NULL); if (unlikely(!__pyx_6)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 255; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
    __pyx_3 = PyTuple_New(2); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 254; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
    PyTuple_SET_ITEM(__pyx_3, 1, __pyx_6);
    __pyx_2 = 0;
    __pyx_6 = 0;
    __pyx_4 = PyObject_Call(__pyx_builtin_min, ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 254; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
    __pyx_7 = __pyx_PyFloat_AsDouble(__pyx_4); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 254; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_r = __pyx_7;
    goto __pyx_L0;
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":257
 *                    min(seg_distance_pt(c, d, b),
 *                        min(seg_distance_pt(a, b, c), seg_distance_pt(a, b, d))))
 *     cdef float sv = s_top/s_bot             # <<<<<<<<<<<<<<
 *     cdef float r = r_top/r_bot
 * 
 */
  __pyx_v_sv = (__pyx_v_s_top / __pyx_v_s_bot);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":258
 *                        min(seg_distance_pt(a, b, c), seg_distance_pt(a, b, d))))
 *     cdef float sv = s_top/s_bot
 *     cdef float r = r_top/r_bot             # <<<<<<<<<<<<<<
 * 
 *     if r<0 or r>1 or sv<0 or sv>1:
 */
  __pyx_v_r = (__pyx_v_r_top / __pyx_v_r_bot);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":260
 *     cdef float r = r_top/r_bot
 * 
 *     if r<0 or r>1 or sv<0 or sv>1:             # <<<<<<<<<<<<<<
 *         #no intersection
 *         #print "R/S", a, b, c, d, r, sv, s_top, s_bot, r_top, r_bot
 */
  __pyx_1 = (__pyx_v_r < 0);
  if (!__pyx_1) {
    __pyx_1 = (__pyx_v_r > 1);
    if (!__pyx_1) {
      __pyx_1 = (__pyx_v_sv < 0);
      if (!__pyx_1) {
        __pyx_1 = (__pyx_v_sv > 1);
      }
    }
  }
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":263
 *         #no intersection
 *         #print "R/S", a, b, c, d, r, sv, s_top, s_bot, r_top, r_bot
 *         return min(seg_distance_pt(c, d, a),             # <<<<<<<<<<<<<<
 *                    min(seg_distance_pt(c, d, b),
 *                        min(seg_distance_pt(a, b, c),
 */
    __pyx_5 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_c, __pyx_v_d, __pyx_v_a, 0)); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 263; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

    /* "/home/nino/ligeos/ligeos/linearref.pyx":264
 *         #print "R/S", a, b, c, d, r, sv, s_top, s_bot, r_top, r_bot
 *         return min(seg_distance_pt(c, d, a),
 *                    min(seg_distance_pt(c, d, b),             # <<<<<<<<<<<<<<
 *                        min(seg_distance_pt(a, b, c),
 *                            seg_distance_pt(a, b, d))))
 */
    __pyx_2 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_c, __pyx_v_d, __pyx_v_b, 0)); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 264; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

    /* "/home/nino/ligeos/ligeos/linearref.pyx":265
 *         return min(seg_distance_pt(c, d, a),
 *                    min(seg_distance_pt(c, d, b),
 *                        min(seg_distance_pt(a, b, c),             # <<<<<<<<<<<<<<
 *                            seg_distance_pt(a, b, d))))
 * 
 */
    __pyx_6 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_a, __pyx_v_b, __pyx_v_c, 0)); if (unlikely(!__pyx_6)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 265; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

    /* "/home/nino/ligeos/ligeos/linearref.pyx":266
 *                    min(seg_distance_pt(c, d, b),
 *                        min(seg_distance_pt(a, b, c),
 *                            seg_distance_pt(a, b, d))))             # <<<<<<<<<<<<<<
 * 
 *     else:
 */
    __pyx_3 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_a, __pyx_v_b, __pyx_v_d, 0)); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 266; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_4 = PyTuple_New(2); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 265; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_6);
    PyTuple_SET_ITEM(__pyx_4, 1, __pyx_3);
    __pyx_6 = 0;
    __pyx_3 = 0;
    __pyx_6 = PyObject_Call(__pyx_builtin_min, ((PyObject *)__pyx_4), NULL); if (unlikely(!__pyx_6)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 265; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_4)); __pyx_4 = 0;
    __pyx_3 = PyTuple_New(2); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 264; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
    PyTuple_SET_ITEM(__pyx_3, 1, __pyx_6);
    __pyx_2 = 0;
    __pyx_6 = 0;
    __pyx_4 = PyObject_Call(__pyx_builtin_min, ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 264; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
    __pyx_2 = PyTuple_New(2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 263; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_5);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_4);
    __pyx_5 = 0;
    __pyx_4 = 0;
    __pyx_6 = PyObject_Call(__pyx_builtin_min, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_6)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 263; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
    __pyx_7 = __pyx_PyFloat_AsDouble(__pyx_6); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 263; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    __pyx_r = __pyx_7;
    goto __pyx_L0;
    goto __pyx_L6;
  }
  /*else*/ {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":269
 * 
 *     else:
 *         return 0#; intersection exists             # <<<<<<<<<<<<<<
 * 
 * cpdef double seg_distance_pt(CPoint a, CPoint b, CPoint p):
 */
    __pyx_r = 0;
    goto __pyx_L0;
  }
  __pyx_L6:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  __Pyx_WriteUnraisable("ligeos.linearref.seg_distance_seg");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":215
 * 
 * 
 * cpdef double seg_distance_seg(CPoint a, CPoint b, CPoint c, CPoint d):             # <<<<<<<<<<<<<<
 *     """The closest distance from one line to another line."""
 *     # A and B are the same point
 */

static PyObject *__pyx_pf_6ligeos_9linearref_seg_distance_seg(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_6ligeos_9linearref_seg_distance_seg[] = "The closest distance from one line to another line.";
static PyObject *__pyx_pf_6ligeos_9linearref_seg_distance_seg(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_a = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_b = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_c = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_d = 0;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_a,&__pyx_kp_b,&__pyx_kp_c,&__pyx_kp_d,0};
  __pyx_self = __pyx_self;
  if (unlikely(__pyx_kwds)) {
    PyObject* values[4] = {0,0,0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  4: values[3] = PyTuple_GET_ITEM(__pyx_args, 3);
      case  3: values[2] = PyTuple_GET_ITEM(__pyx_args, 2);
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_a);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_b);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("seg_distance_seg", 1, 4, 4, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 215; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
      case  2:
      values[2] = PyDict_GetItem(__pyx_kwds, __pyx_kp_c);
      if (likely(values[2])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("seg_distance_seg", 1, 4, 4, 2); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 215; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
      case  3:
      values[3] = PyDict_GetItem(__pyx_kwds, __pyx_kp_d);
      if (likely(values[3])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("seg_distance_seg", 1, 4, 4, 3); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 215; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "seg_distance_seg") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 215; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_a = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[0]);
    __pyx_v_b = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[1]);
    __pyx_v_c = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[2]);
    __pyx_v_d = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[3]);
  } else if (PyTuple_GET_SIZE(__pyx_args) != 4) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_a = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 0));
    __pyx_v_b = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 1));
    __pyx_v_c = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 2));
    __pyx_v_d = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 3));
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("seg_distance_seg", 1, 4, 4, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 215; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.seg_distance_seg");
  return NULL;
  __pyx_L4_argument_unpacking_done:;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_a), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "a", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 215; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_b), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "b", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 215; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_c), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "c", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 215; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_d), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "d", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 215; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_seg_distance_seg(__pyx_v_a, __pyx_v_b, __pyx_v_c, __pyx_v_d, 0)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 215; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.seg_distance_seg");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":271
 *         return 0#; intersection exists
 * 
 * cpdef double seg_distance_pt(CPoint a, CPoint b, CPoint p):             # <<<<<<<<<<<<<<
 *     """The closest distance from a line to a point."""
 *     cdef CPoint c = seg_closest_pt(a, b, p)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_seg_distance_pt(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static  double __pyx_f_6ligeos_9linearref_seg_distance_pt(struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_a, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_b, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p, int __pyx_skip_dispatch) {
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_c = 0;
  double __pyx_r;
  PyObject *__pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":273
 * cpdef double seg_distance_pt(CPoint a, CPoint b, CPoint p):
 *     """The closest distance from a line to a point."""
 *     cdef CPoint c = seg_closest_pt(a, b, p)             # <<<<<<<<<<<<<<
 *     #print "Closest", c
 *     return c.distance_pt(p)
 */
  __pyx_1 = ((PyObject *)__pyx_f_6ligeos_9linearref_seg_closest_pt(__pyx_v_a, __pyx_v_b, __pyx_v_p, 0)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 273; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_v_c = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_1);
  __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":275
 *     cdef CPoint c = seg_closest_pt(a, b, p)
 *     #print "Closest", c
 *     return c.distance_pt(p)             # <<<<<<<<<<<<<<
 * 
 * cpdef CPoint seg_closest_pt(CPoint a, CPoint b, CPoint p):
 */
  __pyx_r = ((struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *)__pyx_v_c->__pyx_vtab)->distance_pt(__pyx_v_c, __pyx_v_p, 0);
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_WriteUnraisable("ligeos.linearref.seg_distance_pt");
  __pyx_r = 0;
  __pyx_L0:;
  Py_XDECREF(__pyx_v_c);
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":271
 *         return 0#; intersection exists
 * 
 * cpdef double seg_distance_pt(CPoint a, CPoint b, CPoint p):             # <<<<<<<<<<<<<<
 *     """The closest distance from a line to a point."""
 *     cdef CPoint c = seg_closest_pt(a, b, p)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_seg_distance_pt(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_6ligeos_9linearref_seg_distance_pt[] = "The closest distance from a line to a point.";
static PyObject *__pyx_pf_6ligeos_9linearref_seg_distance_pt(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_a = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_b = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p = 0;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_a,&__pyx_kp_b,&__pyx_kp_p,0};
  __pyx_self = __pyx_self;
  if (unlikely(__pyx_kwds)) {
    PyObject* values[3] = {0,0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  3: values[2] = PyTuple_GET_ITEM(__pyx_args, 2);
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_a);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_b);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("seg_distance_pt", 1, 3, 3, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
      case  2:
      values[2] = PyDict_GetItem(__pyx_kwds, __pyx_kp_p);
      if (likely(values[2])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("seg_distance_pt", 1, 3, 3, 2); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "seg_distance_pt") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_a = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[0]);
    __pyx_v_b = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[1]);
    __pyx_v_p = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[2]);
  } else if (PyTuple_GET_SIZE(__pyx_args) != 3) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_a = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 0));
    __pyx_v_b = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 1));
    __pyx_v_p = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 2));
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("seg_distance_pt", 1, 3, 3, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.seg_distance_pt");
  return NULL;
  __pyx_L4_argument_unpacking_done:;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_a), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "a", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_b), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "b", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_p), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "p", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_a, __pyx_v_b, __pyx_v_p, 0)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.seg_distance_pt");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":277
 *     return c.distance_pt(p)
 * 
 * cpdef CPoint seg_closest_pt(CPoint a, CPoint b, CPoint p):             # <<<<<<<<<<<<<<
 *     """The point from a line to another line."""
 *     if a._x == b._x and b._y == a._y:
 */

static PyObject *__pyx_pf_6ligeos_9linearref_seg_closest_pt(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_f_6ligeos_9linearref_seg_closest_pt(struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_a, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_b, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p, int __pyx_skip_dispatch) {
  PyObject *__pyx_v_r;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_t_1 = NULL;
  PyObject *__pyx_t_2 = NULL;
  PyObject *__pyx_t_3 = NULL;
  __pyx_v_r = Py_None; Py_INCREF(Py_None);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":279
 * cpdef CPoint seg_closest_pt(CPoint a, CPoint b, CPoint p):
 *     """The point from a line to another line."""
 *     if a._x == b._x and b._y == a._y:             # <<<<<<<<<<<<<<
 *         #print "Case 1"
 *         return a
 */
  __pyx_1 = (__pyx_v_a->_x == __pyx_v_b->_x);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_b->_y == __pyx_v_a->_y);
  }
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":281
 *     if a._x == b._x and b._y == a._y:
 *         #print "Case 1"
 *         return a             # <<<<<<<<<<<<<<
 * 
 *     """
 */
    Py_INCREF(((PyObject *)__pyx_v_a));
    __pyx_r = __pyx_v_a;
    goto __pyx_L0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":300
 *     """
 * 
 *     r = ((p._x-a._x) * (b._x-a._x) + (p._y-a._y) * (b._y-a._y)) / ((b._x-a._x)*(b._x-a._x) +(b._y-a._y)*(b._y-a._y))             # <<<<<<<<<<<<<<
 *     #print "r", r
 *     if r<0:
 */
  __pyx_2 = PyFloat_FromDouble(((((__pyx_v_p->_x - __pyx_v_a->_x) * (__pyx_v_b->_x - __pyx_v_a->_x)) + ((__pyx_v_p->_y - __pyx_v_a->_y) * (__pyx_v_b->_y - __pyx_v_a->_y))) / (((__pyx_v_b->_x - __pyx_v_a->_x) * (__pyx_v_b->_x - __pyx_v_a->_x)) + ((__pyx_v_b->_y - __pyx_v_a->_y) * (__pyx_v_b->_y - __pyx_v_a->_y))))); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 300; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_v_r);
  __pyx_v_r = __pyx_2;
  __pyx_2 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":302
 *     r = ((p._x-a._x) * (b._x-a._x) + (p._y-a._y) * (b._y-a._y)) / ((b._x-a._x)*(b._x-a._x) +(b._y-a._y)*(b._y-a._y))
 *     #print "r", r
 *     if r<0:             # <<<<<<<<<<<<<<
 *         #print "Case 2"
 *         return a.clone()
 */
  __pyx_2 = PyObject_RichCompare(__pyx_v_r, __pyx_int_0, Py_LT); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 302; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = __Pyx_PyObject_IsTrue(__pyx_2); if (unlikely(__pyx_1 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 302; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":304
 *     if r<0:
 *         #print "Case 2"
 *         return a.clone()             # <<<<<<<<<<<<<<
 *     if r>1:
 *         #print "Case 3"
 */
    __pyx_2 = PyObject_GetAttr(((PyObject *)__pyx_v_a), __pyx_kp_clone); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 304; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyObject_Call(__pyx_2, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 304; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    if (!(__Pyx_TypeTest(__pyx_3, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 304; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3);
    __pyx_3 = 0;
    goto __pyx_L0;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":305
 *         #print "Case 2"
 *         return a.clone()
 *     if r>1:             # <<<<<<<<<<<<<<
 *         #print "Case 3"
 *         return b.clone()
 */
  __pyx_2 = PyObject_RichCompare(__pyx_v_r, __pyx_int_1, Py_GT); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 305; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = __Pyx_PyObject_IsTrue(__pyx_2); if (unlikely(__pyx_1 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 305; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":307
 *     if r>1:
 *         #print "Case 3"
 *         return b.clone()             # <<<<<<<<<<<<<<
 * 
 *     return CPoint(a._x + r*(b._x - a._x), a._y + r*(b._y - a._y), a.geo)
 */
    __pyx_3 = PyObject_GetAttr(((PyObject *)__pyx_v_b), __pyx_kp_clone); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 307; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_2 = PyObject_Call(__pyx_3, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 307; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    if (!(__Pyx_TypeTest(__pyx_2, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 307; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_2);
    __pyx_2 = 0;
    goto __pyx_L0;
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":309
 *         return b.clone()
 * 
 *     return CPoint(a._x + r*(b._x - a._x), a._y + r*(b._y - a._y), a.geo)             # <<<<<<<<<<<<<<
 * 
 * cdef interpolate_point2d(CPoint A, CPoint B, float F):
 */
  __pyx_3 = PyFloat_FromDouble(__pyx_v_a->_x); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 309; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyFloat_FromDouble((__pyx_v_b->_x - __pyx_v_a->_x)); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 309; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_t_1 = PyNumber_Multiply(__pyx_v_r, __pyx_2); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 309; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_t_2 = PyNumber_Add(__pyx_3, __pyx_t_1); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 309; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
  __pyx_2 = PyFloat_FromDouble(__pyx_v_a->_y); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 309; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyFloat_FromDouble((__pyx_v_b->_y - __pyx_v_a->_y)); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 309; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_t_1 = PyNumber_Multiply(__pyx_v_r, __pyx_3); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 309; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_t_3 = PyNumber_Add(__pyx_2, __pyx_t_1); if (unlikely(!__pyx_t_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 309; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
  __pyx_3 = PyTuple_New(3); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 309; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_t_2);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_t_3);
  Py_INCREF(((PyObject *)__pyx_v_a->geo));
  PyTuple_SET_ITEM(__pyx_3, 2, ((PyObject *)__pyx_v_a->geo));
  __pyx_t_2 = 0;
  __pyx_t_3 = 0;
  __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_CPoint)), ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 309; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
  if (!(__Pyx_TypeTest(__pyx_2, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 309; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_2);
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("ligeos.linearref.seg_closest_pt");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_r);
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":277
 *     return c.distance_pt(p)
 * 
 * cpdef CPoint seg_closest_pt(CPoint a, CPoint b, CPoint p):             # <<<<<<<<<<<<<<
 *     """The point from a line to another line."""
 *     if a._x == b._x and b._y == a._y:
 */

static PyObject *__pyx_pf_6ligeos_9linearref_seg_closest_pt(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_6ligeos_9linearref_seg_closest_pt[] = "The point from a line to another line.";
static PyObject *__pyx_pf_6ligeos_9linearref_seg_closest_pt(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_a = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_b = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p = 0;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_a,&__pyx_kp_b,&__pyx_kp_p,0};
  __pyx_self = __pyx_self;
  if (unlikely(__pyx_kwds)) {
    PyObject* values[3] = {0,0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  3: values[2] = PyTuple_GET_ITEM(__pyx_args, 2);
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_a);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_b);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("seg_closest_pt", 1, 3, 3, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 277; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
      case  2:
      values[2] = PyDict_GetItem(__pyx_kwds, __pyx_kp_p);
      if (likely(values[2])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("seg_closest_pt", 1, 3, 3, 2); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 277; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "seg_closest_pt") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 277; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_a = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[0]);
    __pyx_v_b = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[1]);
    __pyx_v_p = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)values[2]);
  } else if (PyTuple_GET_SIZE(__pyx_args) != 3) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_a = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 0));
    __pyx_v_b = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 1));
    __pyx_v_p = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)PyTuple_GET_ITEM(__pyx_args, 2));
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("seg_closest_pt", 1, 3, 3, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 277; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.seg_closest_pt");
  return NULL;
  __pyx_L4_argument_unpacking_done:;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_a), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "a", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 277; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_b), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "b", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 277; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_p), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "p", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 277; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = ((PyObject *)__pyx_f_6ligeos_9linearref_seg_closest_pt(__pyx_v_a, __pyx_v_b, __pyx_v_p, 0)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 277; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.seg_closest_pt");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":311
 *     return CPoint(a._x + r*(b._x - a._x), a._y + r*(b._y - a._y), a.geo)
 * 
 * cdef interpolate_point2d(CPoint A, CPoint B, float F):             # <<<<<<<<<<<<<<
 *         return CPoint(A.x+((B.x-A.x)*F), A.y+((B.y-A.y)*F), A.geo)
 * 
 */

static  PyObject *__pyx_f_6ligeos_9linearref_interpolate_point2d(struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_A, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_B, float __pyx_v_F) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_t_1 = NULL;
  PyObject *__pyx_t_2 = NULL;
  PyObject *__pyx_t_3 = NULL;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":312
 * 
 * cdef interpolate_point2d(CPoint A, CPoint B, float F):
 *         return CPoint(A.x+((B.x-A.x)*F), A.y+((B.y-A.y)*F), A.geo)             # <<<<<<<<<<<<<<
 * 
 * cdef CPoint _to_cpoint(object arg, object geographic):
 */
  __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_A), __pyx_kp_x); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyObject_GetAttr(((PyObject *)__pyx_v_B), __pyx_kp_x); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyObject_GetAttr(((PyObject *)__pyx_v_A), __pyx_kp_x); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_t_1 = PyNumber_Subtract(__pyx_2, __pyx_3); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_2 = PyFloat_FromDouble(__pyx_v_F); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_t_2 = PyNumber_Multiply(__pyx_t_1, __pyx_2); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_t_1 = PyNumber_Add(__pyx_1, __pyx_t_2); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_t_2); __pyx_t_2 = 0;
  __pyx_3 = PyObject_GetAttr(((PyObject *)__pyx_v_A), __pyx_kp_y); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyObject_GetAttr(((PyObject *)__pyx_v_B), __pyx_kp_y); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_A), __pyx_kp_y); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_t_2 = PyNumber_Subtract(__pyx_2, __pyx_1); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_2 = PyFloat_FromDouble(__pyx_v_F); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_t_3 = PyNumber_Multiply(__pyx_t_2, __pyx_2); if (unlikely(!__pyx_t_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_t_2); __pyx_t_2 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_t_2 = PyNumber_Add(__pyx_3, __pyx_t_3); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_t_3); __pyx_t_3 = 0;
  __pyx_1 = PyTuple_New(3); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_t_1);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_t_2);
  Py_INCREF(((PyObject *)__pyx_v_A->geo));
  PyTuple_SET_ITEM(__pyx_1, 2, ((PyObject *)__pyx_v_A->geo));
  __pyx_t_1 = 0;
  __pyx_t_2 = 0;
  __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_CPoint)), ((PyObject *)__pyx_1), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 312; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_1)); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("ligeos.linearref.interpolate_point2d");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":314
 *         return CPoint(A.x+((B.x-A.x)*F), A.y+((B.y-A.y)*F), A.geo)
 * 
 * cdef CPoint _to_cpoint(object arg, object geographic):             # <<<<<<<<<<<<<<
 *     #print "Arg:", type(arg)
 *     if type(arg) == tuple or type(arg) == list:
 */

static  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_f_6ligeos_9linearref__to_cpoint(PyObject *__pyx_v_arg, PyObject *__pyx_v_geographic) {
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_t_1 = NULL;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":316
 * cdef CPoint _to_cpoint(object arg, object geographic):
 *     #print "Arg:", type(arg)
 *     if type(arg) == tuple or type(arg) == list:             # <<<<<<<<<<<<<<
 *         return CPoint(float(arg[0]), float(arg[1]), geographic)
 *     if hasattr(arg,"x") and hasattr(arg,"y"):
 */
  __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 316; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_arg);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_arg);
  __pyx_3 = PyObject_Call(((PyObject *)((PyObject*)&PyType_Type)), ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 316; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  __pyx_2 = PyObject_RichCompare(__pyx_3, ((PyObject *)((PyObject*)&PyTuple_Type)), Py_EQ); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 316; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_1 = __Pyx_PyObject_IsTrue(__pyx_2); if (unlikely(__pyx_1 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 316; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (!__pyx_1) {
    __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 316; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_INCREF(__pyx_v_arg);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_arg);
    __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)&PyType_Type)), ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 316; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
    __pyx_3 = PyObject_RichCompare(__pyx_2, ((PyObject *)((PyObject*)&PyList_Type)), Py_EQ); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 316; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_1 = __Pyx_PyObject_IsTrue(__pyx_3); if (unlikely(__pyx_1 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 316; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
  }
  if (__pyx_1) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":317
 *     #print "Arg:", type(arg)
 *     if type(arg) == tuple or type(arg) == list:
 *         return CPoint(float(arg[0]), float(arg[1]), geographic)             # <<<<<<<<<<<<<<
 *     if hasattr(arg,"x") and hasattr(arg,"y"):
 *         return CPoint(float(arg.x), float(arg.y), geographic)
 */
    __pyx_2 = __Pyx_GetItemInt(__pyx_v_arg, 0, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 317; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 317; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
    __pyx_2 = 0;
    __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)&PyFloat_Type)), ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 317; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
    __pyx_3 = __Pyx_GetItemInt(__pyx_v_arg, 1, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 317; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_5 = PyTuple_New(1); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 317; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_Call(((PyObject *)((PyObject*)&PyFloat_Type)), ((PyObject *)__pyx_5), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 317; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
    __pyx_5 = PyTuple_New(3); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 317; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_2);
    PyTuple_SET_ITEM(__pyx_5, 1, __pyx_3);
    Py_INCREF(__pyx_v_geographic);
    PyTuple_SET_ITEM(__pyx_5, 2, __pyx_v_geographic);
    __pyx_2 = 0;
    __pyx_3 = 0;
    __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_CPoint)), ((PyObject *)__pyx_5), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 317; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
    if (!(__Pyx_TypeTest(__pyx_2, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 317; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_2);
    __pyx_2 = 0;
    goto __pyx_L0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":318
 *     if type(arg) == tuple or type(arg) == list:
 *         return CPoint(float(arg[0]), float(arg[1]), geographic)
 *     if hasattr(arg,"x") and hasattr(arg,"y"):             # <<<<<<<<<<<<<<
 *         return CPoint(float(arg.x), float(arg.y), geographic)
 *     raise TypeError("unable to convert %s to a coordinate" % type(arg))
 */
  __pyx_4 = PyObject_HasAttr(__pyx_v_arg, __pyx_kp_15); if (unlikely(__pyx_4 == -1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 318; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (__pyx_4) {
    __pyx_4 = PyObject_HasAttr(__pyx_v_arg, __pyx_kp_16); if (unlikely(__pyx_4 == -1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 318; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  }
  if (__pyx_4) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":319
 *         return CPoint(float(arg[0]), float(arg[1]), geographic)
 *     if hasattr(arg,"x") and hasattr(arg,"y"):
 *         return CPoint(float(arg.x), float(arg.y), geographic)             # <<<<<<<<<<<<<<
 *     raise TypeError("unable to convert %s to a coordinate" % type(arg))
 * 
 */
    __pyx_3 = PyObject_GetAttr(__pyx_v_arg, __pyx_kp_x); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 319; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_5 = PyTuple_New(1); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 319; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)&PyFloat_Type)), ((PyObject *)__pyx_5), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 319; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
    __pyx_3 = PyObject_GetAttr(__pyx_v_arg, __pyx_kp_y); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 319; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_5 = PyTuple_New(1); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 319; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_Call(((PyObject *)((PyObject*)&PyFloat_Type)), ((PyObject *)__pyx_5), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 319; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
    __pyx_5 = PyTuple_New(3); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 319; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_2);
    PyTuple_SET_ITEM(__pyx_5, 1, __pyx_3);
    Py_INCREF(__pyx_v_geographic);
    PyTuple_SET_ITEM(__pyx_5, 2, __pyx_v_geographic);
    __pyx_2 = 0;
    __pyx_3 = 0;
    __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_CPoint)), ((PyObject *)__pyx_5), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 319; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
    if (!(__Pyx_TypeTest(__pyx_2, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 319; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_2);
    __pyx_2 = 0;
    goto __pyx_L0;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":320
 *     if hasattr(arg,"x") and hasattr(arg,"y"):
 *         return CPoint(float(arg.x), float(arg.y), geographic)
 *     raise TypeError("unable to convert %s to a coordinate" % type(arg))             # <<<<<<<<<<<<<<
 * 
 * cdef class LineString:
 */
  __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 320; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_arg);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_arg);
  __pyx_5 = PyObject_Call(((PyObject *)((PyObject*)&PyType_Type)), ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 320; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
  __pyx_t_1 = PyNumber_Remainder(__pyx_kp_17, __pyx_5); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 320; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;
  __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 320; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_t_1);
  __pyx_t_1 = 0;
  __pyx_3 = PyObject_Call(__pyx_builtin_TypeError, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 320; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  __Pyx_Raise(__pyx_3, 0, 0);
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  {__pyx_filename = __pyx_f[0]; __pyx_lineno = 320; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("ligeos.linearref._to_cpoint");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":326
 *     cdef object _pts
 *     cdef object geographic # cant be a bool, because cython chokes on it.
 *     def __init__(self, *args, geographic=False):             # <<<<<<<<<<<<<<
 *         self._pts = []
 *         self.geographic = bool(geographic) == True
 */

static int __pyx_pf_6ligeos_9linearref_10LineString___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_pf_6ligeos_9linearref_10LineString___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_geographic = 0;
  PyObject *__pyx_v_args = 0;
  PyObject *__pyx_v_pts;
  PyObject *__pyx_v_a;
  PyObject *__pyx_v__a;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_ssize_t __pyx_4 = 0;
  int __pyx_5;
  int __pyx_6;
  Py_ssize_t __pyx_7 = 0;
  PyObject *__pyx_8 = 0;
  PyObject *__pyx_9 = 0;
  int __pyx_10;
  PyObject *__pyx_11 = 0;
  PyObject *__pyx_12 = 0;
  PyObject *__pyx_t_1 = NULL;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_geographic,0};
  __pyx_v_geographic = __pyx_k_12;
  if (PyTuple_GET_SIZE(__pyx_args) > 0) {
    __pyx_v_args = PyTuple_GetSlice(__pyx_args, 0, PyTuple_GET_SIZE(__pyx_args)); if (unlikely(!__pyx_v_args)) return -1;
  } else {
    __pyx_v_args = __pyx_empty_tuple; Py_INCREF(__pyx_empty_tuple);
  }
  if (unlikely(__pyx_kwds)) {
    PyObject* values[1] = {0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      default:
      case  0: break;
    }
    if (unlikely(kw_args > 0)) {
      const Py_ssize_t used_pos_args = (PyTuple_GET_SIZE(__pyx_args) < 0) ? PyTuple_GET_SIZE(__pyx_args) : 0;
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, used_pos_args, "__init__") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 326; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    if (values[0]) {
      __pyx_v_geographic = values[0];
    }
  } else if (PyTuple_GET_SIZE(__pyx_args) < 0) {
    goto __pyx_L5_argtuple_error;
  } else {
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("__init__", 0, 0, 0, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 326; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  Py_DECREF(__pyx_v_args);
  __Pyx_AddTraceback("ligeos.linearref.LineString.__init__");
  return -1;
  __pyx_L4_argument_unpacking_done:;
  __pyx_v_pts = Py_None; Py_INCREF(Py_None);
  __pyx_v_a = Py_None; Py_INCREF(Py_None);
  __pyx_v__a = Py_None; Py_INCREF(Py_None);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":327
 *     cdef object geographic # cant be a bool, because cython chokes on it.
 *     def __init__(self, *args, geographic=False):
 *         self._pts = []             # <<<<<<<<<<<<<<
 *         self.geographic = bool(geographic) == True
 *         pts = []
 */
  __pyx_1 = PyList_New(0); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 327; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts);
  ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts = ((PyObject *)__pyx_1);
  __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":328
 *     def __init__(self, *args, geographic=False):
 *         self._pts = []
 *         self.geographic = bool(geographic) == True             # <<<<<<<<<<<<<<
 *         pts = []
 *         for a in args:
 */
  __pyx_1 = PyTuple_New(1); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 328; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_geographic);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_geographic);
  __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)&PyBool_Type)), ((PyObject *)__pyx_1), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 328; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_1)); __pyx_1 = 0;
  __pyx_1 = __Pyx_PyBool_FromLong(1); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 328; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyObject_RichCompare(__pyx_2, __pyx_1, Py_EQ); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 328; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->geographic);
  ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->geographic = __pyx_3;
  __pyx_3 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":329
 *         self._pts = []
 *         self.geographic = bool(geographic) == True
 *         pts = []             # <<<<<<<<<<<<<<
 *         for a in args:
 *             #print type(a), type(a[0])
 */
  __pyx_2 = PyList_New(0); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 329; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_v_pts);
  __pyx_v_pts = ((PyObject *)__pyx_2);
  __pyx_2 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":330
 *         self.geographic = bool(geographic) == True
 *         pts = []
 *         for a in args:             # <<<<<<<<<<<<<<
 *             #print type(a), type(a[0])
 *             if (type(a) == list or type(a) == tuple) and (type(a[0]) == tuple or type(a[0]) == list):
 */
  if (PyList_CheckExact(__pyx_v_args) || PyTuple_CheckExact(__pyx_v_args)) {
    __pyx_4 = 0; __pyx_1 = __pyx_v_args; Py_INCREF(__pyx_1);
  } else {
    __pyx_4 = -1; __pyx_1 = PyObject_GetIter(__pyx_v_args); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 330; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  }
  for (;;) {
    if (likely(PyList_CheckExact(__pyx_1))) {
      if (__pyx_4 >= PyList_GET_SIZE(__pyx_1)) break;
      __pyx_3 = PyList_GET_ITEM(__pyx_1, __pyx_4); Py_INCREF(__pyx_3); __pyx_4++;
    } else if (likely(PyTuple_CheckExact(__pyx_1))) {
      if (__pyx_4 >= PyTuple_GET_SIZE(__pyx_1)) break;
      __pyx_3 = PyTuple_GET_ITEM(__pyx_1, __pyx_4); Py_INCREF(__pyx_3); __pyx_4++;
    } else {
      __pyx_3 = PyIter_Next(__pyx_1);
      if (!__pyx_3) {
        if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 330; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        break;
      }
    }
    Py_DECREF(__pyx_v_a);
    __pyx_v_a = __pyx_3;
    __pyx_3 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":332
 *         for a in args:
 *             #print type(a), type(a[0])
 *             if (type(a) == list or type(a) == tuple) and (type(a[0]) == tuple or type(a[0]) == list):             # <<<<<<<<<<<<<<
 *                 self._pts.extend([_to_cpoint(_a, geographic) for _a in a])
 *             elif type(a) in (list, tuple) and type(a[0]) == CPoint:
 */
    __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_INCREF(__pyx_v_a);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_a);
    __pyx_3 = PyObject_Call(((PyObject *)((PyObject*)&PyType_Type)), ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
    __pyx_2 = PyObject_RichCompare(__pyx_3, ((PyObject *)((PyObject*)&PyList_Type)), Py_EQ); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_5 = __Pyx_PyObject_IsTrue(__pyx_2); if (unlikely(__pyx_5 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    if (!__pyx_5) {
      __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(__pyx_v_a);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_a);
      __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)&PyType_Type)), ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
      __pyx_3 = PyObject_RichCompare(__pyx_2, ((PyObject *)((PyObject*)&PyTuple_Type)), Py_EQ); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_5 = __Pyx_PyObject_IsTrue(__pyx_3); if (unlikely(__pyx_5 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
    }
    if (__pyx_5) {
      __pyx_2 = __Pyx_GetItemInt(__pyx_v_a, 0, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
      __pyx_2 = 0;
      __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)&PyType_Type)), ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
      __pyx_3 = PyObject_RichCompare(__pyx_2, ((PyObject *)((PyObject*)&PyTuple_Type)), Py_EQ); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_5 = __Pyx_PyObject_IsTrue(__pyx_3); if (unlikely(__pyx_5 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      if (!__pyx_5) {
        __pyx_2 = __Pyx_GetItemInt(__pyx_v_a, 0, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
        __pyx_2 = 0;
        __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)&PyType_Type)), ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
        __pyx_3 = PyObject_RichCompare(__pyx_2, ((PyObject *)((PyObject*)&PyList_Type)), Py_EQ); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        __pyx_5 = __Pyx_PyObject_IsTrue(__pyx_3); if (unlikely(__pyx_5 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 332; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
      }
    }
    if (__pyx_5) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":333
 *             #print type(a), type(a[0])
 *             if (type(a) == list or type(a) == tuple) and (type(a[0]) == tuple or type(a[0]) == list):
 *                 self._pts.extend([_to_cpoint(_a, geographic) for _a in a])             # <<<<<<<<<<<<<<
 *             elif type(a) in (list, tuple) and type(a[0]) == CPoint:
 *                 self._pts.extend([CPoint(_a.x, _a.y, geographic) for _a in a])
 */
      __pyx_2 = PyObject_GetAttr(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts, __pyx_kp_extend); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 333; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyList_New(0); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 333; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (PyList_CheckExact(__pyx_v_a) || PyTuple_CheckExact(__pyx_v_a)) {
        __pyx_7 = 0; __pyx_8 = __pyx_v_a; Py_INCREF(__pyx_8);
      } else {
        __pyx_7 = -1; __pyx_8 = PyObject_GetIter(__pyx_v_a); if (unlikely(!__pyx_8)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 333; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      }
      for (;;) {
        if (likely(PyList_CheckExact(__pyx_8))) {
          if (__pyx_7 >= PyList_GET_SIZE(__pyx_8)) break;
          __pyx_9 = PyList_GET_ITEM(__pyx_8, __pyx_7); Py_INCREF(__pyx_9); __pyx_7++;
        } else if (likely(PyTuple_CheckExact(__pyx_8))) {
          if (__pyx_7 >= PyTuple_GET_SIZE(__pyx_8)) break;
          __pyx_9 = PyTuple_GET_ITEM(__pyx_8, __pyx_7); Py_INCREF(__pyx_9); __pyx_7++;
        } else {
          __pyx_9 = PyIter_Next(__pyx_8);
          if (!__pyx_9) {
            if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 333; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
            break;
          }
        }
        Py_DECREF(__pyx_v__a);
        __pyx_v__a = __pyx_9;
        __pyx_9 = 0;
        __pyx_9 = ((PyObject *)__pyx_f_6ligeos_9linearref__to_cpoint(__pyx_v__a, __pyx_v_geographic)); if (unlikely(!__pyx_9)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 333; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_10 = PyList_Append(__pyx_3, (PyObject*)__pyx_9); if (unlikely(__pyx_10)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 333; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_9); __pyx_9 = 0;
      }
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_9 = PyTuple_New(1); if (unlikely(!__pyx_9)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 333; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      PyTuple_SET_ITEM(__pyx_9, 0, ((PyObject *)__pyx_3));
      __pyx_3 = 0;
      __pyx_8 = PyObject_Call(__pyx_2, ((PyObject *)__pyx_9), NULL); if (unlikely(!__pyx_8)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 333; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(((PyObject *)__pyx_9)); __pyx_9 = 0;
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      goto __pyx_L8;
    }

    /* "/home/nino/ligeos/ligeos/linearref.pyx":334
 *             if (type(a) == list or type(a) == tuple) and (type(a[0]) == tuple or type(a[0]) == list):
 *                 self._pts.extend([_to_cpoint(_a, geographic) for _a in a])
 *             elif type(a) in (list, tuple) and type(a[0]) == CPoint:             # <<<<<<<<<<<<<<
 *                 self._pts.extend([CPoint(_a.x, _a.y, geographic) for _a in a])
 *             elif type(a) in (list, tuple) and type(a[0]) in (float,int):
 */
    __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 334; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_INCREF(__pyx_v_a);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_a);
    __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)&PyType_Type)), ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 334; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
    __pyx_9 = __pyx_2;
    Py_INCREF(__pyx_9);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_8 = PyObject_RichCompare(__pyx_9, ((PyObject *)((PyObject*)&PyList_Type)), Py_EQ); if (unlikely(!__pyx_8)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 334; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_5 = __Pyx_PyObject_IsTrue(__pyx_8); if (unlikely((__pyx_5 == (int)-1))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 334; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_8); __pyx_8 = 0;
    __pyx_6 = ((int)__pyx_5);
    if (!__pyx_6) {
      __pyx_3 = PyObject_RichCompare(__pyx_9, ((PyObject *)((PyObject*)&PyTuple_Type)), Py_EQ); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 334; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      __pyx_5 = __Pyx_PyObject_IsTrue(__pyx_3); if (unlikely((__pyx_5 == (int)-1))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 334; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_6 = ((int)__pyx_5);
    }
    if (__pyx_6) {
      __pyx_2 = __Pyx_GetItemInt(__pyx_v_a, 0, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 334; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_8 = PyTuple_New(1); if (unlikely(!__pyx_8)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 334; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      PyTuple_SET_ITEM(__pyx_8, 0, __pyx_2);
      __pyx_2 = 0;
      __pyx_9 = PyObject_Call(((PyObject *)((PyObject*)&PyType_Type)), ((PyObject *)__pyx_8), NULL); if (unlikely(!__pyx_9)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 334; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_8)); __pyx_8 = 0;
      __pyx_3 = PyObject_RichCompare(__pyx_9, ((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_CPoint)), Py_EQ); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 334; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      __pyx_6 = __Pyx_PyObject_IsTrue(__pyx_3); if (unlikely(__pyx_6 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 334; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
    }
    if (__pyx_6) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":335
 *                 self._pts.extend([_to_cpoint(_a, geographic) for _a in a])
 *             elif type(a) in (list, tuple) and type(a[0]) == CPoint:
 *                 self._pts.extend([CPoint(_a.x, _a.y, geographic) for _a in a])             # <<<<<<<<<<<<<<
 *             elif type(a) in (list, tuple) and type(a[0]) in (float,int):
 *                 self._pts.append(_to_cpoint(a, geographic))
 */
      __pyx_2 = PyObject_GetAttr(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts, __pyx_kp_extend); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 335; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_8 = PyList_New(0); if (unlikely(!__pyx_8)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 335; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (PyList_CheckExact(__pyx_v_a) || PyTuple_CheckExact(__pyx_v_a)) {
        __pyx_7 = 0; __pyx_9 = __pyx_v_a; Py_INCREF(__pyx_9);
      } else {
        __pyx_7 = -1; __pyx_9 = PyObject_GetIter(__pyx_v_a); if (unlikely(!__pyx_9)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 335; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      }
      for (;;) {
        if (likely(PyList_CheckExact(__pyx_9))) {
          if (__pyx_7 >= PyList_GET_SIZE(__pyx_9)) break;
          __pyx_3 = PyList_GET_ITEM(__pyx_9, __pyx_7); Py_INCREF(__pyx_3); __pyx_7++;
        } else if (likely(PyTuple_CheckExact(__pyx_9))) {
          if (__pyx_7 >= PyTuple_GET_SIZE(__pyx_9)) break;
          __pyx_3 = PyTuple_GET_ITEM(__pyx_9, __pyx_7); Py_INCREF(__pyx_3); __pyx_7++;
        } else {
          __pyx_3 = PyIter_Next(__pyx_9);
          if (!__pyx_3) {
            if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 335; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
            break;
          }
        }
        Py_DECREF(__pyx_v__a);
        __pyx_v__a = __pyx_3;
        __pyx_3 = 0;
        __pyx_3 = PyObject_GetAttr(__pyx_v__a, __pyx_kp_x); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 335; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_11 = PyObject_GetAttr(__pyx_v__a, __pyx_kp_y); if (unlikely(!__pyx_11)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 335; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_12 = PyTuple_New(3); if (unlikely(!__pyx_12)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 335; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        PyTuple_SET_ITEM(__pyx_12, 0, __pyx_3);
        PyTuple_SET_ITEM(__pyx_12, 1, __pyx_11);
        Py_INCREF(__pyx_v_geographic);
        PyTuple_SET_ITEM(__pyx_12, 2, __pyx_v_geographic);
        __pyx_3 = 0;
        __pyx_11 = 0;
        __pyx_3 = PyObject_Call(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_CPoint)), ((PyObject *)__pyx_12), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 335; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(((PyObject *)__pyx_12)); __pyx_12 = 0;
        __pyx_10 = PyList_Append(__pyx_8, (PyObject*)__pyx_3); if (unlikely(__pyx_10)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 335; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
      }
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      __pyx_11 = PyTuple_New(1); if (unlikely(!__pyx_11)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 335; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      PyTuple_SET_ITEM(__pyx_11, 0, ((PyObject *)__pyx_8));
      __pyx_8 = 0;
      __pyx_12 = PyObject_Call(__pyx_2, ((PyObject *)__pyx_11), NULL); if (unlikely(!__pyx_12)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 335; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(((PyObject *)__pyx_11)); __pyx_11 = 0;
      Py_DECREF(__pyx_12); __pyx_12 = 0;
      goto __pyx_L8;
    }

    /* "/home/nino/ligeos/ligeos/linearref.pyx":336
 *             elif type(a) in (list, tuple) and type(a[0]) == CPoint:
 *                 self._pts.extend([CPoint(_a.x, _a.y, geographic) for _a in a])
 *             elif type(a) in (list, tuple) and type(a[0]) in (float,int):             # <<<<<<<<<<<<<<
 *                 self._pts.append(_to_cpoint(a, geographic))
 *             else:
 */
    __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_INCREF(__pyx_v_a);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_a);
    __pyx_9 = PyObject_Call(((PyObject *)((PyObject*)&PyType_Type)), ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_9)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
    __pyx_8 = __pyx_9;
    Py_INCREF(__pyx_8);
    Py_DECREF(__pyx_9); __pyx_9 = 0;
    __pyx_2 = PyObject_RichCompare(__pyx_8, ((PyObject *)((PyObject*)&PyList_Type)), Py_EQ); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_6 = __Pyx_PyObject_IsTrue(__pyx_2); if (unlikely((__pyx_6 == (int)-1))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_5 = ((int)__pyx_6);
    if (!__pyx_5) {
      __pyx_11 = PyObject_RichCompare(__pyx_8, ((PyObject *)((PyObject*)&PyTuple_Type)), Py_EQ); if (unlikely(!__pyx_11)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_6 = __Pyx_PyObject_IsTrue(__pyx_11); if (unlikely((__pyx_6 == (int)-1))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_11); __pyx_11 = 0;
      __pyx_5 = ((int)__pyx_6);
    }
    if (__pyx_5) {
      __pyx_12 = __Pyx_GetItemInt(__pyx_v_a, 0, 0); if (!__pyx_12) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_12);
      __pyx_12 = 0;
      __pyx_9 = PyObject_Call(((PyObject *)((PyObject*)&PyType_Type)), ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_9)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
      __pyx_2 = __pyx_9;
      Py_INCREF(__pyx_2);
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      __pyx_8 = PyObject_RichCompare(__pyx_2, ((PyObject *)((PyObject*)&PyFloat_Type)), Py_EQ); if (unlikely(!__pyx_8)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_6 = __Pyx_PyObject_IsTrue(__pyx_8); if (unlikely((__pyx_6 == (int)-1))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_5 = ((int)__pyx_6);
      if (!__pyx_5) {
        __pyx_11 = PyObject_RichCompare(__pyx_2, ((PyObject *)((PyObject*)&PyInt_Type)), Py_EQ); if (unlikely(!__pyx_11)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        __pyx_6 = __Pyx_PyObject_IsTrue(__pyx_11); if (unlikely((__pyx_6 == (int)-1))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 336; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_11); __pyx_11 = 0;
        __pyx_5 = ((int)__pyx_6);
      }
    }
    if (__pyx_5) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":337
 *                 self._pts.extend([CPoint(_a.x, _a.y, geographic) for _a in a])
 *             elif type(a) in (list, tuple) and type(a[0]) in (float,int):
 *                 self._pts.append(_to_cpoint(a, geographic))             # <<<<<<<<<<<<<<
 *             else:
 *                 raise ArgumentError("Invalid argument type/sequence: %s %s" %( type(a), a))
 */
      __pyx_12 = ((PyObject *)__pyx_f_6ligeos_9linearref__to_cpoint(__pyx_v_a, __pyx_v_geographic)); if (unlikely(!__pyx_12)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 337; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = __Pyx_PyObject_Append(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts, __pyx_12); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 337; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_12); __pyx_12 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      goto __pyx_L8;
    }
    /*else*/ {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":339
 *                 self._pts.append(_to_cpoint(a, geographic))
 *             else:
 *                 raise ArgumentError("Invalid argument type/sequence: %s %s" %( type(a), a))             # <<<<<<<<<<<<<<
 * 
 *     property pts:
 */
      __pyx_9 = __Pyx_GetName(__pyx_m, __pyx_kp_ArgumentError); if (unlikely(!__pyx_9)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_8 = PyTuple_New(1); if (unlikely(!__pyx_8)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(__pyx_v_a);
      PyTuple_SET_ITEM(__pyx_8, 0, __pyx_v_a);
      __pyx_2 = PyObject_Call(((PyObject *)((PyObject*)&PyType_Type)), ((PyObject *)__pyx_8), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_8)); __pyx_8 = 0;
      __pyx_11 = PyTuple_New(2); if (unlikely(!__pyx_11)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      PyTuple_SET_ITEM(__pyx_11, 0, __pyx_2);
      Py_INCREF(__pyx_v_a);
      PyTuple_SET_ITEM(__pyx_11, 1, __pyx_v_a);
      __pyx_2 = 0;
      __pyx_t_1 = PyNumber_Remainder(__pyx_kp_18, ((PyObject *)__pyx_11)); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_11)); __pyx_11 = 0;
      __pyx_12 = PyTuple_New(1); if (unlikely(!__pyx_12)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      PyTuple_SET_ITEM(__pyx_12, 0, __pyx_t_1);
      __pyx_t_1 = 0;
      __pyx_3 = PyObject_Call(__pyx_9, ((PyObject *)__pyx_12), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      Py_DECREF(((PyObject *)__pyx_12)); __pyx_12 = 0;
      __Pyx_Raise(__pyx_3, 0, 0);
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    }
    __pyx_L8:;
  }
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_8);
  Py_XDECREF(__pyx_9);
  Py_XDECREF(__pyx_11);
  Py_XDECREF(__pyx_12);
  __Pyx_AddTraceback("ligeos.linearref.LineString.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_args);
  Py_DECREF(__pyx_v_pts);
  Py_DECREF(__pyx_v_a);
  Py_DECREF(__pyx_v__a);
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":342
 * 
 *     property pts:
 *         def __get__(self):             # <<<<<<<<<<<<<<
 *             return self._pts
 * 
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_3pts___get__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_3pts___get__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":343
 *     property pts:
 *         def __get__(self):
 *             return self._pts             # <<<<<<<<<<<<<<
 * 
 *     def __len__(self):
 */
  Py_INCREF(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts);
  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":345
 *             return self._pts
 * 
 *     def __len__(self):             # <<<<<<<<<<<<<<
 *         return len(self._pts)
 * 
 */

static Py_ssize_t __pyx_pf_6ligeos_9linearref_10LineString___len__(PyObject *__pyx_v_self); /*proto*/
static Py_ssize_t __pyx_pf_6ligeos_9linearref_10LineString___len__(PyObject *__pyx_v_self) {
  Py_ssize_t __pyx_r;
  Py_ssize_t __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":346
 * 
 *     def __len__(self):
 *         return len(self._pts)             # <<<<<<<<<<<<<<
 * 
 *     def __str__(self):
 */
  __pyx_1 = PyObject_Length(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts); if (unlikely(__pyx_1 == -1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 346; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_AddTraceback("ligeos.linearref.LineString.__len__");
  __pyx_r = -1;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":348
 *         return len(self._pts)
 * 
 *     def __str__(self):             # <<<<<<<<<<<<<<
 *         return "(" + ",".join(map(str, self._pts)) + ")"
 * 
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString___str__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_pf_6ligeos_9linearref_10LineString___str__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_t_1 = NULL;
  PyObject *__pyx_t_2 = NULL;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":349
 * 
 *     def __str__(self):
 *         return "(" + ",".join(map(str, self._pts)) + ")"             # <<<<<<<<<<<<<<
 * 
 *     property coords:
 */
  __pyx_1 = PyObject_GetAttr(__pyx_kp_20, __pyx_kp_join); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 349; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyTuple_New(2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 349; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(((PyObject *)((PyObject*)&PyString_Type)));
  PyTuple_SET_ITEM(__pyx_2, 0, ((PyObject *)((PyObject*)&PyString_Type)));
  Py_INCREF(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts);
  PyTuple_SET_ITEM(__pyx_2, 1, ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts);
  __pyx_3 = PyObject_Call(__pyx_builtin_map, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 349; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 349; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
  __pyx_3 = 0;
  __pyx_3 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 349; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  __pyx_t_1 = PyNumber_Add(__pyx_kp_19, __pyx_3); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 349; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_t_2 = PyNumber_Add(__pyx_t_1, __pyx_kp_21); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 349; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
  __pyx_r = __pyx_t_2;
  __pyx_t_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("ligeos.linearref.LineString.__str__");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":352
 * 
 *     property coords:
 *         def __get__(self):             # <<<<<<<<<<<<<<
 *             return [(c.x, c.y) for c in self._pts]
 * 
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_6coords___get__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_6coords___get__(PyObject *__pyx_v_self) {
  PyObject *__pyx_v_c;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  Py_ssize_t __pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  int __pyx_7;
  __pyx_v_c = Py_None; Py_INCREF(Py_None);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":353
 *     property coords:
 *         def __get__(self):
 *             return [(c.x, c.y) for c in self._pts]             # <<<<<<<<<<<<<<
 * 
 *     def length(self):
 */
  __pyx_1 = PyList_New(0); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 353; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (PyList_CheckExact(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts) || PyTuple_CheckExact(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts)) {
    __pyx_2 = 0; __pyx_3 = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts; Py_INCREF(__pyx_3);
  } else {
    __pyx_2 = -1; __pyx_3 = PyObject_GetIter(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 353; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  }
  for (;;) {
    if (likely(PyList_CheckExact(__pyx_3))) {
      if (__pyx_2 >= PyList_GET_SIZE(__pyx_3)) break;
      __pyx_4 = PyList_GET_ITEM(__pyx_3, __pyx_2); Py_INCREF(__pyx_4); __pyx_2++;
    } else if (likely(PyTuple_CheckExact(__pyx_3))) {
      if (__pyx_2 >= PyTuple_GET_SIZE(__pyx_3)) break;
      __pyx_4 = PyTuple_GET_ITEM(__pyx_3, __pyx_2); Py_INCREF(__pyx_4); __pyx_2++;
    } else {
      __pyx_4 = PyIter_Next(__pyx_3);
      if (!__pyx_4) {
        if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 353; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        break;
      }
    }
    Py_DECREF(__pyx_v_c);
    __pyx_v_c = __pyx_4;
    __pyx_4 = 0;
    __pyx_4 = PyObject_GetAttr(__pyx_v_c, __pyx_kp_x); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 353; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_5 = PyObject_GetAttr(__pyx_v_c, __pyx_kp_y); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 353; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_6 = PyTuple_New(2); if (unlikely(!__pyx_6)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 353; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_6, 0, __pyx_4);
    PyTuple_SET_ITEM(__pyx_6, 1, __pyx_5);
    __pyx_4 = 0;
    __pyx_5 = 0;
    __pyx_7 = PyList_Append(__pyx_1, (PyObject*)__pyx_6); if (unlikely(__pyx_7)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 353; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_6)); __pyx_6 = 0;
  }
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_r = ((PyObject *)__pyx_1);
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  __Pyx_AddTraceback("ligeos.linearref.LineString.coords.__get__");
  __pyx_r = NULL;
  __pyx_L0:;
  Py_DECREF(__pyx_v_c);
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":355
 *             return [(c.x, c.y) for c in self._pts]
 * 
 *     def length(self):             # <<<<<<<<<<<<<<
 *         """Length of all segments comprising this line."""
 *         return sum([self._pts[i-1].distance_pt(self._pts[i]) for i in range(1,len(self._pts))])
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_length(PyObject *__pyx_v_self, PyObject *unused); /*proto*/
static char __pyx_doc_6ligeos_9linearref_10LineString_length[] = "Length of all segments comprising this line.";
static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_length(PyObject *__pyx_v_self, PyObject *unused) {
  PyObject *__pyx_v_i;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  Py_ssize_t __pyx_2 = 0;
  Py_ssize_t __pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  PyObject *__pyx_7 = 0;
  int __pyx_8;
  PyObject *__pyx_t_1 = NULL;
  __pyx_v_i = Py_None; Py_INCREF(Py_None);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":357
 *     def length(self):
 *         """Length of all segments comprising this line."""
 *         return sum([self._pts[i-1].distance_pt(self._pts[i]) for i in range(1,len(self._pts))])             # <<<<<<<<<<<<<<
 * 
 *     cpdef CPoint closest_pt(self, CPoint p):
 */
  __pyx_1 = PyList_New(0); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyObject_Length(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts); if (unlikely(__pyx_3 == -1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_4 = PyInt_FromSsize_t(__pyx_3); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_5 = PyTuple_New(2); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_int_1);
  PyTuple_SET_ITEM(__pyx_5, 0, __pyx_int_1);
  PyTuple_SET_ITEM(__pyx_5, 1, __pyx_4);
  __pyx_4 = 0;
  __pyx_4 = PyObject_Call(__pyx_builtin_range, ((PyObject *)__pyx_5), NULL); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
  if (PyList_CheckExact(__pyx_4) || PyTuple_CheckExact(__pyx_4)) {
    __pyx_2 = 0; __pyx_5 = __pyx_4; Py_INCREF(__pyx_5);
  } else {
    __pyx_2 = -1; __pyx_5 = PyObject_GetIter(__pyx_4); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  }
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  for (;;) {
    if (likely(PyList_CheckExact(__pyx_5))) {
      if (__pyx_2 >= PyList_GET_SIZE(__pyx_5)) break;
      __pyx_4 = PyList_GET_ITEM(__pyx_5, __pyx_2); Py_INCREF(__pyx_4); __pyx_2++;
    } else if (likely(PyTuple_CheckExact(__pyx_5))) {
      if (__pyx_2 >= PyTuple_GET_SIZE(__pyx_5)) break;
      __pyx_4 = PyTuple_GET_ITEM(__pyx_5, __pyx_2); Py_INCREF(__pyx_4); __pyx_2++;
    } else {
      __pyx_4 = PyIter_Next(__pyx_5);
      if (!__pyx_4) {
        if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        break;
      }
    }
    Py_DECREF(__pyx_v_i);
    __pyx_v_i = __pyx_4;
    __pyx_4 = 0;
    __pyx_t_1 = PyNumber_Subtract(__pyx_v_i, __pyx_int_1); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_4 = PyObject_GetItem(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts, __pyx_t_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    __pyx_6 = PyObject_GetAttr(__pyx_4, __pyx_kp_distance_pt); if (unlikely(!__pyx_6)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_4 = PyObject_GetItem(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->_pts, __pyx_v_i); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_7 = PyTuple_New(1); if (unlikely(!__pyx_7)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    PyTuple_SET_ITEM(__pyx_7, 0, __pyx_4);
    __pyx_4 = 0;
    __pyx_4 = PyObject_Call(__pyx_6, ((PyObject *)__pyx_7), NULL); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    Py_DECREF(((PyObject *)__pyx_7)); __pyx_7 = 0;
    __pyx_8 = PyList_Append(__pyx_1, (PyObject*)__pyx_4); if (unlikely(__pyx_8)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
  }
  Py_DECREF(__pyx_5); __pyx_5 = 0;
  __pyx_6 = PyTuple_New(1); if (unlikely(!__pyx_6)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_6, 0, ((PyObject *)__pyx_1));
  __pyx_1 = 0;
  __pyx_7 = PyObject_Call(__pyx_builtin_sum, ((PyObject *)__pyx_6), NULL); if (unlikely(!__pyx_7)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_6)); __pyx_6 = 0;
  __pyx_r = __pyx_7;
  __pyx_7 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  Py_XDECREF(__pyx_7);
  __Pyx_AddTraceback("ligeos.linearref.LineString.length");
  __pyx_r = NULL;
  __pyx_L0:;
  Py_DECREF(__pyx_v_i);
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":359
 *         return sum([self._pts[i-1].distance_pt(self._pts[i]) for i in range(1,len(self._pts))])
 * 
 *     cpdef CPoint closest_pt(self, CPoint p):             # <<<<<<<<<<<<<<
 *         """The nearest point on this linestring to a given point."""
 *         cdef int min_dist = -1
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_closest_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p); /*proto*/
static  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_f_6ligeos_9linearref_10LineString_closest_pt(struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_v_self, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p, int __pyx_skip_dispatch) {
  int __pyx_v_min_dist;
  PyObject *__pyx_v_closest;
  PyObject *__pyx_v_i;
  PyObject *__pyx_v_a;
  PyObject *__pyx_v_b;
  PyObject *__pyx_v_c;
  PyObject *__pyx_v_d;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_ssize_t __pyx_4 = 0;
  Py_ssize_t __pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  int __pyx_7;
  int __pyx_8;
  int __pyx_9;
  PyObject *__pyx_t_1 = NULL;
  __pyx_v_closest = Py_None; Py_INCREF(Py_None);
  __pyx_v_i = Py_None; Py_INCREF(Py_None);
  __pyx_v_a = Py_None; Py_INCREF(Py_None);
  __pyx_v_b = Py_None; Py_INCREF(Py_None);
  __pyx_v_c = Py_None; Py_INCREF(Py_None);
  __pyx_v_d = Py_None; Py_INCREF(Py_None);
  /* Check if called by wrapper */
  if (unlikely(__pyx_skip_dispatch)) ;
  /* Check if overriden in Python */
  else if (unlikely(Py_TYPE(((PyObject *)__pyx_v_self))->tp_dictoffset != 0)) {
    __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_closest_pt); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 359; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(strcmp(Py_TYPE(__pyx_1)->tp_name, "builtin_function_or_method") == 0) || (PyCFunction_GET_FUNCTION(__pyx_1) != (void *)&__pyx_pf_6ligeos_9linearref_10LineString_closest_pt)) {
      __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 359; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(((PyObject *)__pyx_v_p));
      PyTuple_SET_ITEM(__pyx_2, 0, ((PyObject *)__pyx_v_p));
      __pyx_3 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 359; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      if (!(__Pyx_TypeTest(__pyx_3, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 359; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3);
      __pyx_3 = 0;
      goto __pyx_L0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":361
 *     cpdef CPoint closest_pt(self, CPoint p):
 *         """The nearest point on this linestring to a given point."""
 *         cdef int min_dist = -1             # <<<<<<<<<<<<<<
 *         closest = None
 *         for i in range(1,len(self._pts)):
 */
  __pyx_v_min_dist = -1;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":362
 *         """The nearest point on this linestring to a given point."""
 *         cdef int min_dist = -1
 *         closest = None             # <<<<<<<<<<<<<<
 *         for i in range(1,len(self._pts)):
 *             a = self._pts[i-1]
 */
  Py_INCREF(Py_None);
  Py_DECREF(__pyx_v_closest);
  __pyx_v_closest = Py_None;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":363
 *         cdef int min_dist = -1
 *         closest = None
 *         for i in range(1,len(self._pts)):             # <<<<<<<<<<<<<<
 *             a = self._pts[i-1]
 *             b = self._pts[i]
 */
  __pyx_5 = PyObject_Length(__pyx_v_self->_pts); if (unlikely(__pyx_5 == -1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 363; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyInt_FromSsize_t(__pyx_5); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 363; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyTuple_New(2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 363; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_int_1);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_int_1);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_1);
  __pyx_1 = 0;
  __pyx_3 = PyObject_Call(__pyx_builtin_range, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 363; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  if (PyList_CheckExact(__pyx_3) || PyTuple_CheckExact(__pyx_3)) {
    __pyx_4 = 0; __pyx_1 = __pyx_3; Py_INCREF(__pyx_1);
  } else {
    __pyx_4 = -1; __pyx_1 = PyObject_GetIter(__pyx_3); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 363; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  }
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  for (;;) {
    if (likely(PyList_CheckExact(__pyx_1))) {
      if (__pyx_4 >= PyList_GET_SIZE(__pyx_1)) break;
      __pyx_2 = PyList_GET_ITEM(__pyx_1, __pyx_4); Py_INCREF(__pyx_2); __pyx_4++;
    } else if (likely(PyTuple_CheckExact(__pyx_1))) {
      if (__pyx_4 >= PyTuple_GET_SIZE(__pyx_1)) break;
      __pyx_2 = PyTuple_GET_ITEM(__pyx_1, __pyx_4); Py_INCREF(__pyx_2); __pyx_4++;
    } else {
      __pyx_2 = PyIter_Next(__pyx_1);
      if (!__pyx_2) {
        if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 363; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        break;
      }
    }
    Py_DECREF(__pyx_v_i);
    __pyx_v_i = __pyx_2;
    __pyx_2 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":364
 *         closest = None
 *         for i in range(1,len(self._pts)):
 *             a = self._pts[i-1]             # <<<<<<<<<<<<<<
 *             b = self._pts[i]
 *             c = seg_closest_pt(a, b, p)
 */
    __pyx_t_1 = PyNumber_Subtract(__pyx_v_i, __pyx_int_1); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 364; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyObject_GetItem(__pyx_v_self->_pts, __pyx_t_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 364; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    Py_DECREF(__pyx_v_a);
    __pyx_v_a = __pyx_3;
    __pyx_3 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":365
 *         for i in range(1,len(self._pts)):
 *             a = self._pts[i-1]
 *             b = self._pts[i]             # <<<<<<<<<<<<<<
 *             c = seg_closest_pt(a, b, p)
 *             d = c.distance_pt(p)
 */
    __pyx_2 = PyObject_GetItem(__pyx_v_self->_pts, __pyx_v_i); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 365; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_v_b);
    __pyx_v_b = __pyx_2;
    __pyx_2 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":366
 *             a = self._pts[i-1]
 *             b = self._pts[i]
 *             c = seg_closest_pt(a, b, p)             # <<<<<<<<<<<<<<
 *             d = c.distance_pt(p)
 *             if d == 0:
 */
    if (!(__Pyx_TypeTest(__pyx_v_a, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 366; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(__Pyx_TypeTest(__pyx_v_b, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 366; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = ((PyObject *)__pyx_f_6ligeos_9linearref_seg_closest_pt(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_a), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_b), __pyx_v_p, 0)); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 366; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_v_c);
    __pyx_v_c = __pyx_3;
    __pyx_3 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":367
 *             b = self._pts[i]
 *             c = seg_closest_pt(a, b, p)
 *             d = c.distance_pt(p)             # <<<<<<<<<<<<<<
 *             if d == 0:
 *                 return c
 */
    __pyx_2 = PyObject_GetAttr(__pyx_v_c, __pyx_kp_distance_pt); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 367; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 367; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_INCREF(((PyObject *)__pyx_v_p));
    PyTuple_SET_ITEM(__pyx_3, 0, ((PyObject *)__pyx_v_p));
    __pyx_6 = PyObject_Call(__pyx_2, ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_6)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 367; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
    Py_DECREF(__pyx_v_d);
    __pyx_v_d = __pyx_6;
    __pyx_6 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":368
 *             c = seg_closest_pt(a, b, p)
 *             d = c.distance_pt(p)
 *             if d == 0:             # <<<<<<<<<<<<<<
 *                 return c
 *             if not closest or min_dist > d:
 */
    __pyx_2 = PyObject_RichCompare(__pyx_v_d, __pyx_int_0, Py_EQ); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 368; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_7 = __Pyx_PyObject_IsTrue(__pyx_2); if (unlikely(__pyx_7 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 368; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    if (__pyx_7) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":369
 *             d = c.distance_pt(p)
 *             if d == 0:
 *                 return c             # <<<<<<<<<<<<<<
 *             if not closest or min_dist > d:
 *                 min_dist = d
 */
      if (!(__Pyx_TypeTest(__pyx_v_c, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 369; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(__pyx_v_c);
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_c);
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      goto __pyx_L0;
      goto __pyx_L5;
    }
    __pyx_L5:;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":370
 *             if d == 0:
 *                 return c
 *             if not closest or min_dist > d:             # <<<<<<<<<<<<<<
 *                 min_dist = d
 *                 closest = c
 */
    __pyx_8 = __Pyx_PyObject_IsTrue(__pyx_v_closest); if (unlikely(__pyx_8 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 370; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_7 = (!__pyx_8);
    if (!__pyx_7) {
      __pyx_3 = PyInt_FromLong(__pyx_v_min_dist); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 370; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_6 = PyObject_RichCompare(__pyx_3, __pyx_v_d, Py_GT); if (unlikely(!__pyx_6)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 370; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_7 = __Pyx_PyObject_IsTrue(__pyx_6); if (unlikely(__pyx_7 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 370; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;
    }
    if (__pyx_7) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":371
 *                 return c
 *             if not closest or min_dist > d:
 *                 min_dist = d             # <<<<<<<<<<<<<<
 *                 closest = c
 *         return closest
 */
      __pyx_9 = __pyx_PyInt_int(__pyx_v_d); if (unlikely((__pyx_9 == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 371; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_v_min_dist = __pyx_9;

      /* "/home/nino/ligeos/ligeos/linearref.pyx":372
 *             if not closest or min_dist > d:
 *                 min_dist = d
 *                 closest = c             # <<<<<<<<<<<<<<
 *         return closest
 * 
 */
      Py_INCREF(__pyx_v_c);
      Py_DECREF(__pyx_v_closest);
      __pyx_v_closest = __pyx_v_c;
      goto __pyx_L6;
    }
    __pyx_L6:;
  }
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":373
 *                 min_dist = d
 *                 closest = c
 *         return closest             # <<<<<<<<<<<<<<
 * 
 *     cpdef double distance_pt(self, CPoint p):
 */
  if (!(__Pyx_TypeTest(__pyx_v_closest, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 373; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_closest);
  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_closest);
  goto __pyx_L0;

  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_6);
  __Pyx_AddTraceback("ligeos.linearref.LineString.closest_pt");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_closest);
  Py_DECREF(__pyx_v_i);
  Py_DECREF(__pyx_v_a);
  Py_DECREF(__pyx_v_b);
  Py_DECREF(__pyx_v_c);
  Py_DECREF(__pyx_v_d);
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":359
 *         return sum([self._pts[i-1].distance_pt(self._pts[i]) for i in range(1,len(self._pts))])
 * 
 *     cpdef CPoint closest_pt(self, CPoint p):             # <<<<<<<<<<<<<<
 *         """The nearest point on this linestring to a given point."""
 *         cdef int min_dist = -1
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_closest_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p); /*proto*/
static char __pyx_doc_6ligeos_9linearref_10LineString_closest_pt[] = "The nearest point on this linestring to a given point.";
static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_closest_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_p), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "p", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 359; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = ((PyObject *)((struct __pyx_vtabstruct_6ligeos_9linearref_LineString *)((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->__pyx_vtab)->closest_pt(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_p), 1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 359; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.LineString.closest_pt");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":375
 *         return closest
 * 
 *     cpdef double distance_pt(self, CPoint p):             # <<<<<<<<<<<<<<
 *         """The distance from the nearest point on this linestring to the given point."""
 *         return self.closest_pt(p).distance_pt(p)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_distance_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p); /*proto*/
static  double __pyx_f_6ligeos_9linearref_10LineString_distance_pt(struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_v_self, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p, int __pyx_skip_dispatch) {
  double __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  double __pyx_4;
  /* Check if called by wrapper */
  if (unlikely(__pyx_skip_dispatch)) ;
  /* Check if overriden in Python */
  else if (unlikely(Py_TYPE(((PyObject *)__pyx_v_self))->tp_dictoffset != 0)) {
    __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_distance_pt); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 375; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(strcmp(Py_TYPE(__pyx_1)->tp_name, "builtin_function_or_method") == 0) || (PyCFunction_GET_FUNCTION(__pyx_1) != (void *)&__pyx_pf_6ligeos_9linearref_10LineString_distance_pt)) {
      __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 375; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(((PyObject *)__pyx_v_p));
      PyTuple_SET_ITEM(__pyx_2, 0, ((PyObject *)__pyx_v_p));
      __pyx_3 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 375; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      __pyx_4 = __pyx_PyFloat_AsDouble(__pyx_3); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 375; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_r = __pyx_4;
      goto __pyx_L0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":377
 *     cpdef double distance_pt(self, CPoint p):
 *         """The distance from the nearest point on this linestring to the given point."""
 *         return self.closest_pt(p).distance_pt(p)             # <<<<<<<<<<<<<<
 * 
 *     cpdef CPoint closest_pt_to_line(self, LineString l2):
 */
  __pyx_1 = ((PyObject *)((struct __pyx_vtabstruct_6ligeos_9linearref_LineString *)__pyx_v_self->__pyx_vtab)->closest_pt(__pyx_v_self, __pyx_v_p, 0)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 377; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = ((struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *)((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_1)->__pyx_vtab)->distance_pt(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_1), __pyx_v_p, 0);
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_WriteUnraisable("ligeos.linearref.LineString.distance_pt");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":375
 *         return closest
 * 
 *     cpdef double distance_pt(self, CPoint p):             # <<<<<<<<<<<<<<
 *         """The distance from the nearest point on this linestring to the given point."""
 *         return self.closest_pt(p).distance_pt(p)
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_distance_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p); /*proto*/
static char __pyx_doc_6ligeos_9linearref_10LineString_distance_pt[] = "The distance from the nearest point on this linestring to the given point.";
static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_distance_pt(PyObject *__pyx_v_self, PyObject *__pyx_v_p) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_p), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "p", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 375; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_vtabstruct_6ligeos_9linearref_LineString *)((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->__pyx_vtab)->distance_pt(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_p), 1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 375; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.LineString.distance_pt");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":379
 *         return self.closest_pt(p).distance_pt(p)
 * 
 *     cpdef CPoint closest_pt_to_line(self, LineString l2):             # <<<<<<<<<<<<<<
 *         """The distance from this line to another."""
 *         cdef int min_dist = -1
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_closest_pt_to_line(PyObject *__pyx_v_self, PyObject *__pyx_v_l2); /*proto*/
static  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_f_6ligeos_9linearref_10LineString_closest_pt_to_line(struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_v_self, struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_v_l2, int __pyx_skip_dispatch) {
  int __pyx_v_min_dist;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_closest = 0;
  double __pyx_v_closest_u;
  double __pyx_v_closest_v;
  PyObject *__pyx_v_i;
  PyObject *__pyx_v_a;
  PyObject *__pyx_v_b;
  PyObject *__pyx_v_j;
  PyObject *__pyx_v_u;
  PyObject *__pyx_v_v;
  PyObject *__pyx_v_d;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_ssize_t __pyx_4 = 0;
  Py_ssize_t __pyx_5 = 0;
  Py_ssize_t __pyx_6 = 0;
  int __pyx_7;
  int __pyx_8;
  PyObject *__pyx_9 = 0;
  int __pyx_10;
  PyObject *__pyx_t_1 = NULL;
  __pyx_v_i = Py_None; Py_INCREF(Py_None);
  __pyx_v_a = Py_None; Py_INCREF(Py_None);
  __pyx_v_b = Py_None; Py_INCREF(Py_None);
  __pyx_v_j = Py_None; Py_INCREF(Py_None);
  __pyx_v_u = Py_None; Py_INCREF(Py_None);
  __pyx_v_v = Py_None; Py_INCREF(Py_None);
  __pyx_v_d = Py_None; Py_INCREF(Py_None);
  /* Check if called by wrapper */
  if (unlikely(__pyx_skip_dispatch)) ;
  /* Check if overriden in Python */
  else if (unlikely(Py_TYPE(((PyObject *)__pyx_v_self))->tp_dictoffset != 0)) {
    __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_closest_pt_to_line); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 379; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(strcmp(Py_TYPE(__pyx_1)->tp_name, "builtin_function_or_method") == 0) || (PyCFunction_GET_FUNCTION(__pyx_1) != (void *)&__pyx_pf_6ligeos_9linearref_10LineString_closest_pt_to_line)) {
      __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 379; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(((PyObject *)__pyx_v_l2));
      PyTuple_SET_ITEM(__pyx_2, 0, ((PyObject *)__pyx_v_l2));
      __pyx_3 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 379; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      if (!(__Pyx_TypeTest(__pyx_3, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 379; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3);
      __pyx_3 = 0;
      goto __pyx_L0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":381
 *     cpdef CPoint closest_pt_to_line(self, LineString l2):
 *         """The distance from this line to another."""
 *         cdef int min_dist = -1             # <<<<<<<<<<<<<<
 *         cdef CPoint closest = None
 *         cdef double closest_u, closest_v
 */
  __pyx_v_min_dist = -1;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":382
 *         """The distance from this line to another."""
 *         cdef int min_dist = -1
 *         cdef CPoint closest = None             # <<<<<<<<<<<<<<
 *         cdef double closest_u, closest_v
 *         for i in range(1,len(self._pts)):
 */
  Py_INCREF(Py_None);
  __pyx_v_closest = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":384
 *         cdef CPoint closest = None
 *         cdef double closest_u, closest_v
 *         for i in range(1,len(self._pts)):             # <<<<<<<<<<<<<<
 *             a = self._pts[i-1]
 *             b = self._pts[i]
 */
  __pyx_5 = PyObject_Length(__pyx_v_self->_pts); if (unlikely(__pyx_5 == -1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 384; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyInt_FromSsize_t(__pyx_5); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 384; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyTuple_New(2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 384; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_int_1);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_int_1);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_1);
  __pyx_1 = 0;
  __pyx_3 = PyObject_Call(__pyx_builtin_range, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 384; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  if (PyList_CheckExact(__pyx_3) || PyTuple_CheckExact(__pyx_3)) {
    __pyx_4 = 0; __pyx_1 = __pyx_3; Py_INCREF(__pyx_1);
  } else {
    __pyx_4 = -1; __pyx_1 = PyObject_GetIter(__pyx_3); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 384; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  }
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  for (;;) {
    if (likely(PyList_CheckExact(__pyx_1))) {
      if (__pyx_4 >= PyList_GET_SIZE(__pyx_1)) break;
      __pyx_2 = PyList_GET_ITEM(__pyx_1, __pyx_4); Py_INCREF(__pyx_2); __pyx_4++;
    } else if (likely(PyTuple_CheckExact(__pyx_1))) {
      if (__pyx_4 >= PyTuple_GET_SIZE(__pyx_1)) break;
      __pyx_2 = PyTuple_GET_ITEM(__pyx_1, __pyx_4); Py_INCREF(__pyx_2); __pyx_4++;
    } else {
      __pyx_2 = PyIter_Next(__pyx_1);
      if (!__pyx_2) {
        if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 384; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        break;
      }
    }
    Py_DECREF(__pyx_v_i);
    __pyx_v_i = __pyx_2;
    __pyx_2 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":385
 *         cdef double closest_u, closest_v
 *         for i in range(1,len(self._pts)):
 *             a = self._pts[i-1]             # <<<<<<<<<<<<<<
 *             b = self._pts[i]
 *             for j in range(1,len(l2._pts)):
 */
    __pyx_t_1 = PyNumber_Subtract(__pyx_v_i, __pyx_int_1); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 385; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyObject_GetItem(__pyx_v_self->_pts, __pyx_t_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 385; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    Py_DECREF(__pyx_v_a);
    __pyx_v_a = __pyx_3;
    __pyx_3 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":386
 *         for i in range(1,len(self._pts)):
 *             a = self._pts[i-1]
 *             b = self._pts[i]             # <<<<<<<<<<<<<<
 *             for j in range(1,len(l2._pts)):
 *                 u = l2._pts[j-1]
 */
    __pyx_2 = PyObject_GetItem(__pyx_v_self->_pts, __pyx_v_i); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 386; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_v_b);
    __pyx_v_b = __pyx_2;
    __pyx_2 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":387
 *             a = self._pts[i-1]
 *             b = self._pts[i]
 *             for j in range(1,len(l2._pts)):             # <<<<<<<<<<<<<<
 *                 u = l2._pts[j-1]
 *                 v = l2._pts[j]
 */
    __pyx_6 = PyObject_Length(__pyx_v_l2->_pts); if (unlikely(__pyx_6 == -1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 387; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyInt_FromSsize_t(__pyx_6); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 387; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_2 = PyTuple_New(2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 387; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_INCREF(__pyx_int_1);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_int_1);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_Call(__pyx_builtin_range, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 387; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
    if (PyList_CheckExact(__pyx_3) || PyTuple_CheckExact(__pyx_3)) {
      __pyx_5 = 0; __pyx_2 = __pyx_3; Py_INCREF(__pyx_2);
    } else {
      __pyx_5 = -1; __pyx_2 = PyObject_GetIter(__pyx_3); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 387; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    }
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    for (;;) {
      if (likely(PyList_CheckExact(__pyx_2))) {
        if (__pyx_5 >= PyList_GET_SIZE(__pyx_2)) break;
        __pyx_3 = PyList_GET_ITEM(__pyx_2, __pyx_5); Py_INCREF(__pyx_3); __pyx_5++;
      } else if (likely(PyTuple_CheckExact(__pyx_2))) {
        if (__pyx_5 >= PyTuple_GET_SIZE(__pyx_2)) break;
        __pyx_3 = PyTuple_GET_ITEM(__pyx_2, __pyx_5); Py_INCREF(__pyx_3); __pyx_5++;
      } else {
        __pyx_3 = PyIter_Next(__pyx_2);
        if (!__pyx_3) {
          if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 387; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
          break;
        }
      }
      Py_DECREF(__pyx_v_j);
      __pyx_v_j = __pyx_3;
      __pyx_3 = 0;

      /* "/home/nino/ligeos/ligeos/linearref.pyx":388
 *             b = self._pts[i]
 *             for j in range(1,len(l2._pts)):
 *                 u = l2._pts[j-1]             # <<<<<<<<<<<<<<
 *                 v = l2._pts[j]
 *                 d = seg_distance_seg(a, b, u, v)
 */
      __pyx_t_1 = PyNumber_Subtract(__pyx_v_j, __pyx_int_1); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 388; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyObject_GetItem(__pyx_v_l2->_pts, __pyx_t_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 388; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
      Py_DECREF(__pyx_v_u);
      __pyx_v_u = __pyx_3;
      __pyx_3 = 0;

      /* "/home/nino/ligeos/ligeos/linearref.pyx":389
 *             for j in range(1,len(l2._pts)):
 *                 u = l2._pts[j-1]
 *                 v = l2._pts[j]             # <<<<<<<<<<<<<<
 *                 d = seg_distance_seg(a, b, u, v)
 *                 if d == 0:
 */
      __pyx_3 = PyObject_GetItem(__pyx_v_l2->_pts, __pyx_v_j); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 389; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_v_v);
      __pyx_v_v = __pyx_3;
      __pyx_3 = 0;

      /* "/home/nino/ligeos/ligeos/linearref.pyx":390
 *                 u = l2._pts[j-1]
 *                 v = l2._pts[j]
 *                 d = seg_distance_seg(a, b, u, v)             # <<<<<<<<<<<<<<
 *                 if d == 0:
 *                     return seg_intersect_seg(a, b, u, v)
 */
      if (!(__Pyx_TypeTest(__pyx_v_a, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 390; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (!(__Pyx_TypeTest(__pyx_v_b, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 390; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (!(__Pyx_TypeTest(__pyx_v_u, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 390; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (!(__Pyx_TypeTest(__pyx_v_v, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 390; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_seg_distance_seg(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_a), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_b), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_u), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_v), 0)); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 390; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_v_d);
      __pyx_v_d = __pyx_3;
      __pyx_3 = 0;

      /* "/home/nino/ligeos/ligeos/linearref.pyx":391
 *                 v = l2._pts[j]
 *                 d = seg_distance_seg(a, b, u, v)
 *                 if d == 0:             # <<<<<<<<<<<<<<
 *                     return seg_intersect_seg(a, b, u, v)
 *                 if min_dist == -1 or min_dist > d:
 */
      __pyx_3 = PyObject_RichCompare(__pyx_v_d, __pyx_int_0, Py_EQ); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 391; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_7 = __Pyx_PyObject_IsTrue(__pyx_3); if (unlikely(__pyx_7 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 391; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      if (__pyx_7) {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":392
 *                 d = seg_distance_seg(a, b, u, v)
 *                 if d == 0:
 *                     return seg_intersect_seg(a, b, u, v)             # <<<<<<<<<<<<<<
 *                 if min_dist == -1 or min_dist > d:
 *                     min_dist = d
 */
        if (!(__Pyx_TypeTest(__pyx_v_a, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 392; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        if (!(__Pyx_TypeTest(__pyx_v_b, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 392; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        if (!(__Pyx_TypeTest(__pyx_v_u, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 392; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        if (!(__Pyx_TypeTest(__pyx_v_v, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 392; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_3 = ((PyObject *)__pyx_f_6ligeos_9linearref_seg_intersect_seg(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_a), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_b), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_u), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_v), 0)); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 392; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3);
        __pyx_3 = 0;
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        goto __pyx_L0;
        goto __pyx_L7;
      }
      __pyx_L7:;

      /* "/home/nino/ligeos/ligeos/linearref.pyx":393
 *                 if d == 0:
 *                     return seg_intersect_seg(a, b, u, v)
 *                 if min_dist == -1 or min_dist > d:             # <<<<<<<<<<<<<<
 *                     min_dist = d
 *                     closest_u = seg_distance_pt(a, b, u)
 */
      __pyx_7 = (__pyx_v_min_dist == -1);
      if (!__pyx_7) {
        __pyx_3 = PyInt_FromLong(__pyx_v_min_dist); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 393; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_9 = PyObject_RichCompare(__pyx_3, __pyx_v_d, Py_GT); if (unlikely(!__pyx_9)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 393; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_7 = __Pyx_PyObject_IsTrue(__pyx_9); if (unlikely(__pyx_7 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 393; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_9); __pyx_9 = 0;
      }
      if (__pyx_7) {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":394
 *                     return seg_intersect_seg(a, b, u, v)
 *                 if min_dist == -1 or min_dist > d:
 *                     min_dist = d             # <<<<<<<<<<<<<<
 *                     closest_u = seg_distance_pt(a, b, u)
 *                     closest_v = seg_distance_pt(a, b, v)
 */
        __pyx_10 = __pyx_PyInt_int(__pyx_v_d); if (unlikely((__pyx_10 == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 394; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_v_min_dist = __pyx_10;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":395
 *                 if min_dist == -1 or min_dist > d:
 *                     min_dist = d
 *                     closest_u = seg_distance_pt(a, b, u)             # <<<<<<<<<<<<<<
 *                     closest_v = seg_distance_pt(a, b, v)
 *                     if seg_distance_pt(a, b, u) < seg_distance_pt(a, b, v):
 */
        if (!(__Pyx_TypeTest(__pyx_v_a, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 395; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        if (!(__Pyx_TypeTest(__pyx_v_b, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 395; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        if (!(__Pyx_TypeTest(__pyx_v_u, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 395; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_v_closest_u = __pyx_f_6ligeos_9linearref_seg_distance_pt(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_a), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_b), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_u), 0);

        /* "/home/nino/ligeos/ligeos/linearref.pyx":396
 *                     min_dist = d
 *                     closest_u = seg_distance_pt(a, b, u)
 *                     closest_v = seg_distance_pt(a, b, v)             # <<<<<<<<<<<<<<
 *                     if seg_distance_pt(a, b, u) < seg_distance_pt(a, b, v):
 *                         closest = seg_closest_pt(a, b, u)
 */
        if (!(__Pyx_TypeTest(__pyx_v_a, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 396; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        if (!(__Pyx_TypeTest(__pyx_v_b, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 396; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        if (!(__Pyx_TypeTest(__pyx_v_v, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 396; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_v_closest_v = __pyx_f_6ligeos_9linearref_seg_distance_pt(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_a), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_b), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_v), 0);

        /* "/home/nino/ligeos/ligeos/linearref.pyx":397
 *                     closest_u = seg_distance_pt(a, b, u)
 *                     closest_v = seg_distance_pt(a, b, v)
 *                     if seg_distance_pt(a, b, u) < seg_distance_pt(a, b, v):             # <<<<<<<<<<<<<<
 *                         closest = seg_closest_pt(a, b, u)
 *                     else:
 */
        if (!(__Pyx_TypeTest(__pyx_v_a, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 397; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        if (!(__Pyx_TypeTest(__pyx_v_b, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 397; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        if (!(__Pyx_TypeTest(__pyx_v_u, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 397; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        if (!(__Pyx_TypeTest(__pyx_v_a, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 397; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        if (!(__Pyx_TypeTest(__pyx_v_b, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 397; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        if (!(__Pyx_TypeTest(__pyx_v_v, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 397; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_8 = (__pyx_f_6ligeos_9linearref_seg_distance_pt(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_a), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_b), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_u), 0) < __pyx_f_6ligeos_9linearref_seg_distance_pt(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_a), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_b), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_v), 0));
        if (__pyx_8) {

          /* "/home/nino/ligeos/ligeos/linearref.pyx":398
 *                     closest_v = seg_distance_pt(a, b, v)
 *                     if seg_distance_pt(a, b, u) < seg_distance_pt(a, b, v):
 *                         closest = seg_closest_pt(a, b, u)             # <<<<<<<<<<<<<<
 *                     else:
 *                         closest = seg_closest_pt(a, b, v)
 */
          if (!(__Pyx_TypeTest(__pyx_v_a, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 398; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
          if (!(__Pyx_TypeTest(__pyx_v_b, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 398; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
          if (!(__Pyx_TypeTest(__pyx_v_u, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 398; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
          __pyx_3 = ((PyObject *)__pyx_f_6ligeos_9linearref_seg_closest_pt(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_a), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_b), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_u), 0)); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 398; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
          Py_DECREF(((PyObject *)__pyx_v_closest));
          __pyx_v_closest = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3);
          __pyx_3 = 0;
          goto __pyx_L9;
        }
        /*else*/ {

          /* "/home/nino/ligeos/ligeos/linearref.pyx":400
 *                         closest = seg_closest_pt(a, b, u)
 *                     else:
 *                         closest = seg_closest_pt(a, b, v)             # <<<<<<<<<<<<<<
 *         return closest
 * 
 */
          if (!(__Pyx_TypeTest(__pyx_v_a, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
          if (!(__Pyx_TypeTest(__pyx_v_b, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
          if (!(__Pyx_TypeTest(__pyx_v_v, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
          __pyx_9 = ((PyObject *)__pyx_f_6ligeos_9linearref_seg_closest_pt(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_a), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_b), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_v), 0)); if (unlikely(!__pyx_9)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
          Py_DECREF(((PyObject *)__pyx_v_closest));
          __pyx_v_closest = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_9);
          __pyx_9 = 0;
        }
        __pyx_L9:;
        goto __pyx_L8;
      }
      __pyx_L8:;
    }
    Py_DECREF(__pyx_2); __pyx_2 = 0;
  }
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":401
 *                     else:
 *                         closest = seg_closest_pt(a, b, v)
 *         return closest             # <<<<<<<<<<<<<<
 * 
 *     cpdef double distance_to_line(self, LineString l2):
 */
  Py_INCREF(((PyObject *)__pyx_v_closest));
  __pyx_r = __pyx_v_closest;
  goto __pyx_L0;

  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_9);
  __Pyx_AddTraceback("ligeos.linearref.LineString.closest_pt_to_line");
  __pyx_r = 0;
  __pyx_L0:;
  Py_XDECREF(__pyx_v_closest);
  Py_DECREF(__pyx_v_i);
  Py_DECREF(__pyx_v_a);
  Py_DECREF(__pyx_v_b);
  Py_DECREF(__pyx_v_j);
  Py_DECREF(__pyx_v_u);
  Py_DECREF(__pyx_v_v);
  Py_DECREF(__pyx_v_d);
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":379
 *         return self.closest_pt(p).distance_pt(p)
 * 
 *     cpdef CPoint closest_pt_to_line(self, LineString l2):             # <<<<<<<<<<<<<<
 *         """The distance from this line to another."""
 *         cdef int min_dist = -1
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_closest_pt_to_line(PyObject *__pyx_v_self, PyObject *__pyx_v_l2); /*proto*/
static char __pyx_doc_6ligeos_9linearref_10LineString_closest_pt_to_line[] = "The distance from this line to another.";
static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_closest_pt_to_line(PyObject *__pyx_v_self, PyObject *__pyx_v_l2) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_l2), __pyx_ptype_6ligeos_9linearref_LineString, 1, "l2", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 379; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = ((PyObject *)((struct __pyx_vtabstruct_6ligeos_9linearref_LineString *)((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->__pyx_vtab)->closest_pt_to_line(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self), ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_l2), 1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 379; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.LineString.closest_pt_to_line");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":403
 *         return closest
 * 
 *     cpdef double distance_to_line(self, LineString l2):             # <<<<<<<<<<<<<<
 *         """The distance from this line to another."""
 *         cdef int min_dist = -1
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_distance_to_line(PyObject *__pyx_v_self, PyObject *__pyx_v_l2); /*proto*/
static  double __pyx_f_6ligeos_9linearref_10LineString_distance_to_line(struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_v_self, struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_v_l2, int __pyx_skip_dispatch) {
  int __pyx_v_min_dist;
  PyObject *__pyx_v_i;
  PyObject *__pyx_v_a;
  PyObject *__pyx_v_b;
  PyObject *__pyx_v_j;
  PyObject *__pyx_v_u;
  PyObject *__pyx_v_v;
  PyObject *__pyx_v_d;
  double __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  double __pyx_4;
  Py_ssize_t __pyx_5 = 0;
  Py_ssize_t __pyx_6 = 0;
  Py_ssize_t __pyx_7 = 0;
  int __pyx_8;
  int __pyx_9;
  PyObject *__pyx_10 = 0;
  int __pyx_11;
  PyObject *__pyx_t_1 = NULL;
  __pyx_v_i = Py_None; Py_INCREF(Py_None);
  __pyx_v_a = Py_None; Py_INCREF(Py_None);
  __pyx_v_b = Py_None; Py_INCREF(Py_None);
  __pyx_v_j = Py_None; Py_INCREF(Py_None);
  __pyx_v_u = Py_None; Py_INCREF(Py_None);
  __pyx_v_v = Py_None; Py_INCREF(Py_None);
  __pyx_v_d = Py_None; Py_INCREF(Py_None);
  /* Check if called by wrapper */
  if (unlikely(__pyx_skip_dispatch)) ;
  /* Check if overriden in Python */
  else if (unlikely(Py_TYPE(((PyObject *)__pyx_v_self))->tp_dictoffset != 0)) {
    __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_distance_to_line); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(strcmp(Py_TYPE(__pyx_1)->tp_name, "builtin_function_or_method") == 0) || (PyCFunction_GET_FUNCTION(__pyx_1) != (void *)&__pyx_pf_6ligeos_9linearref_10LineString_distance_to_line)) {
      __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(((PyObject *)__pyx_v_l2));
      PyTuple_SET_ITEM(__pyx_2, 0, ((PyObject *)__pyx_v_l2));
      __pyx_3 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      __pyx_4 = __pyx_PyFloat_AsDouble(__pyx_3); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_r = __pyx_4;
      goto __pyx_L0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":405
 *     cpdef double distance_to_line(self, LineString l2):
 *         """The distance from this line to another."""
 *         cdef int min_dist = -1             # <<<<<<<<<<<<<<
 *         for i in range(1,len(self._pts)):
 *             a = self._pts[i-1]
 */
  __pyx_v_min_dist = -1;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":406
 *         """The distance from this line to another."""
 *         cdef int min_dist = -1
 *         for i in range(1,len(self._pts)):             # <<<<<<<<<<<<<<
 *             a = self._pts[i-1]
 *             b = self._pts[i]
 */
  __pyx_6 = PyObject_Length(__pyx_v_self->_pts); if (unlikely(__pyx_6 == -1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 406; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyInt_FromSsize_t(__pyx_6); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 406; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyTuple_New(2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 406; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_int_1);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_int_1);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_1);
  __pyx_1 = 0;
  __pyx_3 = PyObject_Call(__pyx_builtin_range, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 406; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  if (PyList_CheckExact(__pyx_3) || PyTuple_CheckExact(__pyx_3)) {
    __pyx_5 = 0; __pyx_1 = __pyx_3; Py_INCREF(__pyx_1);
  } else {
    __pyx_5 = -1; __pyx_1 = PyObject_GetIter(__pyx_3); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 406; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  }
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  for (;;) {
    if (likely(PyList_CheckExact(__pyx_1))) {
      if (__pyx_5 >= PyList_GET_SIZE(__pyx_1)) break;
      __pyx_2 = PyList_GET_ITEM(__pyx_1, __pyx_5); Py_INCREF(__pyx_2); __pyx_5++;
    } else if (likely(PyTuple_CheckExact(__pyx_1))) {
      if (__pyx_5 >= PyTuple_GET_SIZE(__pyx_1)) break;
      __pyx_2 = PyTuple_GET_ITEM(__pyx_1, __pyx_5); Py_INCREF(__pyx_2); __pyx_5++;
    } else {
      __pyx_2 = PyIter_Next(__pyx_1);
      if (!__pyx_2) {
        if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 406; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        break;
      }
    }
    Py_DECREF(__pyx_v_i);
    __pyx_v_i = __pyx_2;
    __pyx_2 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":407
 *         cdef int min_dist = -1
 *         for i in range(1,len(self._pts)):
 *             a = self._pts[i-1]             # <<<<<<<<<<<<<<
 *             b = self._pts[i]
 *             for j in range(1,len(l2._pts)):
 */
    __pyx_t_1 = PyNumber_Subtract(__pyx_v_i, __pyx_int_1); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 407; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyObject_GetItem(__pyx_v_self->_pts, __pyx_t_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 407; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    Py_DECREF(__pyx_v_a);
    __pyx_v_a = __pyx_3;
    __pyx_3 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":408
 *         for i in range(1,len(self._pts)):
 *             a = self._pts[i-1]
 *             b = self._pts[i]             # <<<<<<<<<<<<<<
 *             for j in range(1,len(l2._pts)):
 *                 u = l2._pts[j-1]
 */
    __pyx_2 = PyObject_GetItem(__pyx_v_self->_pts, __pyx_v_i); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 408; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_v_b);
    __pyx_v_b = __pyx_2;
    __pyx_2 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":409
 *             a = self._pts[i-1]
 *             b = self._pts[i]
 *             for j in range(1,len(l2._pts)):             # <<<<<<<<<<<<<<
 *                 u = l2._pts[j-1]
 *                 v = l2._pts[j]
 */
    __pyx_7 = PyObject_Length(__pyx_v_l2->_pts); if (unlikely(__pyx_7 == -1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 409; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyInt_FromSsize_t(__pyx_7); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 409; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_2 = PyTuple_New(2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 409; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_INCREF(__pyx_int_1);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_int_1);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_Call(__pyx_builtin_range, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 409; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
    if (PyList_CheckExact(__pyx_3) || PyTuple_CheckExact(__pyx_3)) {
      __pyx_6 = 0; __pyx_2 = __pyx_3; Py_INCREF(__pyx_2);
    } else {
      __pyx_6 = -1; __pyx_2 = PyObject_GetIter(__pyx_3); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 409; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    }
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    for (;;) {
      if (likely(PyList_CheckExact(__pyx_2))) {
        if (__pyx_6 >= PyList_GET_SIZE(__pyx_2)) break;
        __pyx_3 = PyList_GET_ITEM(__pyx_2, __pyx_6); Py_INCREF(__pyx_3); __pyx_6++;
      } else if (likely(PyTuple_CheckExact(__pyx_2))) {
        if (__pyx_6 >= PyTuple_GET_SIZE(__pyx_2)) break;
        __pyx_3 = PyTuple_GET_ITEM(__pyx_2, __pyx_6); Py_INCREF(__pyx_3); __pyx_6++;
      } else {
        __pyx_3 = PyIter_Next(__pyx_2);
        if (!__pyx_3) {
          if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 409; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
          break;
        }
      }
      Py_DECREF(__pyx_v_j);
      __pyx_v_j = __pyx_3;
      __pyx_3 = 0;

      /* "/home/nino/ligeos/ligeos/linearref.pyx":410
 *             b = self._pts[i]
 *             for j in range(1,len(l2._pts)):
 *                 u = l2._pts[j-1]             # <<<<<<<<<<<<<<
 *                 v = l2._pts[j]
 *                 d = seg_distance_seg(a, b, u, v)
 */
      __pyx_t_1 = PyNumber_Subtract(__pyx_v_j, __pyx_int_1); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 410; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyObject_GetItem(__pyx_v_l2->_pts, __pyx_t_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 410; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
      Py_DECREF(__pyx_v_u);
      __pyx_v_u = __pyx_3;
      __pyx_3 = 0;

      /* "/home/nino/ligeos/ligeos/linearref.pyx":411
 *             for j in range(1,len(l2._pts)):
 *                 u = l2._pts[j-1]
 *                 v = l2._pts[j]             # <<<<<<<<<<<<<<
 *                 d = seg_distance_seg(a, b, u, v)
 *                 #print "SDS",d
 */
      __pyx_3 = PyObject_GetItem(__pyx_v_l2->_pts, __pyx_v_j); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 411; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_v_v);
      __pyx_v_v = __pyx_3;
      __pyx_3 = 0;

      /* "/home/nino/ligeos/ligeos/linearref.pyx":412
 *                 u = l2._pts[j-1]
 *                 v = l2._pts[j]
 *                 d = seg_distance_seg(a, b, u, v)             # <<<<<<<<<<<<<<
 *                 #print "SDS",d
 *                 if d == 0:
 */
      if (!(__Pyx_TypeTest(__pyx_v_a, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (!(__Pyx_TypeTest(__pyx_v_b, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (!(__Pyx_TypeTest(__pyx_v_u, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (!(__Pyx_TypeTest(__pyx_v_v, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyFloat_FromDouble(__pyx_f_6ligeos_9linearref_seg_distance_seg(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_a), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_b), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_u), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_v), 0)); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_v_d);
      __pyx_v_d = __pyx_3;
      __pyx_3 = 0;

      /* "/home/nino/ligeos/ligeos/linearref.pyx":414
 *                 d = seg_distance_seg(a, b, u, v)
 *                 #print "SDS",d
 *                 if d == 0:             # <<<<<<<<<<<<<<
 *                     return 0
 *                 if min_dist == -1 or min_dist > d:
 */
      __pyx_3 = PyObject_RichCompare(__pyx_v_d, __pyx_int_0, Py_EQ); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 414; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_8 = __Pyx_PyObject_IsTrue(__pyx_3); if (unlikely(__pyx_8 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 414; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      if (__pyx_8) {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":415
 *                 #print "SDS",d
 *                 if d == 0:
 *                     return 0             # <<<<<<<<<<<<<<
 *                 if min_dist == -1 or min_dist > d:
 *                     min_dist = d
 */
        __pyx_r = 0;
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        goto __pyx_L0;
        goto __pyx_L7;
      }
      __pyx_L7:;

      /* "/home/nino/ligeos/ligeos/linearref.pyx":416
 *                 if d == 0:
 *                     return 0
 *                 if min_dist == -1 or min_dist > d:             # <<<<<<<<<<<<<<
 *                     min_dist = d
 *         return d
 */
      __pyx_8 = (__pyx_v_min_dist == -1);
      if (!__pyx_8) {
        __pyx_3 = PyInt_FromLong(__pyx_v_min_dist); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 416; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_10 = PyObject_RichCompare(__pyx_3, __pyx_v_d, Py_GT); if (unlikely(!__pyx_10)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 416; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_8 = __Pyx_PyObject_IsTrue(__pyx_10); if (unlikely(__pyx_8 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 416; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_10); __pyx_10 = 0;
      }
      if (__pyx_8) {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":417
 *                     return 0
 *                 if min_dist == -1 or min_dist > d:
 *                     min_dist = d             # <<<<<<<<<<<<<<
 *         return d
 * 
 */
        __pyx_11 = __pyx_PyInt_int(__pyx_v_d); if (unlikely((__pyx_11 == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 417; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_v_min_dist = __pyx_11;
        goto __pyx_L8;
      }
      __pyx_L8:;
    }
    Py_DECREF(__pyx_2); __pyx_2 = 0;
  }
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":418
 *                 if min_dist == -1 or min_dist > d:
 *                     min_dist = d
 *         return d             # <<<<<<<<<<<<<<
 * 
 * 
 */
  __pyx_4 = __pyx_PyFloat_AsDouble(__pyx_v_d); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 418; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_4;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_10);
  __Pyx_WriteUnraisable("ligeos.linearref.LineString.distance_to_line");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_i);
  Py_DECREF(__pyx_v_a);
  Py_DECREF(__pyx_v_b);
  Py_DECREF(__pyx_v_j);
  Py_DECREF(__pyx_v_u);
  Py_DECREF(__pyx_v_v);
  Py_DECREF(__pyx_v_d);
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":403
 *         return closest
 * 
 *     cpdef double distance_to_line(self, LineString l2):             # <<<<<<<<<<<<<<
 *         """The distance from this line to another."""
 *         cdef int min_dist = -1
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_distance_to_line(PyObject *__pyx_v_self, PyObject *__pyx_v_l2); /*proto*/
static char __pyx_doc_6ligeos_9linearref_10LineString_distance_to_line[] = "The distance from this line to another.";
static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_distance_to_line(PyObject *__pyx_v_self, PyObject *__pyx_v_l2) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_l2), __pyx_ptype_6ligeos_9linearref_LineString, 1, "l2", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_vtabstruct_6ligeos_9linearref_LineString *)((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->__pyx_vtab)->distance_to_line(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self), ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_l2), 1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.LineString.distance_to_line");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":421
 * 
 * 
 *     cpdef double locate_point(self, CPoint p):             # <<<<<<<<<<<<<<
 *         """Find the measure [0,1] on this linestring to which the given point falls nearest."""
 *         cdef CPoint nearest = None
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_locate_point(PyObject *__pyx_v_self, PyObject *__pyx_v_p); /*proto*/
static  double __pyx_f_6ligeos_9linearref_10LineString_locate_point(struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_v_self, struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p, int __pyx_skip_dispatch) {
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_nearest = 0;
  double __pyx_v_mindist;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_start = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_end = 0;
  int __pyx_v_seg;
  double __pyx_v_dist;
  PyObject *__pyx_v_i;
  double __pyx_v_tlen;
  double __pyx_v_plen;
  double __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  double __pyx_4;
  Py_ssize_t __pyx_5 = 0;
  Py_ssize_t __pyx_6 = 0;
  int __pyx_7;
  int __pyx_8;
  int __pyx_9;
  long __pyx_10;
  PyObject *__pyx_t_1 = NULL;
  __pyx_v_i = Py_None; Py_INCREF(Py_None);
  /* Check if called by wrapper */
  if (unlikely(__pyx_skip_dispatch)) ;
  /* Check if overriden in Python */
  else if (unlikely(Py_TYPE(((PyObject *)__pyx_v_self))->tp_dictoffset != 0)) {
    __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_locate_point); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 421; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(strcmp(Py_TYPE(__pyx_1)->tp_name, "builtin_function_or_method") == 0) || (PyCFunction_GET_FUNCTION(__pyx_1) != (void *)&__pyx_pf_6ligeos_9linearref_10LineString_locate_point)) {
      __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 421; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(((PyObject *)__pyx_v_p));
      PyTuple_SET_ITEM(__pyx_2, 0, ((PyObject *)__pyx_v_p));
      __pyx_3 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 421; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      __pyx_4 = __pyx_PyFloat_AsDouble(__pyx_3); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 421; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_r = __pyx_4;
      goto __pyx_L0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":423
 *     cpdef double locate_point(self, CPoint p):
 *         """Find the measure [0,1] on this linestring to which the given point falls nearest."""
 *         cdef CPoint nearest = None             # <<<<<<<<<<<<<<
 *         cdef double mindist = -1 # min dist found
 *         cdef CPoint start = None # current
 */
  Py_INCREF(Py_None);
  __pyx_v_nearest = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":424
 *         """Find the measure [0,1] on this linestring to which the given point falls nearest."""
 *         cdef CPoint nearest = None
 *         cdef double mindist = -1 # min dist found             # <<<<<<<<<<<<<<
 *         cdef CPoint start = None # current
 *         cdef CPoint end = None # current + 1
 */
  __pyx_v_mindist = -1;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":425
 *         cdef CPoint nearest = None
 *         cdef double mindist = -1 # min dist found
 *         cdef CPoint start = None # current             # <<<<<<<<<<<<<<
 *         cdef CPoint end = None # current + 1
 *         cdef int seg = -1 # closest segment index
 */
  Py_INCREF(Py_None);
  __pyx_v_start = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":426
 *         cdef double mindist = -1 # min dist found
 *         cdef CPoint start = None # current
 *         cdef CPoint end = None # current + 1             # <<<<<<<<<<<<<<
 *         cdef int seg = -1 # closest segment index
 *         cdef double dist
 */
  Py_INCREF(Py_None);
  __pyx_v_end = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":427
 *         cdef CPoint start = None # current
 *         cdef CPoint end = None # current + 1
 *         cdef int seg = -1 # closest segment index             # <<<<<<<<<<<<<<
 *         cdef double dist
 * 
 */
  __pyx_v_seg = -1;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":430
 *         cdef double dist
 * 
 *         start = self._pts[0]             # <<<<<<<<<<<<<<
 *         for i in range(1, len(self)):
 *             end = self._pts[i]
 */
  __pyx_1 = __Pyx_GetItemInt(__pyx_v_self->_pts, 0, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 430; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (!(__Pyx_TypeTest(__pyx_1, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 430; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_v_start));
  __pyx_v_start = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_1);
  __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":431
 * 
 *         start = self._pts[0]
 *         for i in range(1, len(self)):             # <<<<<<<<<<<<<<
 *             end = self._pts[i]
 *             dist = seg_distance_pt(start, end, p)
 */
  __pyx_6 = PyObject_Length(((PyObject *)__pyx_v_self)); if (unlikely(__pyx_6 == -1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 431; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyInt_FromSsize_t(__pyx_6); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 431; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyTuple_New(2); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 431; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_int_1);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_int_1);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_2);
  __pyx_2 = 0;
  __pyx_1 = PyObject_Call(__pyx_builtin_range, ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 431; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
  if (PyList_CheckExact(__pyx_1) || PyTuple_CheckExact(__pyx_1)) {
    __pyx_5 = 0; __pyx_2 = __pyx_1; Py_INCREF(__pyx_2);
  } else {
    __pyx_5 = -1; __pyx_2 = PyObject_GetIter(__pyx_1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 431; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  }
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  for (;;) {
    if (likely(PyList_CheckExact(__pyx_2))) {
      if (__pyx_5 >= PyList_GET_SIZE(__pyx_2)) break;
      __pyx_3 = PyList_GET_ITEM(__pyx_2, __pyx_5); Py_INCREF(__pyx_3); __pyx_5++;
    } else if (likely(PyTuple_CheckExact(__pyx_2))) {
      if (__pyx_5 >= PyTuple_GET_SIZE(__pyx_2)) break;
      __pyx_3 = PyTuple_GET_ITEM(__pyx_2, __pyx_5); Py_INCREF(__pyx_3); __pyx_5++;
    } else {
      __pyx_3 = PyIter_Next(__pyx_2);
      if (!__pyx_3) {
        if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 431; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        break;
      }
    }
    Py_DECREF(__pyx_v_i);
    __pyx_v_i = __pyx_3;
    __pyx_3 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":432
 *         start = self._pts[0]
 *         for i in range(1, len(self)):
 *             end = self._pts[i]             # <<<<<<<<<<<<<<
 *             dist = seg_distance_pt(start, end, p)
 *             if i == 1 or dist < mindist:
 */
    __pyx_1 = PyObject_GetItem(__pyx_v_self->_pts, __pyx_v_i); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 432; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(__Pyx_TypeTest(__pyx_1, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 432; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_v_end));
    __pyx_v_end = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_1);
    __pyx_1 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":433
 *         for i in range(1, len(self)):
 *             end = self._pts[i]
 *             dist = seg_distance_pt(start, end, p)             # <<<<<<<<<<<<<<
 *             if i == 1 or dist < mindist:
 *                 mindist = dist
 */
    __pyx_v_dist = __pyx_f_6ligeos_9linearref_seg_distance_pt(__pyx_v_start, __pyx_v_end, __pyx_v_p, 0);

    /* "/home/nino/ligeos/ligeos/linearref.pyx":434
 *             end = self._pts[i]
 *             dist = seg_distance_pt(start, end, p)
 *             if i == 1 or dist < mindist:             # <<<<<<<<<<<<<<
 *                 mindist = dist
 *                 seg = i-1
 */
    __pyx_3 = PyObject_RichCompare(__pyx_v_i, __pyx_int_1, Py_EQ); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 434; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_7 = __Pyx_PyObject_IsTrue(__pyx_3); if (unlikely(__pyx_7 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 434; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    if (!__pyx_7) {
      __pyx_7 = (__pyx_v_dist < __pyx_v_mindist);
    }
    if (__pyx_7) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":435
 *             dist = seg_distance_pt(start, end, p)
 *             if i == 1 or dist < mindist:
 *                 mindist = dist             # <<<<<<<<<<<<<<
 *                 seg = i-1
 *             if mindist <= 0.0:
 */
      __pyx_v_mindist = __pyx_v_dist;

      /* "/home/nino/ligeos/ligeos/linearref.pyx":436
 *             if i == 1 or dist < mindist:
 *                 mindist = dist
 *                 seg = i-1             # <<<<<<<<<<<<<<
 *             if mindist <= 0.0:
 *                 break
 */
      __pyx_t_1 = PyNumber_Subtract(__pyx_v_i, __pyx_int_1); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 436; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_9 = __pyx_PyInt_int(__pyx_t_1); if (unlikely((__pyx_9 == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 436; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
      __pyx_v_seg = __pyx_9;
      goto __pyx_L5;
    }
    __pyx_L5:;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":437
 *                 mindist = dist
 *                 seg = i-1
 *             if mindist <= 0.0:             # <<<<<<<<<<<<<<
 *                 break
 * 
 */
    __pyx_8 = (__pyx_v_mindist <= 0.0);
    if (__pyx_8) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":438
 *                 seg = i-1
 *             if mindist <= 0.0:
 *                 break             # <<<<<<<<<<<<<<
 * 
 *             start = end
 */
      goto __pyx_L4;
      goto __pyx_L6;
    }
    __pyx_L6:;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":440
 *                 break
 * 
 *             start = end             # <<<<<<<<<<<<<<
 *         if mindist > 0:
 *             nearest = seg_closest_pt(self._pts[seg], self._pts[seg+1], p)
 */
    Py_INCREF(((PyObject *)__pyx_v_end));
    Py_DECREF(((PyObject *)__pyx_v_start));
    __pyx_v_start = __pyx_v_end;
  }
  __pyx_L4:;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":441
 * 
 *             start = end
 *         if mindist > 0:             # <<<<<<<<<<<<<<
 *             nearest = seg_closest_pt(self._pts[seg], self._pts[seg+1], p)
 *         else:
 */
  __pyx_7 = (__pyx_v_mindist > 0);
  if (__pyx_7) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":442
 *             start = end
 *         if mindist > 0:
 *             nearest = seg_closest_pt(self._pts[seg], self._pts[seg+1], p)             # <<<<<<<<<<<<<<
 *         else:
 *             nearest = p
 */
    __pyx_1 = __Pyx_GetItemInt(__pyx_v_self->_pts, __pyx_v_seg, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 442; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(__Pyx_TypeTest(__pyx_1, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 442; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_10 = (__pyx_v_seg + 1);
    __pyx_3 = __Pyx_GetItemInt(__pyx_v_self->_pts, __pyx_10, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 442; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(__Pyx_TypeTest(__pyx_3, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 442; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_2 = ((PyObject *)__pyx_f_6ligeos_9linearref_seg_closest_pt(((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_1), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3), __pyx_v_p, 0)); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 442; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(((PyObject *)__pyx_v_nearest));
    __pyx_v_nearest = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_2);
    __pyx_2 = 0;
    goto __pyx_L7;
  }
  /*else*/ {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":444
 *             nearest = seg_closest_pt(self._pts[seg], self._pts[seg+1], p)
 *         else:
 *             nearest = p             # <<<<<<<<<<<<<<
 * 
 *         #print "Min dist", mindist, nearest, seg_closest_pt(self._pts[seg+1], self._pts[seg+2], p)
 */
    Py_INCREF(((PyObject *)__pyx_v_p));
    Py_DECREF(((PyObject *)__pyx_v_nearest));
    __pyx_v_nearest = __pyx_v_p;
  }
  __pyx_L7:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":449
 * 
 * 
 *         cdef double tlen = self.length() # total length             # <<<<<<<<<<<<<<
 *         cdef double plen = 0 # length so far
 * 
 */
  __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_length); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 449; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 449; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_4 = __pyx_PyFloat_AsDouble(__pyx_3); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 449; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_v_tlen = __pyx_4;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":450
 * 
 *         cdef double tlen = self.length() # total length
 *         cdef double plen = 0 # length so far             # <<<<<<<<<<<<<<
 * 
 *         start = self._pts[0]
 */
  __pyx_v_plen = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":452
 *         cdef double plen = 0 # length so far
 * 
 *         start = self._pts[0]             # <<<<<<<<<<<<<<
 *         for i in range(0, seg):
 *             end = self._pts[i+1]
 */
  __pyx_2 = __Pyx_GetItemInt(__pyx_v_self->_pts, 0, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 452; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (!(__Pyx_TypeTest(__pyx_2, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 452; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_v_start));
  __pyx_v_start = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_2);
  __pyx_2 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":453
 * 
 *         start = self._pts[0]
 *         for i in range(0, seg):             # <<<<<<<<<<<<<<
 *             end = self._pts[i+1]
 *             plen = plen + start.distance_pt(end)
 */
  __pyx_1 = PyInt_FromLong(__pyx_v_seg); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 453; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyTuple_New(2); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 453; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_int_0);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_int_0);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_1);
  __pyx_1 = 0;
  __pyx_2 = PyObject_Call(__pyx_builtin_range, ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 453; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
  if (PyList_CheckExact(__pyx_2) || PyTuple_CheckExact(__pyx_2)) {
    __pyx_6 = 0; __pyx_1 = __pyx_2; Py_INCREF(__pyx_1);
  } else {
    __pyx_6 = -1; __pyx_1 = PyObject_GetIter(__pyx_2); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 453; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  }
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  for (;;) {
    if (likely(PyList_CheckExact(__pyx_1))) {
      if (__pyx_6 >= PyList_GET_SIZE(__pyx_1)) break;
      __pyx_3 = PyList_GET_ITEM(__pyx_1, __pyx_6); Py_INCREF(__pyx_3); __pyx_6++;
    } else if (likely(PyTuple_CheckExact(__pyx_1))) {
      if (__pyx_6 >= PyTuple_GET_SIZE(__pyx_1)) break;
      __pyx_3 = PyTuple_GET_ITEM(__pyx_1, __pyx_6); Py_INCREF(__pyx_3); __pyx_6++;
    } else {
      __pyx_3 = PyIter_Next(__pyx_1);
      if (!__pyx_3) {
        if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 453; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        break;
      }
    }
    Py_DECREF(__pyx_v_i);
    __pyx_v_i = __pyx_3;
    __pyx_3 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":454
 *         start = self._pts[0]
 *         for i in range(0, seg):
 *             end = self._pts[i+1]             # <<<<<<<<<<<<<<
 *             plen = plen + start.distance_pt(end)
 *             start = end
 */
    __pyx_t_1 = PyNumber_Add(__pyx_v_i, __pyx_int_1); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 454; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_2 = PyObject_GetItem(__pyx_v_self->_pts, __pyx_t_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 454; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    if (!(__Pyx_TypeTest(__pyx_2, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 454; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_v_end));
    __pyx_v_end = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_2);
    __pyx_2 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":455
 *         for i in range(0, seg):
 *             end = self._pts[i+1]
 *             plen = plen + start.distance_pt(end)             # <<<<<<<<<<<<<<
 *             start = end
 *         plen += start.distance_pt(nearest)
 */
    __pyx_v_plen = (__pyx_v_plen + ((struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *)__pyx_v_start->__pyx_vtab)->distance_pt(__pyx_v_start, __pyx_v_end, 0));

    /* "/home/nino/ligeos/ligeos/linearref.pyx":456
 *             end = self._pts[i+1]
 *             plen = plen + start.distance_pt(end)
 *             start = end             # <<<<<<<<<<<<<<
 *         plen += start.distance_pt(nearest)
 *         #print plen, tlen, start.distance_pt(nearest), plen/tlen
 */
    Py_INCREF(((PyObject *)__pyx_v_end));
    Py_DECREF(((PyObject *)__pyx_v_start));
    __pyx_v_start = __pyx_v_end;
  }
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":457
 *             plen = plen + start.distance_pt(end)
 *             start = end
 *         plen += start.distance_pt(nearest)             # <<<<<<<<<<<<<<
 *         #print plen, tlen, start.distance_pt(nearest), plen/tlen
 *         return plen / tlen
 */
  __pyx_v_plen += ((struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *)__pyx_v_start->__pyx_vtab)->distance_pt(__pyx_v_start, __pyx_v_nearest, 0);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":459
 *         plen += start.distance_pt(nearest)
 *         #print plen, tlen, start.distance_pt(nearest), plen/tlen
 *         return plen / tlen             # <<<<<<<<<<<<<<
 * 
 *     cpdef LineString substring(self, double frm, double to):
 */
  __pyx_r = (__pyx_v_plen / __pyx_v_tlen);
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_WriteUnraisable("ligeos.linearref.LineString.locate_point");
  __pyx_r = 0;
  __pyx_L0:;
  Py_XDECREF(__pyx_v_nearest);
  Py_XDECREF(__pyx_v_start);
  Py_XDECREF(__pyx_v_end);
  Py_DECREF(__pyx_v_i);
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":421
 * 
 * 
 *     cpdef double locate_point(self, CPoint p):             # <<<<<<<<<<<<<<
 *         """Find the measure [0,1] on this linestring to which the given point falls nearest."""
 *         cdef CPoint nearest = None
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_locate_point(PyObject *__pyx_v_self, PyObject *__pyx_v_p); /*proto*/
static char __pyx_doc_6ligeos_9linearref_10LineString_locate_point[] = "Find the measure [0,1] on this linestring to which the given point falls nearest.";
static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_locate_point(PyObject *__pyx_v_self, PyObject *__pyx_v_p) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_p), __pyx_ptype_6ligeos_9linearref_CPoint, 1, "p", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 421; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_vtabstruct_6ligeos_9linearref_LineString *)((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->__pyx_vtab)->locate_point(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self), ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_v_p), 1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 421; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.LineString.locate_point");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":461
 *         return plen / tlen
 * 
 *     cpdef LineString substring(self, double frm, double to):             # <<<<<<<<<<<<<<
 *         """Returns the substring of this linestring between the two measures."""
 *         cdef int state = 0 # 0=before, 1=inside
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_substring(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static  struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_f_6ligeos_9linearref_10LineString_substring(struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_v_self, double __pyx_v_frm, double __pyx_v_to, int __pyx_skip_dispatch) {
  int __pyx_v_state;
  PyObject *__pyx_v_dpa = 0;
  PyObject *__pyx_v_ipa = 0;
  double __pyx_v_length;
  double __pyx_v_tlength;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p1 = 0;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_p2 = 0;
  PyObject *__pyx_v_i;
  PyObject *__pyx_v_slength;
  PyObject *__pyx_v_dseg;
  PyObject *__pyx_v_pt;
  struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  double __pyx_5;
  int __pyx_6;
  Py_ssize_t __pyx_7 = 0;
  Py_ssize_t __pyx_8 = 0;
  float __pyx_9;
  PyObject *__pyx_t_1 = NULL;
  __pyx_v_i = Py_None; Py_INCREF(Py_None);
  __pyx_v_slength = Py_None; Py_INCREF(Py_None);
  __pyx_v_dseg = Py_None; Py_INCREF(Py_None);
  __pyx_v_pt = Py_None; Py_INCREF(Py_None);
  /* Check if called by wrapper */
  if (unlikely(__pyx_skip_dispatch)) ;
  /* Check if overriden in Python */
  else if (unlikely(Py_TYPE(((PyObject *)__pyx_v_self))->tp_dictoffset != 0)) {
    __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_substring); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(strcmp(Py_TYPE(__pyx_1)->tp_name, "builtin_function_or_method") == 0) || (PyCFunction_GET_FUNCTION(__pyx_1) != (void *)&__pyx_pf_6ligeos_9linearref_10LineString_substring)) {
      __pyx_2 = PyFloat_FromDouble(__pyx_v_frm); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyFloat_FromDouble(__pyx_v_to); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_4 = PyTuple_New(2); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      PyTuple_SET_ITEM(__pyx_4, 0, __pyx_2);
      PyTuple_SET_ITEM(__pyx_4, 1, __pyx_3);
      __pyx_2 = 0;
      __pyx_3 = 0;
      __pyx_2 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_4), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(((PyObject *)__pyx_4)); __pyx_4 = 0;
      if (!(__Pyx_TypeTest(__pyx_2, __pyx_ptype_6ligeos_9linearref_LineString))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_2);
      __pyx_2 = 0;
      goto __pyx_L0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":463
 *     cpdef LineString substring(self, double frm, double to):
 *         """Returns the substring of this linestring between the two measures."""
 *         cdef int state = 0 # 0=before, 1=inside             # <<<<<<<<<<<<<<
 *         cdef object dpa = [] # the output array
 *         cdef object ipa = self._pts # the input array
 */
  __pyx_v_state = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":464
 *         """Returns the substring of this linestring between the two measures."""
 *         cdef int state = 0 # 0=before, 1=inside
 *         cdef object dpa = [] # the output array             # <<<<<<<<<<<<<<
 *         cdef object ipa = self._pts # the input array
 *         cdef double length = self.length()
 */
  __pyx_3 = PyList_New(0); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 464; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_v_dpa = ((PyObject *)__pyx_3);
  __pyx_3 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":465
 *         cdef int state = 0 # 0=before, 1=inside
 *         cdef object dpa = [] # the output array
 *         cdef object ipa = self._pts # the input array             # <<<<<<<<<<<<<<
 *         cdef double length = self.length()
 *         cdef double tlength = 0 # traversed length
 */
  Py_INCREF(__pyx_v_self->_pts);
  __pyx_v_ipa = __pyx_v_self->_pts;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":466
 *         cdef object dpa = [] # the output array
 *         cdef object ipa = self._pts # the input array
 *         cdef double length = self.length()             # <<<<<<<<<<<<<<
 *         cdef double tlength = 0 # traversed length
 *         cdef CPoint p1 = ipa[0]
 */
  __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_length); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 466; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_4 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 466; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_5 = __pyx_PyFloat_AsDouble(__pyx_4); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 466; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  __pyx_v_length = __pyx_5;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":467
 *         cdef object ipa = self._pts # the input array
 *         cdef double length = self.length()
 *         cdef double tlength = 0 # traversed length             # <<<<<<<<<<<<<<
 *         cdef CPoint p1 = ipa[0]
 *         cdef CPoint p2 = None
 */
  __pyx_v_tlength = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":468
 *         cdef double length = self.length()
 *         cdef double tlength = 0 # traversed length
 *         cdef CPoint p1 = ipa[0]             # <<<<<<<<<<<<<<
 *         cdef CPoint p2 = None
 * 
 */
  __pyx_2 = __Pyx_GetItemInt(__pyx_v_ipa, 0, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 468; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (!(__Pyx_TypeTest(__pyx_2, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 468; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_v_p1 = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_2);
  __pyx_2 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":469
 *         cdef double tlength = 0 # traversed length
 *         cdef CPoint p1 = ipa[0]
 *         cdef CPoint p2 = None             # <<<<<<<<<<<<<<
 * 
 *         if frm > to:
 */
  Py_INCREF(Py_None);
  __pyx_v_p2 = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":471
 *         cdef CPoint p2 = None
 * 
 *         if frm > to:             # <<<<<<<<<<<<<<
 *             raise ArgumentError("from is less than to")
 *         # Get 'from' and 'to' lengths
 */
  __pyx_6 = (__pyx_v_frm > __pyx_v_to);
  if (__pyx_6) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":472
 * 
 *         if frm > to:
 *             raise ArgumentError("from is less than to")             # <<<<<<<<<<<<<<
 *         # Get 'from' and 'to' lengths
 *         frm = length*frm
 */
    __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_kp_ArgumentError); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 472; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_1 = PyTuple_New(1); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 472; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_INCREF(__pyx_kp_22);
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_kp_22);
    __pyx_4 = PyObject_Call(__pyx_3, ((PyObject *)__pyx_1), NULL); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 472; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(((PyObject *)__pyx_1)); __pyx_1 = 0;
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 472; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":474
 *             raise ArgumentError("from is less than to")
 *         # Get 'from' and 'to' lengths
 *         frm = length*frm             # <<<<<<<<<<<<<<
 *         to = length*to
 * 
 */
  __pyx_v_frm = (__pyx_v_length * __pyx_v_frm);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":475
 *         # Get 'from' and 'to' lengths
 *         frm = length*frm
 *         to = length*to             # <<<<<<<<<<<<<<
 * 
 *         for i in range(0, len(ipa)-1):
 */
  __pyx_v_to = (__pyx_v_length * __pyx_v_to);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":477
 *         to = length*to
 * 
 *         for i in range(0, len(ipa)-1):             # <<<<<<<<<<<<<<
 *             p2 = ipa[i+1]
 *             #LWDEBUGF(3 ,"Segment %d: (%g,%g,%g,%g)-(%g,%g,%g,%g)",
 */
  __pyx_8 = PyObject_Length(__pyx_v_ipa); if (unlikely(__pyx_8 == -1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 477; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyInt_FromSsize_t((__pyx_8 - 1)); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 477; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyTuple_New(2); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 477; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_int_0);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_int_0);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_2);
  __pyx_2 = 0;
  __pyx_1 = PyObject_Call(__pyx_builtin_range, ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 477; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
  if (PyList_CheckExact(__pyx_1) || PyTuple_CheckExact(__pyx_1)) {
    __pyx_7 = 0; __pyx_4 = __pyx_1; Py_INCREF(__pyx_4);
  } else {
    __pyx_7 = -1; __pyx_4 = PyObject_GetIter(__pyx_1); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 477; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  }
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  for (;;) {
    if (likely(PyList_CheckExact(__pyx_4))) {
      if (__pyx_7 >= PyList_GET_SIZE(__pyx_4)) break;
      __pyx_2 = PyList_GET_ITEM(__pyx_4, __pyx_7); Py_INCREF(__pyx_2); __pyx_7++;
    } else if (likely(PyTuple_CheckExact(__pyx_4))) {
      if (__pyx_7 >= PyTuple_GET_SIZE(__pyx_4)) break;
      __pyx_2 = PyTuple_GET_ITEM(__pyx_4, __pyx_7); Py_INCREF(__pyx_2); __pyx_7++;
    } else {
      __pyx_2 = PyIter_Next(__pyx_4);
      if (!__pyx_2) {
        if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 477; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        break;
      }
    }
    Py_DECREF(__pyx_v_i);
    __pyx_v_i = __pyx_2;
    __pyx_2 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":478
 * 
 *         for i in range(0, len(ipa)-1):
 *             p2 = ipa[i+1]             # <<<<<<<<<<<<<<
 *             #LWDEBUGF(3 ,"Segment %d: (%g,%g,%g,%g)-(%g,%g,%g,%g)",
 *             #    i, p1.x, p1.y, p1.z, p1.m, p2.x, p2.y, p2.z, p2.m);
 */
    __pyx_t_1 = PyNumber_Add(__pyx_v_i, __pyx_int_1); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 478; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_3 = PyObject_GetItem(__pyx_v_ipa, __pyx_t_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 478; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    if (!(__Pyx_TypeTest(__pyx_3, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 478; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(((PyObject *)__pyx_v_p2));
    __pyx_v_p2 = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3);
    __pyx_3 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":482
 *             #    i, p1.x, p1.y, p1.z, p1.m, p2.x, p2.y, p2.z, p2.m);
 *             # Find the length of this segment
 *             slength = p1.distance_pt(p2)             # <<<<<<<<<<<<<<
 * 
 *             """
 */
    __pyx_1 = PyFloat_FromDouble(((struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *)__pyx_v_p1->__pyx_vtab)->distance_pt(__pyx_v_p1, __pyx_v_p2, 0)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 482; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    Py_DECREF(__pyx_v_slength);
    __pyx_v_slength = __pyx_1;
    __pyx_1 = 0;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":487
 *              * We are before requested start.
 *             """
 *             if state == 0: #  before             # <<<<<<<<<<<<<<
 *                 """
 *                  * Didn't reach the 'from' point,
 */
    __pyx_6 = (__pyx_v_state == 0);
    if (__pyx_6) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":492
 *                  * nothing to do
 *                 """
 *                 if frm > tlength + slength:             # <<<<<<<<<<<<<<
 *                     tlength += slength
 *                     p1 = p2
 */
      __pyx_2 = PyFloat_FromDouble(__pyx_v_frm); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 492; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyFloat_FromDouble(__pyx_v_tlength); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 492; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_t_1 = PyNumber_Add(__pyx_3, __pyx_v_slength); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 492; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_1 = PyObject_RichCompare(__pyx_2, __pyx_t_1, Py_GT); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 492; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
      __pyx_6 = __Pyx_PyObject_IsTrue(__pyx_1); if (unlikely(__pyx_6 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 492; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      if (__pyx_6) {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":493
 *                 """
 *                 if frm > tlength + slength:
 *                     tlength += slength             # <<<<<<<<<<<<<<
 *                     p1 = p2
 *                     continue
 */
        __pyx_5 = __pyx_PyFloat_AsDouble(__pyx_v_slength); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 493; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_v_tlength += __pyx_5;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":494
 *                 if frm > tlength + slength:
 *                     tlength += slength
 *                     p1 = p2             # <<<<<<<<<<<<<<
 *                     continue
 *                     # goto END
 */
        Py_INCREF(((PyObject *)__pyx_v_p2));
        Py_DECREF(((PyObject *)__pyx_v_p1));
        __pyx_v_p1 = __pyx_v_p2;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":495
 *                     tlength += slength
 *                     p1 = p2
 *                     continue             # <<<<<<<<<<<<<<
 *                     # goto END
 * 
 */
        goto __pyx_L4;
        goto __pyx_L7;
      }

      /* "/home/nino/ligeos/ligeos/linearref.pyx":498
 *                     # goto END
 * 
 *                 elif frm == tlength + slength:             # <<<<<<<<<<<<<<
 *                     #LWDEBUG(3, "  Second point is our start");
 *                     """
 */
      __pyx_3 = PyFloat_FromDouble(__pyx_v_frm); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_2 = PyFloat_FromDouble(__pyx_v_tlength); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_t_1 = PyNumber_Add(__pyx_2, __pyx_v_slength); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_1 = PyObject_RichCompare(__pyx_3, __pyx_t_1, Py_EQ); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
      __pyx_6 = __Pyx_PyObject_IsTrue(__pyx_1); if (unlikely(__pyx_6 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      if (__pyx_6) {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":503
 *                      * Second point is our start
 *                     """
 *                     dpa.append(p2)             # <<<<<<<<<<<<<<
 *                     state=1 #;  we're inside now
 * 
 */
        __pyx_2 = __Pyx_PyObject_Append(__pyx_v_dpa, ((PyObject *)__pyx_v_p2)); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 503; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_2); __pyx_2 = 0;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":504
 *                     """
 *                     dpa.append(p2)
 *                     state=1 #;  we're inside now             # <<<<<<<<<<<<<<
 * 
 *                 elif frm == tlength:
 */
        __pyx_v_state = 1;
        goto __pyx_L7;
      }

      /* "/home/nino/ligeos/ligeos/linearref.pyx":506
 *                     state=1 #;  we're inside now
 * 
 *                 elif frm == tlength:             # <<<<<<<<<<<<<<
 *                     #LWDEBUG(3, "  First point is our start");
 *                     """
 */
      __pyx_6 = (__pyx_v_frm == __pyx_v_tlength);
      if (__pyx_6) {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":511
 *                      * First point is our start
 *                     """
 *                     dpa.append(p1)             # <<<<<<<<<<<<<<
 *                     """
 *                      * We're inside now, but will check
 */
        __pyx_3 = __Pyx_PyObject_Append(__pyx_v_dpa, ((PyObject *)__pyx_v_p1)); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 511; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":516
 *                      * 'to' point as well
 *                     """
 *                     state=1             # <<<<<<<<<<<<<<
 * 
 *                 else:  # tlength < from < tlength+slength
 */
        __pyx_v_state = 1;
        goto __pyx_L7;
      }
      /*else*/ {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":523
 *                      * second point
 *                     """
 *                     dseg = (frm- tlength) / slength;             # <<<<<<<<<<<<<<
 *                     pt = interpolate_point2d(p1, p2,dseg)
 *                     dpa.append(pt)
 */
        __pyx_1 = PyFloat_FromDouble((__pyx_v_frm - __pyx_v_tlength)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 523; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_t_1 = __Pyx_PyNumber_Divide(__pyx_1, __pyx_v_slength); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 523; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_v_dseg);
        __pyx_v_dseg = __pyx_t_1;
        __pyx_t_1 = 0;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":524
 *                     """
 *                     dseg = (frm- tlength) / slength;
 *                     pt = interpolate_point2d(p1, p2,dseg)             # <<<<<<<<<<<<<<
 *                     dpa.append(pt)
 *                     """
 */
        __pyx_9 = __pyx_PyFloat_AsDouble(__pyx_v_dseg); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 524; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_2 = __pyx_f_6ligeos_9linearref_interpolate_point2d(__pyx_v_p1, __pyx_v_p2, __pyx_9); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 524; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_v_pt);
        __pyx_v_pt = __pyx_2;
        __pyx_2 = 0;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":525
 *                     dseg = (frm- tlength) / slength;
 *                     pt = interpolate_point2d(p1, p2,dseg)
 *                     dpa.append(pt)             # <<<<<<<<<<<<<<
 *                     """
 *                      * We're inside now, but will check
 */
        __pyx_3 = __Pyx_PyObject_Append(__pyx_v_dpa, __pyx_v_pt); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 525; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":530
 *                      * 'to' point as well
 *                      """
 *                     state=1             # <<<<<<<<<<<<<<
 * 
 *             if state == 1: # inside
 */
        __pyx_v_state = 1;
      }
      __pyx_L7:;
      goto __pyx_L6;
    }
    __pyx_L6:;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":532
 *                     state=1
 * 
 *             if state == 1: # inside             # <<<<<<<<<<<<<<
 *                 #LWDEBUG(3, " Inside");
 *                 """
 */
    __pyx_6 = (__pyx_v_state == 1);
    if (__pyx_6) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":538
 *                  * just copy second point
 *                  """
 *                 if to > tlength + slength:             # <<<<<<<<<<<<<<
 *                     dpa.append(p2)
 *                     tlength += slength
 */
      __pyx_1 = PyFloat_FromDouble(__pyx_v_to); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 538; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_2 = PyFloat_FromDouble(__pyx_v_tlength); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 538; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_t_1 = PyNumber_Add(__pyx_2, __pyx_v_slength); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 538; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_3 = PyObject_RichCompare(__pyx_1, __pyx_t_1, Py_GT); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 538; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
      __pyx_6 = __Pyx_PyObject_IsTrue(__pyx_3); if (unlikely(__pyx_6 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 538; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      if (__pyx_6) {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":539
 *                  """
 *                 if to > tlength + slength:
 *                     dpa.append(p2)             # <<<<<<<<<<<<<<
 *                     tlength += slength
 *                     p1 = p2
 */
        __pyx_2 = __Pyx_PyObject_Append(__pyx_v_dpa, ((PyObject *)__pyx_v_p2)); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 539; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_2); __pyx_2 = 0;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":540
 *                 if to > tlength + slength:
 *                     dpa.append(p2)
 *                     tlength += slength             # <<<<<<<<<<<<<<
 *                     p1 = p2
 *                     continue
 */
        __pyx_5 = __pyx_PyFloat_AsDouble(__pyx_v_slength); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 540; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_v_tlength += __pyx_5;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":541
 *                     dpa.append(p2)
 *                     tlength += slength
 *                     p1 = p2             # <<<<<<<<<<<<<<
 *                     continue
 *                     #goto END;
 */
        Py_INCREF(((PyObject *)__pyx_v_p2));
        Py_DECREF(((PyObject *)__pyx_v_p1));
        __pyx_v_p1 = __pyx_v_p2;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":542
 *                     tlength += slength
 *                     p1 = p2
 *                     continue             # <<<<<<<<<<<<<<
 *                     #goto END;
 * 
 */
        goto __pyx_L4;
        goto __pyx_L9;
      }

      /* "/home/nino/ligeos/ligeos/linearref.pyx":545
 *                     #goto END;
 * 
 *                 elif to == tlength + slength:             # <<<<<<<<<<<<<<
 *                     """
 *                      * 'to' point is our second point.
 */
      __pyx_1 = PyFloat_FromDouble(__pyx_v_to); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 545; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyFloat_FromDouble(__pyx_v_tlength); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 545; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_t_1 = PyNumber_Add(__pyx_3, __pyx_v_slength); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 545; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_2 = PyObject_RichCompare(__pyx_1, __pyx_t_1, Py_EQ); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 545; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
      __pyx_6 = __Pyx_PyObject_IsTrue(__pyx_2); if (unlikely(__pyx_6 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 545; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      if (__pyx_6) {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":549
 *                      * 'to' point is our second point.
 *                     """
 *                     dpa.append(p2)             # <<<<<<<<<<<<<<
 *                     break #  substring complete
 * 
 */
        __pyx_3 = __Pyx_PyObject_Append(__pyx_v_dpa, ((PyObject *)__pyx_v_p2)); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 549; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":550
 *                     """
 *                     dpa.append(p2)
 *                     break #  substring complete             # <<<<<<<<<<<<<<
 * 
 *                 elif to == tlength:
 */
        goto __pyx_L5;
        goto __pyx_L9;
      }

      /* "/home/nino/ligeos/ligeos/linearref.pyx":552
 *                     break #  substring complete
 * 
 *                 elif to == tlength:             # <<<<<<<<<<<<<<
 *                     """
 *                      * 'to' point is our first point.
 */
      __pyx_6 = (__pyx_v_to == __pyx_v_tlength);
      if (__pyx_6) {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":557
 *                      * (should only happen if 'to' is 0)
 *                     """
 *                     dpa.append(p1)             # <<<<<<<<<<<<<<
 *                     break#;  substring complete
 * 
 */
        __pyx_1 = __Pyx_PyObject_Append(__pyx_v_dpa, ((PyObject *)__pyx_v_p1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 557; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":558
 *                     """
 *                     dpa.append(p1)
 *                     break#;  substring complete             # <<<<<<<<<<<<<<
 * 
 * 
 */
        goto __pyx_L5;
        goto __pyx_L9;
      }

      /* "/home/nino/ligeos/ligeos/linearref.pyx":561
 * 
 * 
 *                 elif ( to < tlength + slength ):             # <<<<<<<<<<<<<<
 *                     """
 *                      * 'to' point falls on this segment
 */
      __pyx_2 = PyFloat_FromDouble(__pyx_v_to); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyFloat_FromDouble(__pyx_v_tlength); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_t_1 = PyNumber_Add(__pyx_3, __pyx_v_slength); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_1 = PyObject_RichCompare(__pyx_2, __pyx_t_1, Py_LT); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_t_1); __pyx_t_1 = 0;
      __pyx_6 = __Pyx_PyObject_IsTrue(__pyx_1); if (unlikely(__pyx_6 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      if (__pyx_6) {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":566
 *                      * Interpolate and break.
 *                     """
 *                     dseg = (to - tlength) / slength             # <<<<<<<<<<<<<<
 *                     pt = interpolate_point2d(p1, p2, dseg)
 *                     dpa.append(pt)
 */
        __pyx_3 = PyFloat_FromDouble((__pyx_v_to - __pyx_v_tlength)); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 566; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_t_1 = __Pyx_PyNumber_Divide(__pyx_3, __pyx_v_slength); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 566; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        Py_DECREF(__pyx_v_dseg);
        __pyx_v_dseg = __pyx_t_1;
        __pyx_t_1 = 0;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":567
 *                     """
 *                     dseg = (to - tlength) / slength
 *                     pt = interpolate_point2d(p1, p2, dseg)             # <<<<<<<<<<<<<<
 *                     dpa.append(pt)
 *                     break
 */
        __pyx_9 = __pyx_PyFloat_AsDouble(__pyx_v_dseg); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 567; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __pyx_2 = __pyx_f_6ligeos_9linearref_interpolate_point2d(__pyx_v_p1, __pyx_v_p2, __pyx_9); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 567; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_v_pt);
        __pyx_v_pt = __pyx_2;
        __pyx_2 = 0;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":568
 *                     dseg = (to - tlength) / slength
 *                     pt = interpolate_point2d(p1, p2, dseg)
 *                     dpa.append(pt)             # <<<<<<<<<<<<<<
 *                     break
 *                 else:
 */
        __pyx_1 = __Pyx_PyObject_Append(__pyx_v_dpa, __pyx_v_pt); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 568; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;

        /* "/home/nino/ligeos/ligeos/linearref.pyx":569
 *                     pt = interpolate_point2d(p1, p2, dseg)
 *                     dpa.append(pt)
 *                     break             # <<<<<<<<<<<<<<
 *                 else:
 *                     print "Unhandled case"
 */
        goto __pyx_L5;
        goto __pyx_L9;
      }
      /*else*/ {

        /* "/home/nino/ligeos/ligeos/linearref.pyx":571
 *                     break
 *                 else:
 *                     print "Unhandled case"             # <<<<<<<<<<<<<<
 * 
 *             tlength += slength
 */
        __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 571; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_INCREF(__pyx_kp_23);
        PyTuple_SET_ITEM(__pyx_3, 0, __pyx_kp_23);
        if (__Pyx_Print(((PyObject *)__pyx_3), 1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 571; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
      }
      __pyx_L9:;
      goto __pyx_L8;
    }
    __pyx_L8:;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":573
 *                     print "Unhandled case"
 * 
 *             tlength += slength             # <<<<<<<<<<<<<<
 *             p1 = p2
 * 
 */
    __pyx_5 = __pyx_PyFloat_AsDouble(__pyx_v_slength); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 573; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __pyx_v_tlength += __pyx_5;

    /* "/home/nino/ligeos/ligeos/linearref.pyx":574
 * 
 *             tlength += slength
 *             p1 = p2             # <<<<<<<<<<<<<<
 * 
 *         return LineString(dpa, geographic=ipa[0].is_geo())
 */
    Py_INCREF(((PyObject *)__pyx_v_p2));
    Py_DECREF(((PyObject *)__pyx_v_p1));
    __pyx_v_p1 = __pyx_v_p2;
    __pyx_L4:;
  }
  __pyx_L5:;
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":576
 *             p1 = p2
 * 
 *         return LineString(dpa, geographic=ipa[0].is_geo())             # <<<<<<<<<<<<<<
 * 
 *     cpdef LineString concatenate(self, LineString l2, float merge_tolerance=0):
 */
  __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 576; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_dpa);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_dpa);
  __pyx_1 = PyDict_New(); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 576; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = __Pyx_GetItemInt(__pyx_v_ipa, 0, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 576; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_4 = PyObject_GetAttr(__pyx_3, __pyx_kp_is_geo); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 576; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_3 = PyObject_Call(__pyx_4, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 576; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  if (PyDict_SetItem(__pyx_1, __pyx_kp_geographic, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 576; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_4 = PyEval_CallObjectWithKeywords(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_LineString)), ((PyObject *)__pyx_2), ((PyObject *)__pyx_1)); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 576; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  Py_DECREF(((PyObject *)__pyx_1)); __pyx_1 = 0;
  if (!(__Pyx_TypeTest(__pyx_4, __pyx_ptype_6ligeos_9linearref_LineString))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 576; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_4);
  __pyx_4 = 0;
  goto __pyx_L0;

  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)Py_None); Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("ligeos.linearref.LineString.substring");
  __pyx_r = 0;
  __pyx_L0:;
  Py_XDECREF(__pyx_v_dpa);
  Py_XDECREF(__pyx_v_ipa);
  Py_XDECREF(__pyx_v_p1);
  Py_XDECREF(__pyx_v_p2);
  Py_DECREF(__pyx_v_i);
  Py_DECREF(__pyx_v_slength);
  Py_DECREF(__pyx_v_dseg);
  Py_DECREF(__pyx_v_pt);
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":461
 *         return plen / tlen
 * 
 *     cpdef LineString substring(self, double frm, double to):             # <<<<<<<<<<<<<<
 *         """Returns the substring of this linestring between the two measures."""
 *         cdef int state = 0 # 0=before, 1=inside
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_substring(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_6ligeos_9linearref_10LineString_substring[] = "Returns the substring of this linestring between the two measures.";
static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_substring(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  double __pyx_v_frm;
  double __pyx_v_to;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_frm,&__pyx_kp_to,0};
  if (unlikely(__pyx_kwds)) {
    PyObject* values[2] = {0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_frm);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_to);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("substring", 1, 2, 2, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "substring") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_frm = __pyx_PyFloat_AsDouble(values[0]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_to = __pyx_PyFloat_AsDouble(values[1]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  } else if (PyTuple_GET_SIZE(__pyx_args) != 2) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_frm = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 0)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    __pyx_v_to = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 1)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("substring", 1, 2, 2, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.LineString.substring");
  return NULL;
  __pyx_L4_argument_unpacking_done:;
  __pyx_1 = ((PyObject *)((struct __pyx_vtabstruct_6ligeos_9linearref_LineString *)((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->__pyx_vtab)->substring(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self), __pyx_v_frm, __pyx_v_to, 1)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 461; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("ligeos.linearref.LineString.substring");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":578
 *         return LineString(dpa, geographic=ipa[0].is_geo())
 * 
 *     cpdef LineString concatenate(self, LineString l2, float merge_tolerance=0):             # <<<<<<<<<<<<<<
 *         """Returns true if l2 was joined or None, if the min distance is above the max distance allowed."""
 *         cdef CPoint a, b, c, d
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_concatenate(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static  struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_f_6ligeos_9linearref_10LineString_concatenate(struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_v_self, struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_v_l2, int __pyx_skip_dispatch, struct __pyx_opt_args_6ligeos_9linearref_10LineString_concatenate *__pyx_optional_args) {
  float __pyx_v_merge_tolerance = ((float)0);
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_a;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_b;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_c;
  struct __pyx_obj_6ligeos_9linearref_CPoint *__pyx_v_d;
  double __pyx_v_ac;
  double __pyx_v_ad;
  double __pyx_v_bc;
  double __pyx_v_bd;
  struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  int __pyx_6;
  if (__pyx_optional_args) {
    if (__pyx_optional_args->__pyx_n > 0) {
      __pyx_v_merge_tolerance = __pyx_optional_args->merge_tolerance;
    }
  }
  __pyx_v_a = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  __pyx_v_b = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  __pyx_v_c = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  __pyx_v_d = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  /* Check if called by wrapper */
  if (unlikely(__pyx_skip_dispatch)) ;
  /* Check if overriden in Python */
  else if (unlikely(Py_TYPE(((PyObject *)__pyx_v_self))->tp_dictoffset != 0)) {
    __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_self), __pyx_kp_concatenate); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 578; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    if (!(strcmp(Py_TYPE(__pyx_1)->tp_name, "builtin_function_or_method") == 0) || (PyCFunction_GET_FUNCTION(__pyx_1) != (void *)&__pyx_pf_6ligeos_9linearref_10LineString_concatenate)) {
      __pyx_2 = PyFloat_FromDouble(__pyx_v_merge_tolerance); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 578; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyTuple_New(2); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 578; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(((PyObject *)__pyx_v_l2));
      PyTuple_SET_ITEM(__pyx_3, 0, ((PyObject *)__pyx_v_l2));
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_2);
      __pyx_2 = 0;
      __pyx_2 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 578; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
      if (!(__Pyx_TypeTest(__pyx_2, __pyx_ptype_6ligeos_9linearref_LineString))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 578; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_2);
      __pyx_2 = 0;
      goto __pyx_L0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":581
 *         """Returns true if l2 was joined or None, if the min distance is above the max distance allowed."""
 *         cdef CPoint a, b, c, d
 *         a = self._pts[0]             # <<<<<<<<<<<<<<
 *         b = self._pts[-1]
 *         c = l2._pts[0]
 */
  __pyx_1 = __Pyx_GetItemInt(__pyx_v_self->_pts, 0, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 581; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (!(__Pyx_TypeTest(__pyx_1, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 581; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_v_a));
  __pyx_v_a = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_1);
  __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":582
 *         cdef CPoint a, b, c, d
 *         a = self._pts[0]
 *         b = self._pts[-1]             # <<<<<<<<<<<<<<
 *         c = l2._pts[0]
 *         d = l2._pts[-1]
 */
  __pyx_3 = __Pyx_GetItemInt(__pyx_v_self->_pts, -1, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 582; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (!(__Pyx_TypeTest(__pyx_3, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 582; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_v_b));
  __pyx_v_b = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_3);
  __pyx_3 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":583
 *         a = self._pts[0]
 *         b = self._pts[-1]
 *         c = l2._pts[0]             # <<<<<<<<<<<<<<
 *         d = l2._pts[-1]
 *         cdef double ac = a.distance_pt(c)
 */
  __pyx_2 = __Pyx_GetItemInt(__pyx_v_l2->_pts, 0, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 583; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (!(__Pyx_TypeTest(__pyx_2, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 583; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_v_c));
  __pyx_v_c = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_2);
  __pyx_2 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":584
 *         b = self._pts[-1]
 *         c = l2._pts[0]
 *         d = l2._pts[-1]             # <<<<<<<<<<<<<<
 *         cdef double ac = a.distance_pt(c)
 *         cdef double ad = a.distance_pt(d)
 */
  __pyx_1 = __Pyx_GetItemInt(__pyx_v_l2->_pts, -1, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 584; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (!(__Pyx_TypeTest(__pyx_1, __pyx_ptype_6ligeos_9linearref_CPoint))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 584; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_v_d));
  __pyx_v_d = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)__pyx_1);
  __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":585
 *         c = l2._pts[0]
 *         d = l2._pts[-1]
 *         cdef double ac = a.distance_pt(c)             # <<<<<<<<<<<<<<
 *         cdef double ad = a.distance_pt(d)
 *         cdef double bc = b.distance_pt(c)
 */
  __pyx_v_ac = ((struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *)__pyx_v_a->__pyx_vtab)->distance_pt(__pyx_v_a, __pyx_v_c, 0);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":586
 *         d = l2._pts[-1]
 *         cdef double ac = a.distance_pt(c)
 *         cdef double ad = a.distance_pt(d)             # <<<<<<<<<<<<<<
 *         cdef double bc = b.distance_pt(c)
 *         cdef double bd = b.distance_pt(d)
 */
  __pyx_v_ad = ((struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *)__pyx_v_a->__pyx_vtab)->distance_pt(__pyx_v_a, __pyx_v_d, 0);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":587
 *         cdef double ac = a.distance_pt(c)
 *         cdef double ad = a.distance_pt(d)
 *         cdef double bc = b.distance_pt(c)             # <<<<<<<<<<<<<<
 *         cdef double bd = b.distance_pt(d)
 * 
 */
  __pyx_v_bc = ((struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *)__pyx_v_b->__pyx_vtab)->distance_pt(__pyx_v_b, __pyx_v_c, 0);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":588
 *         cdef double ad = a.distance_pt(d)
 *         cdef double bc = b.distance_pt(c)
 *         cdef double bd = b.distance_pt(d)             # <<<<<<<<<<<<<<
 * 
 *         """
 */
  __pyx_v_bd = ((struct __pyx_vtabstruct_6ligeos_9linearref_CPoint *)__pyx_v_b->__pyx_vtab)->distance_pt(__pyx_v_b, __pyx_v_d, 0);

  /* "/home/nino/ligeos/ligeos/linearref.pyx":596
 *         [9, 8, 7, 6, 5, 4, 3, 2, 1]
 *         """
 *         if ac < min(ad, min(bc, bd)):             # <<<<<<<<<<<<<<
 *             #print "Case 1", a, c, ac
 *             if ac <= merge_tolerance:
 */
  __pyx_3 = PyFloat_FromDouble(__pyx_v_ac); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 596; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyFloat_FromDouble(__pyx_v_ad); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 596; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyFloat_FromDouble(__pyx_v_bc); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 596; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_4 = PyFloat_FromDouble(__pyx_v_bd); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 596; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_5 = PyTuple_New(2); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 596; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_5, 0, __pyx_1);
  PyTuple_SET_ITEM(__pyx_5, 1, __pyx_4);
  __pyx_1 = 0;
  __pyx_4 = 0;
  __pyx_1 = PyObject_Call(__pyx_builtin_min, ((PyObject *)__pyx_5), NULL); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 596; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
  __pyx_4 = PyTuple_New(2); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 596; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_4, 0, __pyx_2);
  PyTuple_SET_ITEM(__pyx_4, 1, __pyx_1);
  __pyx_2 = 0;
  __pyx_1 = 0;
  __pyx_5 = PyObject_Call(__pyx_builtin_min, ((PyObject *)__pyx_4), NULL); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 596; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_4)); __pyx_4 = 0;
  __pyx_2 = PyObject_RichCompare(__pyx_3, __pyx_5, Py_LT); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 596; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_5); __pyx_5 = 0;
  __pyx_6 = __Pyx_PyObject_IsTrue(__pyx_2); if (unlikely(__pyx_6 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 596; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_6) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":598
 *         if ac < min(ad, min(bc, bd)):
 *             #print "Case 1", a, c, ac
 *             if ac <= merge_tolerance:             # <<<<<<<<<<<<<<
 *                 return LineString(self._pts[-1:0:-1], l2._pts[1:], geographic=self.geographic)
 *             else:
 */
    __pyx_6 = (__pyx_v_ac <= __pyx_v_merge_tolerance);
    if (__pyx_6) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":599
 *             #print "Case 1", a, c, ac
 *             if ac <= merge_tolerance:
 *                 return LineString(self._pts[-1:0:-1], l2._pts[1:], geographic=self.geographic)             # <<<<<<<<<<<<<<
 *             else:
 *                 return LineString(self._pts[::-1], l2._pts, geographic=self.geographic)
 */
      __pyx_1 = PySlice_New(__pyx_int_neg_1, __pyx_int_0, __pyx_int_neg_1); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 599; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_4 = PyObject_GetItem(__pyx_v_self->_pts, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 599; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_3 = PySequence_GetSlice(__pyx_v_l2->_pts, 1, PY_SSIZE_T_MAX); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 599; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_5 = PyTuple_New(2); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 599; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      PyTuple_SET_ITEM(__pyx_5, 0, __pyx_4);
      PyTuple_SET_ITEM(__pyx_5, 1, __pyx_3);
      __pyx_4 = 0;
      __pyx_3 = 0;
      __pyx_2 = PyDict_New(); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 599; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (PyDict_SetItem(__pyx_2, __pyx_kp_geographic, __pyx_v_self->geographic) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 599; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_1 = PyEval_CallObjectWithKeywords(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_LineString)), ((PyObject *)__pyx_5), ((PyObject *)__pyx_2)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 599; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      if (!(__Pyx_TypeTest(__pyx_1, __pyx_ptype_6ligeos_9linearref_LineString))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 599; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_1);
      __pyx_1 = 0;
      goto __pyx_L0;
      goto __pyx_L4;
    }
    /*else*/ {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":601
 *                 return LineString(self._pts[-1:0:-1], l2._pts[1:], geographic=self.geographic)
 *             else:
 *                 return LineString(self._pts[::-1], l2._pts, geographic=self.geographic)             # <<<<<<<<<<<<<<
 * 
 *         elif ad < min(bc, bd):
 */
      __pyx_4 = PySlice_New(Py_None, Py_None, __pyx_int_neg_1); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 601; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_3 = PyObject_GetItem(__pyx_v_self->_pts, __pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 601; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_5 = PyTuple_New(2); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 601; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      PyTuple_SET_ITEM(__pyx_5, 0, __pyx_3);
      Py_INCREF(__pyx_v_l2->_pts);
      PyTuple_SET_ITEM(__pyx_5, 1, __pyx_v_l2->_pts);
      __pyx_3 = 0;
      __pyx_2 = PyDict_New(); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 601; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (PyDict_SetItem(__pyx_2, __pyx_kp_geographic, __pyx_v_self->geographic) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 601; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_1 = PyEval_CallObjectWithKeywords(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_LineString)), ((PyObject *)__pyx_5), ((PyObject *)__pyx_2)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 601; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      if (!(__Pyx_TypeTest(__pyx_1, __pyx_ptype_6ligeos_9linearref_LineString))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 601; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_1);
      __pyx_1 = 0;
      goto __pyx_L0;
    }
    __pyx_L4:;
    goto __pyx_L3;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":603
 *                 return LineString(self._pts[::-1], l2._pts, geographic=self.geographic)
 * 
 *         elif ad < min(bc, bd):             # <<<<<<<<<<<<<<
 *             #print "Case 2", a, d, ad
 *             if ad <= merge_tolerance:
 */
  __pyx_4 = PyFloat_FromDouble(__pyx_v_ad); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 603; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyFloat_FromDouble(__pyx_v_bc); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 603; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_5 = PyFloat_FromDouble(__pyx_v_bd); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 603; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyTuple_New(2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 603; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_5);
  __pyx_3 = 0;
  __pyx_5 = 0;
  __pyx_1 = PyObject_Call(__pyx_builtin_min, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 603; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  __pyx_3 = PyObject_RichCompare(__pyx_4, __pyx_1, Py_LT); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 603; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_6 = __Pyx_PyObject_IsTrue(__pyx_3); if (unlikely(__pyx_6 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 603; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (__pyx_6) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":605
 *         elif ad < min(bc, bd):
 *             #print "Case 2", a, d, ad
 *             if ad <= merge_tolerance:             # <<<<<<<<<<<<<<
 *                 return LineString(l2._pts, self._pts[1:], geographic=self.geographic)
 *             else:
 */
    __pyx_6 = (__pyx_v_ad <= __pyx_v_merge_tolerance);
    if (__pyx_6) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":606
 *             #print "Case 2", a, d, ad
 *             if ad <= merge_tolerance:
 *                 return LineString(l2._pts, self._pts[1:], geographic=self.geographic)             # <<<<<<<<<<<<<<
 *             else:
 *                 return LineString(l2._pts, self._pts, geographic=self.geographic)
 */
      __pyx_5 = PySequence_GetSlice(__pyx_v_self->_pts, 1, PY_SSIZE_T_MAX); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 606; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_2 = PyTuple_New(2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 606; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(__pyx_v_l2->_pts);
      PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_l2->_pts);
      PyTuple_SET_ITEM(__pyx_2, 1, __pyx_5);
      __pyx_5 = 0;
      __pyx_4 = PyDict_New(); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 606; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (PyDict_SetItem(__pyx_4, __pyx_kp_geographic, __pyx_v_self->geographic) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 606; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_1 = PyEval_CallObjectWithKeywords(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_LineString)), ((PyObject *)__pyx_2), ((PyObject *)__pyx_4)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 606; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      Py_DECREF(((PyObject *)__pyx_4)); __pyx_4 = 0;
      if (!(__Pyx_TypeTest(__pyx_1, __pyx_ptype_6ligeos_9linearref_LineString))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 606; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_1);
      __pyx_1 = 0;
      goto __pyx_L0;
      goto __pyx_L5;
    }
    /*else*/ {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":608
 *                 return LineString(l2._pts, self._pts[1:], geographic=self.geographic)
 *             else:
 *                 return LineString(l2._pts, self._pts, geographic=self.geographic)             # <<<<<<<<<<<<<<
 *         elif bc < bd:
 *             #print "Case 3", b, c, bc
 */
      __pyx_3 = PyTuple_New(2); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 608; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(__pyx_v_l2->_pts);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_l2->_pts);
      Py_INCREF(__pyx_v_self->_pts);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_self->_pts);
      __pyx_5 = PyDict_New(); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 608; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (PyDict_SetItem(__pyx_5, __pyx_kp_geographic, __pyx_v_self->geographic) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 608; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_2 = PyEval_CallObjectWithKeywords(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_LineString)), ((PyObject *)__pyx_3), ((PyObject *)__pyx_5)); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 608; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
      Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
      if (!(__Pyx_TypeTest(__pyx_2, __pyx_ptype_6ligeos_9linearref_LineString))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 608; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_2);
      __pyx_2 = 0;
      goto __pyx_L0;
    }
    __pyx_L5:;
    goto __pyx_L3;
  }

  /* "/home/nino/ligeos/ligeos/linearref.pyx":609
 *             else:
 *                 return LineString(l2._pts, self._pts, geographic=self.geographic)
 *         elif bc < bd:             # <<<<<<<<<<<<<<
 *             #print "Case 3", b, c, bc
 *             if bc <= merge_tolerance:
 */
  __pyx_6 = (__pyx_v_bc < __pyx_v_bd);
  if (__pyx_6) {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":611
 *         elif bc < bd:
 *             #print "Case 3", b, c, bc
 *             if bc <= merge_tolerance:             # <<<<<<<<<<<<<<
 *                 return LineString(self._pts, l2._pts[1:], geographic=self.geographic)
 *             else:
 */
    __pyx_6 = (__pyx_v_bc <= __pyx_v_merge_tolerance);
    if (__pyx_6) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":612
 *             #print "Case 3", b, c, bc
 *             if bc <= merge_tolerance:
 *                 return LineString(self._pts, l2._pts[1:], geographic=self.geographic)             # <<<<<<<<<<<<<<
 *             else:
 *                 return LineString(self._pts, l2._pts, geographic=self.geographic)
 */
      __pyx_4 = PySequence_GetSlice(__pyx_v_l2->_pts, 1, PY_SSIZE_T_MAX); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 612; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_1 = PyTuple_New(2); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 612; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(__pyx_v_self->_pts);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self->_pts);
      PyTuple_SET_ITEM(__pyx_1, 1, __pyx_4);
      __pyx_4 = 0;
      __pyx_3 = PyDict_New(); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 612; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (PyDict_SetItem(__pyx_3, __pyx_kp_geographic, __pyx_v_self->geographic) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 612; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_5 = PyEval_CallObjectWithKeywords(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_LineString)), ((PyObject *)__pyx_1), ((PyObject *)__pyx_3)); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 612; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_1)); __pyx_1 = 0;
      Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
      if (!(__Pyx_TypeTest(__pyx_5, __pyx_ptype_6ligeos_9linearref_LineString))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 612; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_5);
      __pyx_5 = 0;
      goto __pyx_L0;
      goto __pyx_L6;
    }
    /*else*/ {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":614
 *                 return LineString(self._pts, l2._pts[1:], geographic=self.geographic)
 *             else:
 *                 return LineString(self._pts, l2._pts, geographic=self.geographic)             # <<<<<<<<<<<<<<
 *         else:
 *             #print "Case 4", b, d, bd
 */
      __pyx_2 = PyTuple_New(2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 614; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(__pyx_v_self->_pts);
      PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self->_pts);
      Py_INCREF(__pyx_v_l2->_pts);
      PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_l2->_pts);
      __pyx_4 = PyDict_New(); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 614; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (PyDict_SetItem(__pyx_4, __pyx_kp_geographic, __pyx_v_self->geographic) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 614; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_1 = PyEval_CallObjectWithKeywords(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_LineString)), ((PyObject *)__pyx_2), ((PyObject *)__pyx_4)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 614; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      Py_DECREF(((PyObject *)__pyx_4)); __pyx_4 = 0;
      if (!(__Pyx_TypeTest(__pyx_1, __pyx_ptype_6ligeos_9linearref_LineString))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 614; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_1);
      __pyx_1 = 0;
      goto __pyx_L0;
    }
    __pyx_L6:;
    goto __pyx_L3;
  }
  /*else*/ {

    /* "/home/nino/ligeos/ligeos/linearref.pyx":617
 *         else:
 *             #print "Case 4", b, d, bd
 *             if bd <= merge_tolerance:             # <<<<<<<<<<<<<<
 *                 return LineString(self._pts, l2._pts[-1:0:-1], geographic=self.geographic)
 *             else:
 */
    __pyx_6 = (__pyx_v_bd <= __pyx_v_merge_tolerance);
    if (__pyx_6) {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":618
 *             #print "Case 4", b, d, bd
 *             if bd <= merge_tolerance:
 *                 return LineString(self._pts, l2._pts[-1:0:-1], geographic=self.geographic)             # <<<<<<<<<<<<<<
 *             else:
 *                 return LineString(self._pts, l2._pts[::-1], geographic=self.geographic)
 */
      __pyx_3 = PySlice_New(__pyx_int_neg_1, __pyx_int_0, __pyx_int_neg_1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 618; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_5 = PyObject_GetItem(__pyx_v_l2->_pts, __pyx_3); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 618; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_2 = PyTuple_New(2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 618; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(__pyx_v_self->_pts);
      PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self->_pts);
      PyTuple_SET_ITEM(__pyx_2, 1, __pyx_5);
      __pyx_5 = 0;
      __pyx_4 = PyDict_New(); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 618; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (PyDict_SetItem(__pyx_4, __pyx_kp_geographic, __pyx_v_self->geographic) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 618; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_1 = PyEval_CallObjectWithKeywords(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_LineString)), ((PyObject *)__pyx_2), ((PyObject *)__pyx_4)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 618; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      Py_DECREF(((PyObject *)__pyx_4)); __pyx_4 = 0;
      if (!(__Pyx_TypeTest(__pyx_1, __pyx_ptype_6ligeos_9linearref_LineString))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 618; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_1);
      __pyx_1 = 0;
      goto __pyx_L0;
      goto __pyx_L7;
    }
    /*else*/ {

      /* "/home/nino/ligeos/ligeos/linearref.pyx":620
 *                 return LineString(self._pts, l2._pts[-1:0:-1], geographic=self.geographic)
 *             else:
 *                 return LineString(self._pts, l2._pts[::-1], geographic=self.geographic)             # <<<<<<<<<<<<<<
 * 
 * 
 */
      __pyx_3 = PySlice_New(Py_None, Py_None, __pyx_int_neg_1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 620; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_5 = PyObject_GetItem(__pyx_v_l2->_pts, __pyx_3); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 620; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_2 = PyTuple_New(2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 620; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_INCREF(__pyx_v_self->_pts);
      PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self->_pts);
      PyTuple_SET_ITEM(__pyx_2, 1, __pyx_5);
      __pyx_5 = 0;
      __pyx_4 = PyDict_New(); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 620; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      if (PyDict_SetItem(__pyx_4, __pyx_kp_geographic, __pyx_v_self->geographic) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 620; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_1 = PyEval_CallObjectWithKeywords(((PyObject *)((PyObject*)__pyx_ptype_6ligeos_9linearref_LineString)), ((PyObject *)__pyx_2), ((PyObject *)__pyx_4)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 620; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
      Py_DECREF(((PyObject *)__pyx_4)); __pyx_4 = 0;
      if (!(__Pyx_TypeTest(__pyx_1, __pyx_ptype_6ligeos_9linearref_LineString))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 620; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_1);
      __pyx_1 = 0;
      goto __pyx_L0;
    }
    __pyx_L7:;
  }
  __pyx_L3:;

  __pyx_r = ((struct __pyx_obj_6ligeos_9linearref_LineString *)Py_None); Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("ligeos.linearref.LineString.concatenate");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_a);
  Py_DECREF(__pyx_v_b);
  Py_DECREF(__pyx_v_c);
  Py_DECREF(__pyx_v_d);
  return __pyx_r;
}

/* "/home/nino/ligeos/ligeos/linearref.pyx":578
 *         return LineString(dpa, geographic=ipa[0].is_geo())
 * 
 *     cpdef LineString concatenate(self, LineString l2, float merge_tolerance=0):             # <<<<<<<<<<<<<<
 *         """Returns true if l2 was joined or None, if the min distance is above the max distance allowed."""
 *         cdef CPoint a, b, c, d
 */

static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_concatenate(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_6ligeos_9linearref_10LineString_concatenate[] = "Returns true if l2 was joined or None, if the min distance is above the max distance allowed.";
static PyObject *__pyx_pf_6ligeos_9linearref_10LineString_concatenate(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_6ligeos_9linearref_LineString *__pyx_v_l2 = 0;
  float __pyx_v_merge_tolerance;
  PyObject *__pyx_r;
  struct __pyx_opt_args_6ligeos_9linearref_10LineString_concatenate __pyx_1;
  PyObject *__pyx_2 = 0;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_11,&__pyx_kp_merge_tolerance,0};
  __pyx_v_merge_tolerance = ((float)0);
  if (unlikely(__pyx_kwds)) {
    PyObject* values[2] = {0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_11);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "concatenate") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 578; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_l2 = ((struct __pyx_obj_6ligeos_9linearref_LineString *)values[0]);
    if (values[1]) {
      __pyx_v_merge_tolerance = __pyx_PyFloat_AsDouble(values[1]); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 578; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
  } else {
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  2: __pyx_v_merge_tolerance = __pyx_PyFloat_AsDouble(PyTuple_GET_ITEM(__pyx_args, 1)); if (unlikely(PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 578; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      case  1: __pyx_v_l2 = ((struct __pyx_obj_6ligeos_9linearref_LineString *)PyTuple_GET_ITEM(__pyx_args, 0));
      break;
      default: goto __pyx_L5_argtuple_error;
    }
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("concatenate", 0, 1, 2, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 578; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("ligeos.linearref.LineString.concatenate");
  return NULL;
  __pyx_L4_argument_unpacking_done:;
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_l2), __pyx_ptype_6ligeos_9linearref_LineString, 1, "l2", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 578; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1.__pyx_n = 1;
  __pyx_1.merge_tolerance = __pyx_v_merge_tolerance;
  __pyx_2 = ((PyObject *)((struct __pyx_vtabstruct_6ligeos_9linearref_LineString *)((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self)->__pyx_vtab)->concatenate(((struct __pyx_obj_6ligeos_9linearref_LineString *)__pyx_v_self), __pyx_v_l2, 1, &__pyx_1)); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 578; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("ligeos.linearref.LineString.concatenate");
  __pyx_r = NULL;
  __pyx_L0:;
  return __pyx_r;
}
static struct __pyx_vtabstruct_6ligeos_9linearref_CPoint __pyx_vtable_6ligeos_9linearref_CPoint;

static PyObject *__pyx_tp_new_6ligeos_9linearref_CPoint(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_6ligeos_9linearref_CPoint *p;
  PyObject *o = (*t->tp_alloc)(t, 0);
  if (!o) return 0;
  p = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)o);
  p->__pyx_vtab = __pyx_vtabptr_6ligeos_9linearref_CPoint;
  p->geo = ((PyObject *)Py_None); Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_6ligeos_9linearref_CPoint(PyObject *o) {
  struct __pyx_obj_6ligeos_9linearref_CPoint *p = (struct __pyx_obj_6ligeos_9linearref_CPoint *)o;
  Py_XDECREF(((PyObject *)p->geo));
  (*Py_TYPE(o)->tp_free)(o);
}

static int __pyx_tp_traverse_6ligeos_9linearref_CPoint(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_6ligeos_9linearref_CPoint *p = (struct __pyx_obj_6ligeos_9linearref_CPoint *)o;
  if (p->geo) {
    e = (*v)(p->geo, a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_6ligeos_9linearref_CPoint(PyObject *o) {
  struct __pyx_obj_6ligeos_9linearref_CPoint *p = (struct __pyx_obj_6ligeos_9linearref_CPoint *)o;
  PyObject* tmp;
  tmp = ((PyObject*)p->geo);
  p->geo = ((PyObject *)Py_None); Py_INCREF(Py_None);
  Py_XDECREF(tmp);
  return 0;
}

static PyObject *__pyx_getprop_6ligeos_9linearref_6CPoint_x(PyObject *o, void *x) {
  return __pyx_pf_6ligeos_9linearref_6CPoint_1x___get__(o);
}

static int __pyx_setprop_6ligeos_9linearref_6CPoint_x(PyObject *o, PyObject *v, void *x) {
  if (v) {
    return __pyx_pf_6ligeos_9linearref_6CPoint_1x___set__(o, v);
  }
  else {
    PyErr_SetString(PyExc_NotImplementedError, "__del__");
    return -1;
  }
}

static PyObject *__pyx_getprop_6ligeos_9linearref_6CPoint_y(PyObject *o, void *x) {
  return __pyx_pf_6ligeos_9linearref_6CPoint_1y___get__(o);
}

static int __pyx_setprop_6ligeos_9linearref_6CPoint_y(PyObject *o, PyObject *v, void *x) {
  if (v) {
    return __pyx_pf_6ligeos_9linearref_6CPoint_1y___set__(o, v);
  }
  else {
    PyErr_SetString(PyExc_NotImplementedError, "__del__");
    return -1;
  }
}

static struct PyMethodDef __pyx_methods_6ligeos_9linearref_CPoint[] = {
  {"__str__", (PyCFunction)__pyx_pf_6ligeos_9linearref_6CPoint___str__, METH_NOARGS|METH_COEXIST, 0},
  {"clone", (PyCFunction)__pyx_pf_6ligeos_9linearref_6CPoint_clone, METH_NOARGS, __pyx_doc_6ligeos_9linearref_6CPoint_clone},
  {"is_geo", (PyCFunction)__pyx_pf_6ligeos_9linearref_6CPoint_is_geo, METH_NOARGS, __pyx_doc_6ligeos_9linearref_6CPoint_is_geo},
  {"distance_pt", (PyCFunction)__pyx_pf_6ligeos_9linearref_6CPoint_distance_pt, METH_O, 0},
  {0, 0, 0, 0}
};

static struct PyGetSetDef __pyx_getsets_6ligeos_9linearref_CPoint[] = {
  {"x", __pyx_getprop_6ligeos_9linearref_6CPoint_x, __pyx_setprop_6ligeos_9linearref_6CPoint_x, 0, 0},
  {"y", __pyx_getprop_6ligeos_9linearref_6CPoint_y, __pyx_setprop_6ligeos_9linearref_6CPoint_y, 0, 0},
  {0, 0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_CPoint = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  #if PY_MAJOR_VERSION < 3
  0, /*nb_divide*/
  #endif
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  #if PY_MAJOR_VERSION < 3
  0, /*nb_coerce*/
  #endif
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  #if PY_MAJOR_VERSION < 3
  0, /*nb_oct*/
  #endif
  #if PY_MAJOR_VERSION < 3
  0, /*nb_hex*/
  #endif
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  #if PY_MAJOR_VERSION < 3
  0, /*nb_inplace_divide*/
  #endif
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if (PY_MAJOR_VERSION >= 3) || (Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX)
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_CPoint = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_CPoint = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_CPoint = {
  #if PY_MAJOR_VERSION < 3
  0, /*bf_getreadbuffer*/
  #endif
  #if PY_MAJOR_VERSION < 3
  0, /*bf_getwritebuffer*/
  #endif
  #if PY_MAJOR_VERSION < 3
  0, /*bf_getsegcount*/
  #endif
  #if PY_MAJOR_VERSION < 3
  0, /*bf_getcharbuffer*/
  #endif
  #if PY_VERSION_HEX >= 0x02060000
  0, /*bf_getbuffer*/
  #endif
  #if PY_VERSION_HEX >= 0x02060000
  0, /*bf_releasebuffer*/
  #endif
};

PyTypeObject __pyx_type_6ligeos_9linearref_CPoint = {
  PyVarObject_HEAD_INIT(0, 0)
  "ligeos.linearref.CPoint", /*tp_name*/
  sizeof(struct __pyx_obj_6ligeos_9linearref_CPoint), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_6ligeos_9linearref_CPoint, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_CPoint, /*tp_as_number*/
  &__pyx_tp_as_sequence_CPoint, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_CPoint, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  __pyx_pf_6ligeos_9linearref_6CPoint___str__, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_CPoint, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_NEWBUFFER|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  " A coordinate pair.  If geo is set, distance_earth will be used in distance calculations.", /*tp_doc*/
  __pyx_tp_traverse_6ligeos_9linearref_CPoint, /*tp_traverse*/
  __pyx_tp_clear_6ligeos_9linearref_CPoint, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_6ligeos_9linearref_CPoint, /*tp_methods*/
  0, /*tp_members*/
  __pyx_getsets_6ligeos_9linearref_CPoint, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_pf_6ligeos_9linearref_6CPoint___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_6ligeos_9linearref_CPoint, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};
static struct __pyx_vtabstruct_6ligeos_9linearref_Line __pyx_vtable_6ligeos_9linearref_Line;

static PyObject *__pyx_tp_new_6ligeos_9linearref_Line(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_6ligeos_9linearref_Line *p;
  PyObject *o = (*t->tp_alloc)(t, 0);
  if (!o) return 0;
  p = ((struct __pyx_obj_6ligeos_9linearref_Line *)o);
  p->__pyx_vtab = __pyx_vtabptr_6ligeos_9linearref_Line;
  p->p1 = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  p->p2 = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_6ligeos_9linearref_Line(PyObject *o) {
  struct __pyx_obj_6ligeos_9linearref_Line *p = (struct __pyx_obj_6ligeos_9linearref_Line *)o;
  Py_XDECREF(((PyObject *)p->p1));
  Py_XDECREF(((PyObject *)p->p2));
  (*Py_TYPE(o)->tp_free)(o);
}

static int __pyx_tp_traverse_6ligeos_9linearref_Line(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_6ligeos_9linearref_Line *p = (struct __pyx_obj_6ligeos_9linearref_Line *)o;
  if (p->p1) {
    e = (*v)(((PyObject*)p->p1), a); if (e) return e;
  }
  if (p->p2) {
    e = (*v)(((PyObject*)p->p2), a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_6ligeos_9linearref_Line(PyObject *o) {
  struct __pyx_obj_6ligeos_9linearref_Line *p = (struct __pyx_obj_6ligeos_9linearref_Line *)o;
  PyObject* tmp;
  tmp = ((PyObject*)p->p1);
  p->p1 = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  Py_XDECREF(tmp);
  tmp = ((PyObject*)p->p2);
  p->p2 = ((struct __pyx_obj_6ligeos_9linearref_CPoint *)Py_None); Py_INCREF(Py_None);
  Py_XDECREF(tmp);
  return 0;
}

static struct PyMethodDef __pyx_methods_6ligeos_9linearref_Line[] = {
  {"__str__", (PyCFunction)__pyx_pf_6ligeos_9linearref_4Line___str__, METH_NOARGS|METH_COEXIST, 0},
  {"length", (PyCFunction)__pyx_pf_6ligeos_9linearref_4Line_length, METH_NOARGS, __pyx_doc_6ligeos_9linearref_4Line_length},
  {"closest_pt", (PyCFunction)__pyx_pf_6ligeos_9linearref_4Line_closest_pt, METH_O, __pyx_doc_6ligeos_9linearref_4Line_closest_pt},
  {"distance_pt", (PyCFunction)__pyx_pf_6ligeos_9linearref_4Line_distance_pt, METH_O, __pyx_doc_6ligeos_9linearref_4Line_distance_pt},
  {"distance_seg", (PyCFunction)__pyx_pf_6ligeos_9linearref_4Line_distance_seg, METH_O, __pyx_doc_6ligeos_9linearref_4Line_distance_seg},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_Line = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  #if PY_MAJOR_VERSION < 3
  0, /*nb_divide*/
  #endif
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  #if PY_MAJOR_VERSION < 3
  0, /*nb_coerce*/
  #endif
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  #if PY_MAJOR_VERSION < 3
  0, /*nb_oct*/
  #endif
  #if PY_MAJOR_VERSION < 3
  0, /*nb_hex*/
  #endif
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  #if PY_MAJOR_VERSION < 3
  0, /*nb_inplace_divide*/
  #endif
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if (PY_MAJOR_VERSION >= 3) || (Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX)
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_Line = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_Line = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_Line = {
  #if PY_MAJOR_VERSION < 3
  0, /*bf_getreadbuffer*/
  #endif
  #if PY_MAJOR_VERSION < 3
  0, /*bf_getwritebuffer*/
  #endif
  #if PY_MAJOR_VERSION < 3
  0, /*bf_getsegcount*/
  #endif
  #if PY_MAJOR_VERSION < 3
  0, /*bf_getcharbuffer*/
  #endif
  #if PY_VERSION_HEX >= 0x02060000
  0, /*bf_getbuffer*/
  #endif
  #if PY_VERSION_HEX >= 0x02060000
  0, /*bf_releasebuffer*/
  #endif
};

PyTypeObject __pyx_type_6ligeos_9linearref_Line = {
  PyVarObject_HEAD_INIT(0, 0)
  "ligeos.linearref.Line", /*tp_name*/
  sizeof(struct __pyx_obj_6ligeos_9linearref_Line), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_6ligeos_9linearref_Line, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_Line, /*tp_as_number*/
  &__pyx_tp_as_sequence_Line, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_Line, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  __pyx_pf_6ligeos_9linearref_4Line___str__, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_Line, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_NEWBUFFER|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  " A line as defined by two points.", /*tp_doc*/
  __pyx_tp_traverse_6ligeos_9linearref_Line, /*tp_traverse*/
  __pyx_tp_clear_6ligeos_9linearref_Line, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_6ligeos_9linearref_Line, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_pf_6ligeos_9linearref_4Line___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_6ligeos_9linearref_Line, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};
static struct __pyx_vtabstruct_6ligeos_9linearref_LineString __pyx_vtable_6ligeos_9linearref_LineString;

static PyObject *__pyx_tp_new_6ligeos_9linearref_LineString(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_6ligeos_9linearref_LineString *p;
  PyObject *o = (*t->tp_alloc)(t, 0);
  if (!o) return 0;
  p = ((struct __pyx_obj_6ligeos_9linearref_LineString *)o);
  p->__pyx_vtab = __pyx_vtabptr_6ligeos_9linearref_LineString;
  p->_pts = Py_None; Py_INCREF(Py_None);
  p->geographic = Py_None; Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_6ligeos_9linearref_LineString(PyObject *o) {
  struct __pyx_obj_6ligeos_9linearref_LineString *p = (struct __pyx_obj_6ligeos_9linearref_LineString *)o;
  Py_XDECREF(p->_pts);
  Py_XDECREF(p->geographic);
  (*Py_TYPE(o)->tp_free)(o);
}

static int __pyx_tp_traverse_6ligeos_9linearref_LineString(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_6ligeos_9linearref_LineString *p = (struct __pyx_obj_6ligeos_9linearref_LineString *)o;
  if (p->_pts) {
    e = (*v)(p->_pts, a); if (e) return e;
  }
  if (p->geographic) {
    e = (*v)(p->geographic, a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_6ligeos_9linearref_LineString(PyObject *o) {
  struct __pyx_obj_6ligeos_9linearref_LineString *p = (struct __pyx_obj_6ligeos_9linearref_LineString *)o;
  PyObject* tmp;
  tmp = ((PyObject*)p->_pts);
  p->_pts = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(tmp);
  tmp = ((PyObject*)p->geographic);
  p->geographic = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(tmp);
  return 0;
}

static PyObject *__pyx_getprop_6ligeos_9linearref_10LineString_pts(PyObject *o, void *x) {
  return __pyx_pf_6ligeos_9linearref_10LineString_3pts___get__(o);
}

static PyObject *__pyx_getprop_6ligeos_9linearref_10LineString_coords(PyObject *o, void *x) {
  return __pyx_pf_6ligeos_9linearref_10LineString_6coords___get__(o);
}

static struct PyMethodDef __pyx_methods_6ligeos_9linearref_LineString[] = {
  {"__str__", (PyCFunction)__pyx_pf_6ligeos_9linearref_10LineString___str__, METH_NOARGS|METH_COEXIST, 0},
  {"length", (PyCFunction)__pyx_pf_6ligeos_9linearref_10LineString_length, METH_NOARGS, __pyx_doc_6ligeos_9linearref_10LineString_length},
  {"closest_pt", (PyCFunction)__pyx_pf_6ligeos_9linearref_10LineString_closest_pt, METH_O, __pyx_doc_6ligeos_9linearref_10LineString_closest_pt},
  {"distance_pt", (PyCFunction)__pyx_pf_6ligeos_9linearref_10LineString_distance_pt, METH_O, __pyx_doc_6ligeos_9linearref_10LineString_distance_pt},
  {"closest_pt_to_line", (PyCFunction)__pyx_pf_6ligeos_9linearref_10LineString_closest_pt_to_line, METH_O, __pyx_doc_6ligeos_9linearref_10LineString_closest_pt_to_line},
  {"distance_to_line", (PyCFunction)__pyx_pf_6ligeos_9linearref_10LineString_distance_to_line, METH_O, __pyx_doc_6ligeos_9linearref_10LineString_distance_to_line},
  {"locate_point", (PyCFunction)__pyx_pf_6ligeos_9linearref_10LineString_locate_point, METH_O, __pyx_doc_6ligeos_9linearref_10LineString_locate_point},
  {"substring", (PyCFunction)__pyx_pf_6ligeos_9linearref_10LineString_substring, METH_VARARGS|METH_KEYWORDS, __pyx_doc_6ligeos_9linearref_10LineString_substring},
  {"concatenate", (PyCFunction)__pyx_pf_6ligeos_9linearref_10LineString_concatenate, METH_VARARGS|METH_KEYWORDS, __pyx_doc_6ligeos_9linearref_10LineString_concatenate},
  {0, 0, 0, 0}
};

static struct PyGetSetDef __pyx_getsets_6ligeos_9linearref_LineString[] = {
  {"pts", __pyx_getprop_6ligeos_9linearref_10LineString_pts, 0, 0, 0},
  {"coords", __pyx_getprop_6ligeos_9linearref_10LineString_coords, 0, 0, 0},
  {0, 0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_LineString = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  #if PY_MAJOR_VERSION < 3
  0, /*nb_divide*/
  #endif
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  #if PY_MAJOR_VERSION < 3
  0, /*nb_coerce*/
  #endif
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  #if PY_MAJOR_VERSION < 3
  0, /*nb_oct*/
  #endif
  #if PY_MAJOR_VERSION < 3
  0, /*nb_hex*/
  #endif
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  #if PY_MAJOR_VERSION < 3
  0, /*nb_inplace_divide*/
  #endif
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if (PY_MAJOR_VERSION >= 3) || (Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX)
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_LineString = {
  __pyx_pf_6ligeos_9linearref_10LineString___len__, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_LineString = {
  __pyx_pf_6ligeos_9linearref_10LineString___len__, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_LineString = {
  #if PY_MAJOR_VERSION < 3
  0, /*bf_getreadbuffer*/
  #endif
  #if PY_MAJOR_VERSION < 3
  0, /*bf_getwritebuffer*/
  #endif
  #if PY_MAJOR_VERSION < 3
  0, /*bf_getsegcount*/
  #endif
  #if PY_MAJOR_VERSION < 3
  0, /*bf_getcharbuffer*/
  #endif
  #if PY_VERSION_HEX >= 0x02060000
  0, /*bf_getbuffer*/
  #endif
  #if PY_VERSION_HEX >= 0x02060000
  0, /*bf_releasebuffer*/
  #endif
};

PyTypeObject __pyx_type_6ligeos_9linearref_LineString = {
  PyVarObject_HEAD_INIT(0, 0)
  "ligeos.linearref.LineString", /*tp_name*/
  sizeof(struct __pyx_obj_6ligeos_9linearref_LineString), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_6ligeos_9linearref_LineString, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_LineString, /*tp_as_number*/
  &__pyx_tp_as_sequence_LineString, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_LineString, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  __pyx_pf_6ligeos_9linearref_10LineString___str__, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_LineString, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_NEWBUFFER|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  "A sequence of points that define a linestring.", /*tp_doc*/
  __pyx_tp_traverse_6ligeos_9linearref_LineString, /*tp_traverse*/
  __pyx_tp_clear_6ligeos_9linearref_LineString, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_6ligeos_9linearref_LineString, /*tp_methods*/
  0, /*tp_members*/
  __pyx_getsets_6ligeos_9linearref_LineString, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_pf_6ligeos_9linearref_10LineString___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_6ligeos_9linearref_LineString, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static struct PyMethodDef __pyx_methods[] = {
  {"distance_earth", (PyCFunction)__pyx_pf_6ligeos_9linearref_distance_earth, METH_VARARGS|METH_KEYWORDS, __pyx_doc_6ligeos_9linearref_distance_earth},
  {"vincenty", (PyCFunction)__pyx_pf_6ligeos_9linearref_vincenty, METH_VARARGS|METH_KEYWORDS, __pyx_doc_6ligeos_9linearref_vincenty},
  {"Point", (PyCFunction)__pyx_pf_6ligeos_9linearref_Point, METH_VARARGS|METH_KEYWORDS, __pyx_doc_6ligeos_9linearref_Point},
  {"GPoint", (PyCFunction)__pyx_pf_6ligeos_9linearref_GPoint, METH_VARARGS|METH_KEYWORDS, __pyx_doc_6ligeos_9linearref_GPoint},
  {"seg_intersect_seg", (PyCFunction)__pyx_pf_6ligeos_9linearref_seg_intersect_seg, METH_VARARGS|METH_KEYWORDS, 0},
  {"seg_distance_seg", (PyCFunction)__pyx_pf_6ligeos_9linearref_seg_distance_seg, METH_VARARGS|METH_KEYWORDS, __pyx_doc_6ligeos_9linearref_seg_distance_seg},
  {"seg_distance_pt", (PyCFunction)__pyx_pf_6ligeos_9linearref_seg_distance_pt, METH_VARARGS|METH_KEYWORDS, __pyx_doc_6ligeos_9linearref_seg_distance_pt},
  {"seg_closest_pt", (PyCFunction)__pyx_pf_6ligeos_9linearref_seg_closest_pt, METH_VARARGS|METH_KEYWORDS, __pyx_doc_6ligeos_9linearref_seg_closest_pt},
  {0, 0, 0, 0}
};

static void __pyx_init_filenames(void); /*proto*/

#if PY_MAJOR_VERSION >= 3
static struct PyModuleDef __pyx_moduledef = {
    PyModuleDef_HEAD_INIT,
    "linearref",
    __pyx_mdoc, /* m_doc */
    -1, /* m_size */
    __pyx_methods /* m_methods */,
    NULL, /* m_reload */
    NULL, /* m_traverse */
    NULL, /* m_clear */
    NULL /* m_free */
};
#endif

static __Pyx_StringTabEntry __pyx_string_tab[] = {
  {&__pyx_kp_distance_earth, __pyx_k_distance_earth, sizeof(__pyx_k_distance_earth), 1, 1, 1},
  {&__pyx_kp_vincenty, __pyx_k_vincenty, sizeof(__pyx_k_vincenty), 1, 1, 1},
  {&__pyx_kp___init__, __pyx_k___init__, sizeof(__pyx_k___init__), 1, 1, 1},
  {&__pyx_kp___str__, __pyx_k___str__, sizeof(__pyx_k___str__), 1, 1, 1},
  {&__pyx_kp_clone, __pyx_k_clone, sizeof(__pyx_k_clone), 1, 1, 1},
  {&__pyx_kp_is_geo, __pyx_k_is_geo, sizeof(__pyx_k_is_geo), 1, 1, 1},
  {&__pyx_kp_distance_pt, __pyx_k_distance_pt, sizeof(__pyx_k_distance_pt), 1, 1, 1},
  {&__pyx_kp_length, __pyx_k_length, sizeof(__pyx_k_length), 1, 1, 1},
  {&__pyx_kp_closest_pt, __pyx_k_closest_pt, sizeof(__pyx_k_closest_pt), 1, 1, 1},
  {&__pyx_kp_distance_seg, __pyx_k_distance_seg, sizeof(__pyx_k_distance_seg), 1, 1, 1},
  {&__pyx_kp_seg_intersect_seg, __pyx_k_seg_intersect_seg, sizeof(__pyx_k_seg_intersect_seg), 1, 1, 1},
  {&__pyx_kp_seg_distance_seg, __pyx_k_seg_distance_seg, sizeof(__pyx_k_seg_distance_seg), 1, 1, 1},
  {&__pyx_kp_seg_distance_pt, __pyx_k_seg_distance_pt, sizeof(__pyx_k_seg_distance_pt), 1, 1, 1},
  {&__pyx_kp_seg_closest_pt, __pyx_k_seg_closest_pt, sizeof(__pyx_k_seg_closest_pt), 1, 1, 1},
  {&__pyx_kp___len__, __pyx_k___len__, sizeof(__pyx_k___len__), 1, 1, 1},
  {&__pyx_kp_closest_pt_to_line, __pyx_k_closest_pt_to_line, sizeof(__pyx_k_closest_pt_to_line), 1, 1, 1},
  {&__pyx_kp_distance_to_line, __pyx_k_distance_to_line, sizeof(__pyx_k_distance_to_line), 1, 1, 1},
  {&__pyx_kp_locate_point, __pyx_k_locate_point, sizeof(__pyx_k_locate_point), 1, 1, 1},
  {&__pyx_kp_substring, __pyx_k_substring, sizeof(__pyx_k_substring), 1, 1, 1},
  {&__pyx_kp_concatenate, __pyx_k_concatenate, sizeof(__pyx_k_concatenate), 1, 1, 1},
  {&__pyx_kp_1, __pyx_k_1, sizeof(__pyx_k_1), 1, 1, 1},
  {&__pyx_kp_2, __pyx_k_2, sizeof(__pyx_k_2), 1, 1, 1},
  {&__pyx_kp_3, __pyx_k_3, sizeof(__pyx_k_3), 1, 1, 1},
  {&__pyx_kp_4, __pyx_k_4, sizeof(__pyx_k_4), 1, 1, 1},
  {&__pyx_kp_5, __pyx_k_5, sizeof(__pyx_k_5), 1, 1, 1},
  {&__pyx_kp_6, __pyx_k_6, sizeof(__pyx_k_6), 1, 1, 1},
  {&__pyx_kp_7, __pyx_k_7, sizeof(__pyx_k_7), 1, 1, 1},
  {&__pyx_kp_8, __pyx_k_8, sizeof(__pyx_k_8), 1, 1, 1},
  {&__pyx_kp_x, __pyx_k_x, sizeof(__pyx_k_x), 1, 1, 1},
  {&__pyx_kp_y, __pyx_k_y, sizeof(__pyx_k_y), 1, 1, 1},
  {&__pyx_kp_geo, __pyx_k_geo, sizeof(__pyx_k_geo), 1, 1, 1},
  {&__pyx_kp_v, __pyx_k_v, sizeof(__pyx_k_v), 1, 1, 1},
  {&__pyx_kp_9, __pyx_k_9, sizeof(__pyx_k_9), 1, 1, 1},
  {&__pyx_kp_10, __pyx_k_10, sizeof(__pyx_k_10), 1, 1, 1},
  {&__pyx_kp_p, __pyx_k_p, sizeof(__pyx_k_p), 1, 1, 1},
  {&__pyx_kp_s, __pyx_k_s, sizeof(__pyx_k_s), 1, 1, 1},
  {&__pyx_kp_a, __pyx_k_a, sizeof(__pyx_k_a), 1, 1, 1},
  {&__pyx_kp_b, __pyx_k_b, sizeof(__pyx_k_b), 1, 1, 1},
  {&__pyx_kp_c, __pyx_k_c, sizeof(__pyx_k_c), 1, 1, 1},
  {&__pyx_kp_d, __pyx_k_d, sizeof(__pyx_k_d), 1, 1, 1},
  {&__pyx_kp_geographic, __pyx_k_geographic, sizeof(__pyx_k_geographic), 1, 1, 1},
  {&__pyx_kp_11, __pyx_k_11, sizeof(__pyx_k_11), 1, 1, 1},
  {&__pyx_kp_frm, __pyx_k_frm, sizeof(__pyx_k_frm), 1, 1, 1},
  {&__pyx_kp_to, __pyx_k_to, sizeof(__pyx_k_to), 1, 1, 1},
  {&__pyx_kp_merge_tolerance, __pyx_k_merge_tolerance, sizeof(__pyx_k_merge_tolerance), 1, 1, 1},
  {&__pyx_kp_ArgumentError, __pyx_k_ArgumentError, sizeof(__pyx_k_ArgumentError), 0, 1, 1},
  {&__pyx_kp_Exception, __pyx_k_Exception, sizeof(__pyx_k_Exception), 1, 1, 1},
  {&__pyx_kp_min, __pyx_k_min, sizeof(__pyx_k_min), 1, 1, 1},
  {&__pyx_kp_15, __pyx_k_15, sizeof(__pyx_k_15), 0, 1, 0},
  {&__pyx_kp_16, __pyx_k_16, sizeof(__pyx_k_16), 0, 1, 0},
  {&__pyx_kp_TypeError, __pyx_k_TypeError, sizeof(__pyx_k_TypeError), 1, 1, 1},
  {&__pyx_kp_extend, __pyx_k_extend, sizeof(__pyx_k_extend), 1, 1, 1},
  {&__pyx_kp_append, __pyx_k_append, sizeof(__pyx_k_append), 1, 1, 1},
  {&__pyx_kp_join, __pyx_k_join, sizeof(__pyx_k_join), 1, 1, 1},
  {&__pyx_kp_map, __pyx_k_map, sizeof(__pyx_k_map), 1, 1, 1},
  {&__pyx_kp_sum, __pyx_k_sum, sizeof(__pyx_k_sum), 1, 1, 1},
  {&__pyx_kp_range, __pyx_k_range, sizeof(__pyx_k_range), 1, 1, 1},
  {&__pyx_kp_13, __pyx_k_13, sizeof(__pyx_k_13), 0, 0, 0},
  {&__pyx_kp_14, __pyx_k_14, sizeof(__pyx_k_14), 0, 0, 0},
  {&__pyx_kp_17, __pyx_k_17, sizeof(__pyx_k_17), 0, 0, 0},
  {&__pyx_kp_18, __pyx_k_18, sizeof(__pyx_k_18), 0, 0, 0},
  {&__pyx_kp_20, __pyx_k_20, sizeof(__pyx_k_20), 0, 0, 0},
  {&__pyx_kp_19, __pyx_k_19, sizeof(__pyx_k_19), 0, 0, 0},
  {&__pyx_kp_21, __pyx_k_21, sizeof(__pyx_k_21), 0, 0, 0},
  {&__pyx_kp_22, __pyx_k_22, sizeof(__pyx_k_22), 0, 0, 0},
  {&__pyx_kp_23, __pyx_k_23, sizeof(__pyx_k_23), 0, 0, 0},
  {0, 0, 0, 0, 0, 0}
};
static int __Pyx_InitCachedBuiltins(void) {
  __pyx_builtin_Exception = __Pyx_GetName(__pyx_b, __pyx_kp_Exception); if (!__pyx_builtin_Exception) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 623; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_builtin_min = __Pyx_GetName(__pyx_b, __pyx_kp_min); if (!__pyx_builtin_min) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 254; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_builtin_TypeError = __Pyx_GetName(__pyx_b, __pyx_kp_TypeError); if (!__pyx_builtin_TypeError) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 320; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_builtin_map = __Pyx_GetName(__pyx_b, __pyx_kp_map); if (!__pyx_builtin_map) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 349; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_builtin_sum = __Pyx_GetName(__pyx_b, __pyx_kp_sum); if (!__pyx_builtin_sum) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_builtin_range = __Pyx_GetName(__pyx_b, __pyx_kp_range); if (!__pyx_builtin_range) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  return 0;
  __pyx_L1_error:;
  return -1;
}

static int __Pyx_InitGlobals(void) {
  __pyx_int_0 = PyInt_FromLong(0); if (unlikely(!__pyx_int_0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  __pyx_int_1 = PyInt_FromLong(1); if (unlikely(!__pyx_int_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  __pyx_int_neg_1 = PyInt_FromLong(-1); if (unlikely(!__pyx_int_neg_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  if (__Pyx_InitStrings(__pyx_string_tab) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  return 0;
  __pyx_L1_error:;
  return -1;
}

#if PY_MAJOR_VERSION < 3
PyMODINIT_FUNC initlinearref(void); /*proto*/
PyMODINIT_FUNC initlinearref(void)
#else
PyMODINIT_FUNC PyInit_linearref(void); /*proto*/
PyMODINIT_FUNC PyInit_linearref(void)
#endif
{
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  __pyx_empty_tuple = PyTuple_New(0); if (unlikely(!__pyx_empty_tuple)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  /*--- Library function declarations ---*/
  __pyx_init_filenames();
  /*--- Initialize various global constants etc. ---*/
  if (unlikely(__Pyx_InitGlobals() < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  /*--- Module creation code ---*/
  #if PY_MAJOR_VERSION < 3
  __pyx_m = Py_InitModule4("linearref", __pyx_methods, __pyx_mdoc, 0, PYTHON_API_VERSION);
  #else
  __pyx_m = PyModule_Create(&__pyx_moduledef);
  #endif
  if (!__pyx_m) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  #if PY_MAJOR_VERSION < 3
  Py_INCREF(__pyx_m);
  #endif
  __pyx_b = PyImport_AddModule(__Pyx_BUILTIN_MODULE_NAME);
  if (!__pyx_b) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  if (PyObject_SetAttrString(__pyx_m, "__builtins__", __pyx_b) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  /*--- Builtin init code ---*/
  if (unlikely(__Pyx_InitCachedBuiltins() < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_skip_dispatch = 0;
  /*--- Global init code ---*/
  /*--- Function export code ---*/
  /*--- Type init code ---*/
  __pyx_vtabptr_6ligeos_9linearref_CPoint = &__pyx_vtable_6ligeos_9linearref_CPoint;
  *(void(**)(void))&__pyx_vtable_6ligeos_9linearref_CPoint.distance_pt = (void(*)(void))__pyx_f_6ligeos_9linearref_6CPoint_distance_pt;
  if (PyType_Ready(&__pyx_type_6ligeos_9linearref_CPoint) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 107; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (__Pyx_SetVtable(__pyx_type_6ligeos_9linearref_CPoint.tp_dict, __pyx_vtabptr_6ligeos_9linearref_CPoint) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 107; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (PyObject_SetAttrString(__pyx_m, "CPoint", (PyObject *)&__pyx_type_6ligeos_9linearref_CPoint) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 107; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_ptype_6ligeos_9linearref_CPoint = &__pyx_type_6ligeos_9linearref_CPoint;
  __pyx_vtabptr_6ligeos_9linearref_Line = &__pyx_vtable_6ligeos_9linearref_Line;
  *(void(**)(void))&__pyx_vtable_6ligeos_9linearref_Line.length = (void(*)(void))__pyx_f_6ligeos_9linearref_4Line_length;
  *(void(**)(void))&__pyx_vtable_6ligeos_9linearref_Line.closest_pt = (void(*)(void))__pyx_f_6ligeos_9linearref_4Line_closest_pt;
  *(void(**)(void))&__pyx_vtable_6ligeos_9linearref_Line.distance_pt = (void(*)(void))__pyx_f_6ligeos_9linearref_4Line_distance_pt;
  *(void(**)(void))&__pyx_vtable_6ligeos_9linearref_Line.distance_seg = (void(*)(void))__pyx_f_6ligeos_9linearref_4Line_distance_seg;
  if (PyType_Ready(&__pyx_type_6ligeos_9linearref_Line) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 157; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (__Pyx_SetVtable(__pyx_type_6ligeos_9linearref_Line.tp_dict, __pyx_vtabptr_6ligeos_9linearref_Line) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 157; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (PyObject_SetAttrString(__pyx_m, "Line", (PyObject *)&__pyx_type_6ligeos_9linearref_Line) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 157; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_ptype_6ligeos_9linearref_Line = &__pyx_type_6ligeos_9linearref_Line;
  __pyx_vtabptr_6ligeos_9linearref_LineString = &__pyx_vtable_6ligeos_9linearref_LineString;
  *(void(**)(void))&__pyx_vtable_6ligeos_9linearref_LineString.closest_pt = (void(*)(void))__pyx_f_6ligeos_9linearref_10LineString_closest_pt;
  *(void(**)(void))&__pyx_vtable_6ligeos_9linearref_LineString.distance_pt = (void(*)(void))__pyx_f_6ligeos_9linearref_10LineString_distance_pt;
  *(void(**)(void))&__pyx_vtable_6ligeos_9linearref_LineString.closest_pt_to_line = (void(*)(void))__pyx_f_6ligeos_9linearref_10LineString_closest_pt_to_line;
  *(void(**)(void))&__pyx_vtable_6ligeos_9linearref_LineString.distance_to_line = (void(*)(void))__pyx_f_6ligeos_9linearref_10LineString_distance_to_line;
  *(void(**)(void))&__pyx_vtable_6ligeos_9linearref_LineString.locate_point = (void(*)(void))__pyx_f_6ligeos_9linearref_10LineString_locate_point;
  *(void(**)(void))&__pyx_vtable_6ligeos_9linearref_LineString.substring = (void(*)(void))__pyx_f_6ligeos_9linearref_10LineString_substring;
  *(void(**)(void))&__pyx_vtable_6ligeos_9linearref_LineString.concatenate = (void(*)(void))__pyx_f_6ligeos_9linearref_10LineString_concatenate;
  if (PyType_Ready(&__pyx_type_6ligeos_9linearref_LineString) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 322; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (__Pyx_SetVtable(__pyx_type_6ligeos_9linearref_LineString.tp_dict, __pyx_vtabptr_6ligeos_9linearref_LineString) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 322; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (PyObject_SetAttrString(__pyx_m, "LineString", (PyObject *)&__pyx_type_6ligeos_9linearref_LineString) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 322; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_ptype_6ligeos_9linearref_LineString = &__pyx_type_6ligeos_9linearref_LineString;
  /*--- Type import code ---*/
  /*--- Function import code ---*/
  /*--- Execution code ---*/

  /* "/home/nino/ligeos/ligeos/linearref.pyx":326
 *     cdef object _pts
 *     cdef object geographic # cant be a bool, because cython chokes on it.
 *     def __init__(self, *args, geographic=False):             # <<<<<<<<<<<<<<
 *         self._pts = []
 *         self.geographic = bool(geographic) == True
 */
  __pyx_1 = __Pyx_PyBool_FromLong(0); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 326; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_k_12 = __pyx_1;
  __pyx_1 = 0;

  /* "/home/nino/ligeos/ligeos/linearref.pyx":623
 * 
 * 
 * class ArgumentError(Exception):             # <<<<<<<<<<<<<<
 *     pass
 */
  __pyx_2 = PyDict_New(); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 623; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 623; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_builtin_Exception);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_builtin_Exception);
  __pyx_4 = __Pyx_CreateClass(((PyObject *)__pyx_3), ((PyObject *)__pyx_2), __pyx_kp_ArgumentError, "ligeos.linearref"); if (unlikely(!__pyx_4)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 623; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
  if (PyObject_SetAttr(__pyx_m, __pyx_kp_ArgumentError, __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 623; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  #if PY_MAJOR_VERSION < 3
  return;
  #else
  return __pyx_m;
  #endif
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("ligeos.linearref");
  #if PY_MAJOR_VERSION >= 3
  return NULL;
  #endif
}

static const char *__pyx_filenames[] = {
  "linearref.pyx",
};

/* Runtime support code */

static void __pyx_init_filenames(void) {
  __pyx_f = __pyx_filenames;
}

static void __Pyx_RaiseDoubleKeywordsError(
    const char* func_name,
    PyObject* kw_name)
{
    PyErr_Format(PyExc_TypeError,
        #if PY_MAJOR_VERSION >= 3
        "%s() got multiple values for keyword argument '%U'", func_name, kw_name);
        #else
        "%s() got multiple values for keyword argument '%s'", func_name,
        PyString_AS_STRING(kw_name));
        #endif
}

static void __Pyx_RaiseArgtupleInvalid(
    const char* func_name,
    int exact,
    Py_ssize_t num_min,
    Py_ssize_t num_max,
    Py_ssize_t num_found)
{
    Py_ssize_t num_expected;
    const char *number, *more_or_less;

    if (num_found < num_min) {
        num_expected = num_min;
        more_or_less = "at least";
    } else {
        num_expected = num_max;
        more_or_less = "at most";
    }
    if (exact) {
        more_or_less = "exactly";
    }
    number = (num_expected == 1) ? "" : "s";
    PyErr_Format(PyExc_TypeError,
        #if PY_VERSION_HEX < 0x02050000
            "%s() takes %s %d positional argument%s (%d given)",
        #else
            "%s() takes %s %zd positional argument%s (%zd given)",
        #endif
        func_name, more_or_less, num_expected, number, num_found);
}

static int __Pyx_ParseOptionalKeywords(
    PyObject *kwds,
    PyObject **argnames[],
    PyObject *kwds2,
    PyObject *values[],
    Py_ssize_t num_pos_args,
    const char* function_name)
{
    PyObject *key = 0, *value = 0;
    Py_ssize_t pos = 0;
    PyObject*** name;
    PyObject*** first_kw_arg = argnames + num_pos_args;

    while (PyDict_Next(kwds, &pos, &key, &value)) {
        #if PY_MAJOR_VERSION < 3
        if (unlikely(!PyString_CheckExact(key)) && unlikely(!PyString_Check(key))) {
        #else
        if (unlikely(!PyUnicode_CheckExact(key)) && unlikely(!PyUnicode_Check(key))) {
        #endif
            goto invalid_keyword_type;
        } else {
            name = argnames;
            while (*name && (**name != key)) name++;
            if (*name) {
                if (name < first_kw_arg) goto arg_passed_twice;
                values[name-argnames] = value;
            } else {
                for (name = first_kw_arg; *name; name++) {
                    #if PY_MAJOR_VERSION >= 3
                    if (PyUnicode_GET_SIZE(**name) == PyUnicode_GET_SIZE(key) &&
                        PyUnicode_Compare(**name, key) == 0) break;
                    #else
                    if (PyString_GET_SIZE(**name) == PyString_GET_SIZE(key) &&
                        strcmp(PyString_AS_STRING(**name),
                               PyString_AS_STRING(key)) == 0) break;
                    #endif
                }
                if (*name) {
                    values[name-argnames] = value;
                } else {
                    /* unexpected keyword found */
                    for (name=argnames; name != first_kw_arg; name++) {
                        if (**name == key) goto arg_passed_twice;
                        #if PY_MAJOR_VERSION >= 3
                        if (PyUnicode_GET_SIZE(**name) == PyUnicode_GET_SIZE(key) &&
                            PyUnicode_Compare(**name, key) == 0) goto arg_passed_twice;
                        #else
                        if (PyString_GET_SIZE(**name) == PyString_GET_SIZE(key) &&
                            strcmp(PyString_AS_STRING(**name),
                                   PyString_AS_STRING(key)) == 0) goto arg_passed_twice;
                        #endif
                    }
                    if (kwds2) {
                        if (unlikely(PyDict_SetItem(kwds2, key, value))) goto bad;
                    } else {
                        goto invalid_keyword;
                    }
                }
            }
        }
    }
    return 0;
arg_passed_twice:
    __Pyx_RaiseDoubleKeywordsError(function_name, **name);
    goto bad;
invalid_keyword_type:
    PyErr_Format(PyExc_TypeError,
        "%s() keywords must be strings", function_name);
    goto bad;
invalid_keyword:
    PyErr_Format(PyExc_TypeError,
    #if PY_MAJOR_VERSION < 3
        "%s() got an unexpected keyword argument '%s'",
        function_name, PyString_AsString(key));
    #else
        "%s() got an unexpected keyword argument '%U'",
        function_name, key);
    #endif
bad:
    return -1;
}


static int __Pyx_ArgTypeTest(PyObject *obj, PyTypeObject *type, int none_allowed,
    const char *name, int exact)
{
    if (!type) {
        PyErr_Format(PyExc_SystemError, "Missing type object");
        return 0;
    }
    if (none_allowed && obj == Py_None) return 1;
    else if (exact) {
        if (Py_TYPE(obj) == type) return 1;
    }
    else {
        if (PyObject_TypeCheck(obj, type)) return 1;
    }
    PyErr_Format(PyExc_TypeError,
        "Argument '%s' has incorrect type (expected %s, got %s)",
        name, type->tp_name, Py_TYPE(obj)->tp_name);
    return 0;
}

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name) {
    PyObject *result;
    result = PyObject_GetAttr(dict, name);
    if (!result)
        PyErr_SetObject(PyExc_NameError, name);
    return result;
}

static PyObject *__Pyx_CreateClass(
    PyObject *bases, PyObject *dict, PyObject *name, char *modname)
{
    PyObject *py_modname;
    PyObject *result = 0;

    #if PY_MAJOR_VERSION < 3
    py_modname = PyString_FromString(modname);
    #else
    py_modname = PyUnicode_FromString(modname);
    #endif
    if (!py_modname)
        goto bad;
    if (PyDict_SetItemString(dict, "__module__", py_modname) < 0)
        goto bad;
    #if PY_MAJOR_VERSION < 3
    result = PyClass_New(bases, dict, name);
    #else
    result = PyObject_CallFunctionObjArgs((PyObject *)&PyType_Type, name, bases, dict, NULL);
    #endif
bad:
    Py_XDECREF(py_modname);
    return result;
}

static int __Pyx_TypeTest(PyObject *obj, PyTypeObject *type) {
    if (!type) {
        PyErr_Format(PyExc_SystemError, "Missing type object");
        return 0;
    }
    if (obj == Py_None || PyObject_TypeCheck(obj, type))
        return 1;
    PyErr_Format(PyExc_TypeError, "Cannot convert %s to %s",
        Py_TYPE(obj)->tp_name, type->tp_name);
    return 0;
}

static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb) {
    Py_XINCREF(type);
    Py_XINCREF(value);
    Py_XINCREF(tb);
    /* First, check the traceback argument, replacing None with NULL. */
    if (tb == Py_None) {
        Py_DECREF(tb);
        tb = 0;
    }
    else if (tb != NULL && !PyTraceBack_Check(tb)) {
        PyErr_SetString(PyExc_TypeError,
            "raise: arg 3 must be a traceback or None");
        goto raise_error;
    }
    /* Next, replace a missing value with None */
    if (value == NULL) {
        value = Py_None;
        Py_INCREF(value);
    }
    #if PY_VERSION_HEX < 0x02050000
    if (!PyClass_Check(type))
    #else
    if (!PyType_Check(type))
    #endif
    {
        /* Raising an instance.  The value should be a dummy. */
        if (value != Py_None) {
            PyErr_SetString(PyExc_TypeError,
                "instance exception may not have a separate value");
            goto raise_error;
        }
        /* Normalize to raise <class>, <instance> */
        Py_DECREF(value);
        value = type;
        #if PY_VERSION_HEX < 0x02050000
            if (PyInstance_Check(type)) {
                type = (PyObject*) ((PyInstanceObject*)type)->in_class;
                Py_INCREF(type);
            }
            else {
                type = 0;
                PyErr_SetString(PyExc_TypeError,
                    "raise: exception must be an old-style class or instance");
                goto raise_error;
            }
        #else
            type = (PyObject*) Py_TYPE(type);
            Py_INCREF(type);
            if (!PyType_IsSubtype((PyTypeObject *)type, (PyTypeObject *)PyExc_BaseException)) {
                PyErr_SetString(PyExc_TypeError,
                    "raise: exception class must be a subclass of BaseException");
                goto raise_error;
            }
        #endif
    }
    __Pyx_ErrRestore(type, value, tb);
    return;
raise_error:
    Py_XDECREF(value);
    Py_XDECREF(type);
    Py_XDECREF(tb);
    return;
}

static INLINE void __Pyx_ErrRestore(PyObject *type, PyObject *value, PyObject *tb) {
    PyObject *tmp_type, *tmp_value, *tmp_tb;
    PyThreadState *tstate = PyThreadState_GET();

    tmp_type = tstate->curexc_type;
    tmp_value = tstate->curexc_value;
    tmp_tb = tstate->curexc_traceback;
    tstate->curexc_type = type;
    tstate->curexc_value = value;
    tstate->curexc_traceback = tb;
    Py_XDECREF(tmp_type);
    Py_XDECREF(tmp_value);
    Py_XDECREF(tmp_tb);
}

static INLINE void __Pyx_ErrFetch(PyObject **type, PyObject **value, PyObject **tb) {
    PyThreadState *tstate = PyThreadState_GET();
    *type = tstate->curexc_type;
    *value = tstate->curexc_value;
    *tb = tstate->curexc_traceback;

    tstate->curexc_type = 0;
    tstate->curexc_value = 0;
    tstate->curexc_traceback = 0;
}


#if PY_MAJOR_VERSION < 3
static PyObject *__Pyx_GetStdout(void) {
    PyObject *f = PySys_GetObject("stdout");
    if (!f) {
        PyErr_SetString(PyExc_RuntimeError, "lost sys.stdout");
    }
    return f;
}

static int __Pyx_Print(PyObject *arg_tuple, int newline) {
    PyObject *f;
    PyObject* v;
    int i;
    
    if (!(f = __Pyx_GetStdout()))
        return -1;
    for (i=0; i < PyTuple_GET_SIZE(arg_tuple); i++) {
        if (PyFile_SoftSpace(f, 1)) {
            if (PyFile_WriteString(" ", f) < 0)
                return -1;
        }
        v = PyTuple_GET_ITEM(arg_tuple, i);
        if (PyFile_WriteObject(v, f, Py_PRINT_RAW) < 0)
            return -1;
        if (PyString_Check(v)) {
            char *s = PyString_AsString(v);
            Py_ssize_t len = PyString_Size(v);
            if (len > 0 &&
                isspace(Py_CHARMASK(s[len-1])) &&
                s[len-1] != ' ')
                    PyFile_SoftSpace(f, 0);
        }
    }
    if (newline) {
        if (PyFile_WriteString("\n", f) < 0)
            return -1;
        PyFile_SoftSpace(f, 0);
    }
    return 0;
}

#else /* Python 3 has a print function */
static int __Pyx_Print(PyObject *arg_tuple, int newline) {
    PyObject* kwargs = 0;
    PyObject* result = 0;
    PyObject* end_string;
    if (!__pyx_print) {
        __pyx_print = PyObject_GetAttrString(__pyx_b, "print");
        if (!__pyx_print)
            return -1;
    }
    if (!newline) {
        if (!__pyx_print_kwargs) {
            __pyx_print_kwargs = PyDict_New();
            if (!__pyx_print_kwargs)
                return -1;
            end_string = PyUnicode_FromStringAndSize(" ", 1);
            if (!end_string)
                return -1;
            if (PyDict_SetItemString(__pyx_print_kwargs, "end", end_string) < 0) {
                Py_DECREF(end_string);
                return -1;
            }
            Py_DECREF(end_string);
        }
        kwargs = __pyx_print_kwargs;
    }
    result = PyObject_Call(__pyx_print, arg_tuple, kwargs);
    if (!result)
        return -1;
    Py_DECREF(result);
    return 0;
}
#endif

static void __Pyx_WriteUnraisable(const char *name) {
    PyObject *old_exc, *old_val, *old_tb;
    PyObject *ctx;
    __Pyx_ErrFetch(&old_exc, &old_val, &old_tb);
    #if PY_MAJOR_VERSION < 3
    ctx = PyString_FromString(name);
    #else
    ctx = PyUnicode_FromString(name);
    #endif
    __Pyx_ErrRestore(old_exc, old_val, old_tb);
    if (!ctx) {
        PyErr_WriteUnraisable(Py_None);
    } else {
        PyErr_WriteUnraisable(ctx);
        Py_DECREF(ctx);
    }
}

static int __Pyx_SetVtable(PyObject *dict, void *vtable) {
    PyObject *pycobj = 0;
    int result;
    
    pycobj = PyCObject_FromVoidPtr(vtable, 0);
    if (!pycobj)
        goto bad;
    if (PyDict_SetItemString(dict, "__pyx_vtable__", pycobj) < 0)
        goto bad;
    result = 0;
    goto done;

bad:
    result = -1;
done:
    Py_XDECREF(pycobj);
    return result;
}

#include "compile.h"
#include "frameobject.h"
#include "traceback.h"

static void __Pyx_AddTraceback(const char *funcname) {
    PyObject *py_srcfile = 0;
    PyObject *py_funcname = 0;
    PyObject *py_globals = 0;
    PyObject *empty_string = 0;
    PyCodeObject *py_code = 0;
    PyFrameObject *py_frame = 0;

    #if PY_MAJOR_VERSION < 3
    py_srcfile = PyString_FromString(__pyx_filename);
    #else
    py_srcfile = PyUnicode_FromString(__pyx_filename);
    #endif
    if (!py_srcfile) goto bad;
    if (__pyx_clineno) {
        #if PY_MAJOR_VERSION < 3
        py_funcname = PyString_FromFormat( "%s (%s:%d)", funcname, __pyx_cfilenm, __pyx_clineno);
        #else
        py_funcname = PyUnicode_FromFormat( "%s (%s:%d)", funcname, __pyx_cfilenm, __pyx_clineno);
        #endif
    }
    else {
        #if PY_MAJOR_VERSION < 3
        py_funcname = PyString_FromString(funcname);
        #else
        py_funcname = PyUnicode_FromString(funcname);
        #endif
    }
    if (!py_funcname) goto bad;
    py_globals = PyModule_GetDict(__pyx_m);
    if (!py_globals) goto bad;
    #if PY_MAJOR_VERSION < 3
    empty_string = PyString_FromStringAndSize("", 0);
    #else
    empty_string = PyBytes_FromStringAndSize("", 0);
    #endif
    if (!empty_string) goto bad;
    py_code = PyCode_New(
        0,            /*int argcount,*/
        #if PY_MAJOR_VERSION >= 3
        0,            /*int kwonlyargcount,*/
        #endif
        0,            /*int nlocals,*/
        0,            /*int stacksize,*/
        0,            /*int flags,*/
        empty_string, /*PyObject *code,*/
        __pyx_empty_tuple,  /*PyObject *consts,*/
        __pyx_empty_tuple,  /*PyObject *names,*/
        __pyx_empty_tuple,  /*PyObject *varnames,*/
        __pyx_empty_tuple,  /*PyObject *freevars,*/
        __pyx_empty_tuple,  /*PyObject *cellvars,*/
        py_srcfile,   /*PyObject *filename,*/
        py_funcname,  /*PyObject *name,*/
        __pyx_lineno,   /*int firstlineno,*/
        empty_string  /*PyObject *lnotab*/
    );
    if (!py_code) goto bad;
    py_frame = PyFrame_New(
        PyThreadState_GET(), /*PyThreadState *tstate,*/
        py_code,             /*PyCodeObject *code,*/
        py_globals,          /*PyObject *globals,*/
        0                    /*PyObject *locals*/
    );
    if (!py_frame) goto bad;
    py_frame->f_lineno = __pyx_lineno;
    PyTraceBack_Here(py_frame);
bad:
    Py_XDECREF(py_srcfile);
    Py_XDECREF(py_funcname);
    Py_XDECREF(empty_string);
    Py_XDECREF(py_code);
    Py_XDECREF(py_frame);
}

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t) {
    while (t->p) {
        #if PY_MAJOR_VERSION < 3
        if (t->is_unicode && (!t->is_identifier)) {
            *t->p = PyUnicode_DecodeUTF8(t->s, t->n - 1, NULL);
        } else if (t->intern) {
            *t->p = PyString_InternFromString(t->s);
        } else {
            *t->p = PyString_FromStringAndSize(t->s, t->n - 1);
        }
        #else  /* Python 3+ has unicode identifiers */
        if (t->is_identifier || (t->is_unicode && t->intern)) {
            *t->p = PyUnicode_InternFromString(t->s);
        } else if (t->is_unicode) {
            *t->p = PyUnicode_FromStringAndSize(t->s, t->n - 1);
        } else {
            *t->p = PyBytes_FromStringAndSize(t->s, t->n - 1);
        }
        #endif
        if (!*t->p)
            return -1;
        ++t;
    }
    return 0;
}

/* Type Conversion Functions */

static INLINE Py_ssize_t __pyx_PyIndex_AsSsize_t(PyObject* b) {
  Py_ssize_t ival;
  PyObject* x = PyNumber_Index(b);
  if (!x) return -1;
  ival = PyInt_AsSsize_t(x);
  Py_DECREF(x);
  return ival;
}

static INLINE int __Pyx_PyObject_IsTrue(PyObject* x) {
   if (x == Py_True) return 1;
   else if (x == Py_False) return 0;
   else return PyObject_IsTrue(x);
}

static INLINE PY_LONG_LONG __pyx_PyInt_AsLongLong(PyObject* x) {
    if (PyInt_CheckExact(x)) {
        return PyInt_AS_LONG(x);
    }
    else if (PyLong_CheckExact(x)) {
        return PyLong_AsLongLong(x);
    }
    else {
        PY_LONG_LONG val;
        PyObject* tmp = PyNumber_Int(x); if (!tmp) return (PY_LONG_LONG)-1;
        val = __pyx_PyInt_AsLongLong(tmp);
        Py_DECREF(tmp);
        return val;
    }
}

static INLINE unsigned PY_LONG_LONG __pyx_PyInt_AsUnsignedLongLong(PyObject* x) {
    if (PyInt_CheckExact(x)) {
        long val = PyInt_AS_LONG(x);
        if (unlikely(val < 0)) {
            PyErr_SetString(PyExc_TypeError, "Negative assignment to unsigned type.");
            return (unsigned PY_LONG_LONG)-1;
        }
        return val;
    }
    else if (PyLong_CheckExact(x)) {
        return PyLong_AsUnsignedLongLong(x);
    }
    else {
        PY_LONG_LONG val;
        PyObject* tmp = PyNumber_Int(x); if (!tmp) return (PY_LONG_LONG)-1;
        val = __pyx_PyInt_AsUnsignedLongLong(tmp);
        Py_DECREF(tmp);
        return val;
    }
}


static INLINE unsigned char __pyx_PyInt_unsigned_char(PyObject* x) {
    if (sizeof(unsigned char) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        unsigned char val = (unsigned char)long_val;
        if (unlikely((val != long_val)  || (long_val < 0))) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to unsigned char");
            return (unsigned char)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE unsigned short __pyx_PyInt_unsigned_short(PyObject* x) {
    if (sizeof(unsigned short) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        unsigned short val = (unsigned short)long_val;
        if (unlikely((val != long_val)  || (long_val < 0))) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to unsigned short");
            return (unsigned short)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE char __pyx_PyInt_char(PyObject* x) {
    if (sizeof(char) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        char val = (char)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to char");
            return (char)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE short __pyx_PyInt_short(PyObject* x) {
    if (sizeof(short) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        short val = (short)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to short");
            return (short)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE int __pyx_PyInt_int(PyObject* x) {
    if (sizeof(int) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        int val = (int)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to int");
            return (int)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE long __pyx_PyInt_long(PyObject* x) {
    if (sizeof(long) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        long val = (long)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to long");
            return (long)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE signed char __pyx_PyInt_signed_char(PyObject* x) {
    if (sizeof(signed char) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        signed char val = (signed char)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to signed char");
            return (signed char)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE signed short __pyx_PyInt_signed_short(PyObject* x) {
    if (sizeof(signed short) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        signed short val = (signed short)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to signed short");
            return (signed short)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE signed int __pyx_PyInt_signed_int(PyObject* x) {
    if (sizeof(signed int) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        signed int val = (signed int)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to signed int");
            return (signed int)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE signed long __pyx_PyInt_signed_long(PyObject* x) {
    if (sizeof(signed long) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        signed long val = (signed long)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to signed long");
            return (signed long)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE long double __pyx_PyInt_long_double(PyObject* x) {
    if (sizeof(long double) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        long double val = (long double)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to long double");
            return (long double)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

