"""GP testing code"""
import unittest
import scipy as SP
import pdb
import limix

class CGPbase_test(unittest.TestCase):
    """test class for GPbase"""
    
    def genY(self):
        self.y=SP.random.multivariate_normal(SP.zeros(self.n_samples),(self.gp.getCovar()).K()+(self.gp.getLik()).K())
    
    def setXy(self):
        self.X = SP.array([[  4.17022005e-01,   7.20324493e-01], [  1.14374817e-04,   3.02332573e-01], [  1.46755891e-01,   9.23385948e-02], [  1.86260211e-01,   3.45560727e-01], [  3.96767474e-01,   5.38816734e-01], [  4.19194514e-01,   6.85219500e-01], [  2.04452250e-01,   8.78117436e-01], [  2.73875932e-02,   6.70467510e-01], [  4.17304802e-01,   5.58689828e-01], [  1.40386939e-01,   1.98101489e-01], [  8.00744569e-01,   9.68261576e-01], [  3.13424178e-01,   6.92322616e-01], [  8.76389152e-01,   8.94606664e-01], [  8.50442114e-02,   3.90547832e-02], [  1.69830420e-01,   8.78142503e-01], [  9.83468338e-02,   4.21107625e-01], [  9.57889530e-01,   5.33165285e-01], [  6.91877114e-01,   3.15515631e-01], [  6.86500928e-01,   8.34625672e-01], [  1.82882773e-02,   7.50144315e-01], [  9.88861089e-01,   7.48165654e-01], [  2.80443992e-01,   7.89279328e-01], [  1.03226007e-01,   4.47893526e-01], [  9.08595503e-01,   2.93614148e-01], [  2.87775339e-01,   1.30028572e-01], [  1.93669579e-02,   6.78835533e-01], [  2.11628116e-01,   2.65546659e-01], [  4.91573159e-01,   5.33625451e-02], [  5.74117605e-01,   1.46728575e-01], [  5.89305537e-01,   6.99758360e-01], [  1.02334429e-01,   4.14055988e-01], [  6.94400158e-01,   4.14179270e-01], [  4.99534589e-02,   5.35896406e-01], [  6.63794645e-01,   5.14889112e-01], [  9.44594756e-01,   5.86555041e-01], [  9.03401915e-01,   1.37474704e-01], [  1.39276347e-01,   8.07391289e-01], [  3.97676837e-01,   1.65354197e-01], [  9.27508580e-01,   3.47765860e-01], [  7.50812103e-01,   7.25997985e-01], [  8.83306091e-01,   6.23672207e-01], [  7.50942434e-01,   3.48898342e-01], [  2.69927892e-01,   8.95886218e-01], [  4.28091190e-01,   9.64840047e-01], [  6.63441498e-01,   6.21695720e-01], [  1.14745973e-01,   9.49489259e-01], [  4.49912133e-01,   5.78389614e-01], [  4.08136803e-01,   2.37026980e-01], [  9.03379521e-01,   5.73679487e-01], [  2.87032703e-03,   6.17144914e-01], [  3.26644902e-01,   5.27058102e-01], [  8.85942099e-01,   3.57269760e-01], [  9.08535151e-01,   6.23360116e-01], [  1.58212428e-02,   9.29437234e-01], [  6.90896918e-01,   9.97322850e-01], [  1.72340508e-01,   1.37135750e-01], [  9.32595463e-01,   6.96818161e-01], [  6.60001727e-02,   7.55463053e-01], [  7.53876188e-01,   9.23024536e-01], [  7.11524759e-01,   1.24270962e-01], [  1.98801338e-02,   2.62109869e-02], [  2.83064880e-02,   2.46211068e-01], [  8.60027949e-01,   5.38831064e-01], [  5.52821979e-01,   8.42030892e-01], [  1.24173315e-01,   2.79183679e-01], [  5.85759271e-01,   9.69595748e-01], [  5.61030219e-01,   1.86472894e-02], [  8.00632673e-01,   2.32974274e-01], [  8.07105196e-01,   3.87860644e-01], [  8.63541855e-01,   7.47121643e-01], [  5.56240234e-01,   1.36455226e-01], [  5.99176895e-02,   1.21343456e-01], [  4.45518785e-02,   1.07494129e-01], [  2.25709339e-01,   7.12988980e-01], [  5.59716982e-01,   1.25559802e-02], [  7.19742797e-02,   9.67276330e-01], [  5.68100462e-01,   2.03293235e-01], [  2.52325745e-01,   7.43825854e-01], [  1.95429481e-01,   5.81358927e-01], [  9.70019989e-01,   8.46828801e-01], [  2.39847759e-01,   4.93769714e-01], [  6.19955718e-01,   8.28980900e-01], [  1.56791395e-01,   1.85762022e-02], [  7.00221437e-02,   4.86345111e-01], [  6.06329462e-01,   5.68851437e-01], [  3.17362409e-01,   9.88616154e-01], [  5.79745219e-01,   3.80141173e-01], [  5.50948219e-01,   7.45334431e-01], [  6.69232893e-01,   2.64919558e-01], [  6.63348344e-02,   3.70084198e-01], [  6.29717507e-01,   2.10174010e-01], [  7.52755554e-01,   6.65364814e-02], [  2.60315099e-01,   8.04754564e-01], [  1.93434283e-01,   6.39460881e-01], [  5.24670309e-01,   9.24807970e-01], [  2.63296770e-01,   6.59610907e-02], [  7.35065963e-01,   7.72178030e-01], [  9.07815853e-01,   9.31972069e-01], [  1.39515730e-02,   2.34362086e-01], [  6.16778357e-01,   9.49016321e-01]])
        self.y = SP.array([-0.71813811, -0.87132633, -0.55221825, -0.76143538,  0.32665563, -0.52577131,  0.08715191,  0.27576954,  0.2396441 , -0.01023052, 0.23417342, -0.21772382,  0.7876279 ,  0.07863127,  0.8211451 , -0.83034626, -0.09973239, -0.6213197 , -1.33151403, -0.51427023, 0.45145551, -0.64892621,  0.16860742, -0.39005358,  0.0104367 , 0.26968897, -0.79161791, -0.08889201, -0.35272451,  0.0900443 , 0.09729085, -0.51150775, -0.19239034, -0.54594752,  1.26526575, 0.05687017, -0.63361896,  0.04209649,  0.49351934,  0.56170944, -0.0228951 , -0.10378452,  0.29715608,  0.02480608,  0.22612267, 0.86284674, -0.66502599, -0.57364664,  0.56592466, -1.4542857 , -0.83662431,  0.31389178,  0.22025054,  0.5936773 , -0.41488766, -0.3232744 ,  0.77308105, -0.45617656, -0.44226108,  0.6922689 , 0.19464869, -1.07210658,  1.14713629, -0.08447224, -0.88609049, 0.33348401,  0.45049461,  0.22065147,  0.43156614, -1.26626172, -0.05300464, -0.43680686, -0.60522858, -0.52789777, -0.59424874, 0.26176259,  0.86856046,  0.14417847, -0.76724645,  0.24411673, -0.69474903, -0.00563661,  0.28793388,  0.92240366,  0.47117432, -0.07365165, -0.3494802 ,  0.27921738, -0.5899348 , -0.63780556, 0.42777908,  0.81411717,  0.04515307, -0.55968509,  0.11871646, 0.53280453,  0.56976855,  0.20601629, -0.62494561, -0.10978169])
    
    def setUp(self):
        SP.random.seed(1)
        self.n_dimensions=2
        self.n_samples = 100
        self.setXy()
        #self.X = SP.rand(self.n_samples,self.n_dimensions)
        covar  = limix.CCovSqexpARD(self.n_dimensions)
        ll  = limix.CLikNormalIso()
        covar_params = SP.array([1,1,1])
        lik_params   = SP.array([0.5])
        hyperparams0 = limix.CGPHyperParams()
        hyperparams0['covar'] = covar_params
        hyperparams0['lik'] = lik_params
        self.constrainU = limix.CGPHyperParams()
        self.constrainL = limix.CGPHyperParams()
        self.constrainU['covar'] = +10*SP.ones_like(covar_params);
        self.constrainL['covar'] = 0*SP.ones_like(covar_params);
        self.constrainU['lik'] = +5*SP.ones_like(lik_params);
        self.constrainL['lik'] = 0*SP.ones_like(lik_params);

        self.gp=limix.CGPbase(covar,ll)
        self.gp.setX(self.X)
        self.gp.setParams(hyperparams0)
        #self.genY()
        self.gp.setY(self.y)
    
    def test_fit(self):
        #create optimization object
        self.gpopt = limix.CGPopt(self.gp)
        self.gpopt.setOptBoundLower(self.constrainL);
        self.gpopt.setOptBoundUpper(self.constrainU);
        #run
        self.gpopt.opt()
        params = SP.concatenate((self.gp.getParams()['covar'],self.gp.getParams()['lik']))[:,0]
        params_true = SP.array([0.28822188,  0.35271548,  0.13709146,  0.49447424])
        RV = ((params-params_true)**2).max()<1e-6
        RV = RV & (SP.absolute(self.gp.LMLgrad()['lik']).max()<1E-4)
        RV = RV & (SP.absolute(self.gp.LMLgrad()['covar']).max()<1E-4)

        self.assertTrue(RV)

if __name__ == '__main__':
    unittest.main()


