#!/usr/bin/env python
#
# Copyright (C) 2010 Linaro Limited
#
# Author: Zygmunt Krynicki <zygmunt.krynicki@linaro.org>
#
# This file is part of linaro-dashboard-bundle.
#
# linaro-dashboard-bundle is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation
#
# linaro-dashboard-bundle is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with linaro-dashboard-bundle.  If not, see <http://www.gnu.org/licenses/>.

from setuptools import setup, find_packages

import linaro_dashboard_bundle


setup(
    name = 'linaro-dashboard-bundle',
    version = str(linaro_dashboard_bundle.__version__),
    author = "Zygmunt Krynicki",
    author_email = "zygmunt.krynicki@linaro.org",
    description = "Dashboard bundle manipulation utilities developed by the Linaro infrastructure team",
    packages = find_packages(),
    package_data = {
        'linaro_dashboard_bundle': [
            'schemas/*.json',
            'test_documents/*.json',
        ],
    },
    install_requires = [
        'distribute',
        'linaro-json >= 1.2',
        'versiontools >= 1.0.2',
    ],
    setup_requires = [
        'versiontools >= 1.0.2',
    ],
    tests_require = [
        'testtools',
        'testscenarios',
    ],
    url = 'https://launchpad.net/linaro-python-dashboard-bundle',
    test_suite = 'linaro_dashboard_bundle.tests',
    classifiers = [
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 2.6",
        "Topic :: Software Development :: Testing",
    ],
    zip_safe = True,
)
