import linfir.mdtex as mdtex
import os.path
import sys


def handle_file(filename):
    fname, _ = os.path.splitext(filename)
    src = open(filename).read()

    try:
        native = mdtex.parse(src)
    except mdtex.ParseError as e:
        print("File {}: Parse error.\n    {}".format(filename, e))
        return

    src2 = mdtex.render.MD().render(native)
    html = mdtex.render.HTML().full_doc(native, fname + ".pdf")
    tex = mdtex.render.LaTeX().full_doc(native)

    if native != mdtex.parse(src2):
        print("File {}: "
              + "Non idempotent transformation, aborting.".format(filename))
        return

    if src != src2:
        print("Cleaning {}".format(filename))
        with open(filename, 'w') as f:
            f.write(src2)

    with open(fname + ".html", 'w') as f:
        f.write(html)
    with open(fname + ".tex", 'w') as f:
        f.write(tex)


def main():
    for x in sys.argv[1:]:
        handle_file(x)


if __name__ == '__main__':
    main()
