import re

Matrixes = { "Matrix": "pmatrix", "Det": "vmatrix" }

repeat_max = 10

class repeatTooMany(Exception):
    pass

def repeat(f):
    def g(x):
        for n in range(repeat_max):
            y = f(x)
            n += 1
            if x == y:
                return x
            x = y
        raise repeatTooMany
    return g

@repeat
def process_matrix(x):
    m = re.search(r"\\(Matrix|Det)\s*\{", x)
    if not m:
        return x

    env = Matrixes[m.group(1)]
    out = x[:m.start(0)] + "\\begin{" + env + "} "
    rest = x[m.end(0):]
    depth = 1
    quoted = False

    for i, c in enumerate(rest):
        if quoted:
            out += "\\" + c
            quoted = False
        elif c == "\\":
            quoted = True
        elif c == "{":
            depth += 1
            out += c
        elif c == "}":
            depth -= 1
            if depth == 0:
                return out + " \\end{" + env + "}" + rest[i+1:]
            out += c
        elif c == "," and depth == 1:
            out += " & "
        elif c == ";" and depth == 1:
            out += " \\\\ "
        else:
            out += c

    raise BadMatrix(x)
