import re

__all__ = ['safe_join', 'preprocess']

TAB_SIZE = 4
R_line_end = re.compile(r"\r\n|\n\r|\r|\n")
R_weird_space = re.compile(r"(?![\t ])\s")
R_tab = re.compile(r"\t")
R_needspc1 = re.compile(r"\\[a-zA-Z]\Z")
R_needspc2 = re.compile(r"[a-zA-Z]")


def safe_join(L):
    L2 = []
    spc = False
    for x in L:
        if not x:
            continue
        if spc and R_needspc2.match(x):
            L2.append(' ')
        L2.append(x)
        spc = R_needspc1.search(x)
    if spc:
        L2.append(' ')
    return ''.join(L2)


def preprocess(txt):
    lines = R_line_end.split(txt.rstrip())
    lines = [preprocess_line(line) + '\n' for line in lines]
    return ''.join(lines)


def preprocess_line(src):
    L = []
    for x in R_tab.split(R_weird_space.sub(' ', src.rstrip())):
        L.append(x)
        n = TAB_SIZE - len(x) % TAB_SIZE
        L.append(n * ' ')
    return ''.join(L).rstrip()
